/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils.library;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.LibraryDependencyScopeSuggester;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableModelsProvider;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.ui.configuration.libraries.LibraryEditingUtil;
import com.intellij.openapi.util.Comparing;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryDescription;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryType;
import org.jetbrains.idea.maven.utils.library.RepositoryUtils;
import org.jetbrains.idea.maven.utils.library.propertiesEditor.RepositoryLibraryPropertiesModel;

public class RepositoryLibrarySupport {
    @NotNull
    private Project project;
    @NotNull
    private RepositoryLibraryPropertiesModel model;
    @NotNull
    private RepositoryLibraryDescription libraryDescription;

    public RepositoryLibrarySupport(@NotNull Project project, @NotNull RepositoryLibraryDescription libraryDescription, @NotNull RepositoryLibraryPropertiesModel model) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/maven/utils/library/RepositoryLibrarySupport", "<init>"));
        }
        if (libraryDescription == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryDescription", "org/jetbrains/idea/maven/utils/library/RepositoryLibrarySupport", "<init>"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "org/jetbrains/idea/maven/utils/library/RepositoryLibrarySupport", "<init>"));
        }
        this.project = project;
        this.libraryDescription = libraryDescription;
        this.model = model;
    }

    public void addSupport(@NotNull Module module, @NotNull ModifiableRootModel rootModel, @NotNull ModifiableModelsProvider modifiableModelsProvider) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/idea/maven/utils/library/RepositoryLibrarySupport", "addSupport"));
        }
        if (rootModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootModel", "org/jetbrains/idea/maven/utils/library/RepositoryLibrarySupport", "addSupport"));
        }
        if (modifiableModelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifiableModelsProvider", "org/jetbrains/idea/maven/utils/library/RepositoryLibrarySupport", "addSupport"));
        }
        LibraryTable.ModifiableModel modifiableModel = modifiableModelsProvider.getLibraryTableModifiableModel(module.getProject());
        Library library = (Library)Iterables.find(Arrays.asList(modifiableModel.getLibraries()), (Predicate)new Predicate<Library>(){

            public boolean apply(@Nullable Library library) {
                return RepositoryLibrarySupport.this.isLibraryEqualsToSelected(library);
            }
        }, null);
        if (library == null) {
            library = this.createNewLibrary(module, modifiableModel);
        } else {
            modifiableModelsProvider.disposeLibraryTableModifiableModel(modifiableModel);
        }
        final DependencyScope dependencyScope = LibraryDependencyScopeSuggester.getDefaultScope((Library)library);
        ModifiableRootModel moduleModifiableModel = modifiableModelsProvider.getModuleModifiableModel(module);
        LibraryOrderEntry foundEntry = (LibraryOrderEntry)Iterables.find(Arrays.asList(moduleModifiableModel.getOrderEntries()), (Predicate)new Predicate<OrderEntry>(){

            public boolean apply(@Nullable OrderEntry entry) {
                return entry instanceof LibraryOrderEntry && ((LibraryOrderEntry)entry).getScope() == dependencyScope && RepositoryLibrarySupport.this.isLibraryEqualsToSelected(((LibraryOrderEntry)entry).getLibrary());
            }
        }, null);
        modifiableModelsProvider.disposeModuleModifiableModel(moduleModifiableModel);
        if (foundEntry == null) {
            rootModel.addLibraryEntry(library).setScope(dependencyScope);
        }
    }

    private LibraryEx createNewLibrary(@NotNull Module module, final LibraryTable.ModifiableModel modifiableModel) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/idea/maven/utils/library/RepositoryLibrarySupport", "createNewLibrary"));
        }
        RepositoryLibraryProperties libraryProperties = new RepositoryLibraryProperties(this.libraryDescription.getGroupId(), this.libraryDescription.getArtifactId(), this.model.getVersion());
        LibraryEx library = (LibraryEx)modifiableModel.createLibrary(LibraryEditingUtil.suggestNewLibraryName((LibraryTable.ModifiableModel)modifiableModel, (String)RepositoryLibraryType.getInstance().getDescription(libraryProperties)), RepositoryLibraryType.REPOSITORY_LIBRARY_KIND);
        RepositoryLibraryProperties realLibraryProperties = (RepositoryLibraryProperties)library.getProperties();
        realLibraryProperties.setMavenId(libraryProperties.getMavenId());
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                modifiableModel.commit();
            }
        });
        RepositoryUtils.loadDependencies(module.getProject(), library, this.model.isDownloadSources(), this.model.isDownloadJavaDocs(), null);
        return library;
    }

    private boolean isLibraryEqualsToSelected(Library library) {
        if (!(library instanceof LibraryEx)) {
            return false;
        }
        LibraryEx libraryEx = (LibraryEx)library;
        if (!RepositoryLibraryType.REPOSITORY_LIBRARY_KIND.equals((Object)libraryEx.getKind())) {
            return false;
        }
        LibraryProperties libraryProperties = libraryEx.getProperties();
        if (libraryProperties == null || !(libraryProperties instanceof RepositoryLibraryProperties)) {
            return false;
        }
        RepositoryLibraryProperties repositoryLibraryProperties = (RepositoryLibraryProperties)libraryProperties;
        RepositoryLibraryDescription description = RepositoryLibraryDescription.findDescription(repositoryLibraryProperties);
        if (!description.equals(this.libraryDescription)) {
            return false;
        }
        return Comparing.equal((String)repositoryLibraryProperties.getVersion(), (String)this.model.getVersion());
    }
}

