/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.settings;

import com.google.common.base.Objects;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="GradleSystemRunningSettings", storages={@Storage(file="$APP_CONFIG$/gradle.run.settings.xml")})
public class GradleSystemRunningSettings
implements PersistentStateComponent<MyState> {
    @Nullable
    private PreferredTestRunner myPreferredTestRunner = PreferredTestRunner.PLATFORM_TEST_RUNNER;

    @NotNull
    public static GradleSystemRunningSettings getInstance() {
        GradleSystemRunningSettings gradleSystemRunningSettings = (GradleSystemRunningSettings)ServiceManager.getService(GradleSystemRunningSettings.class);
        if (gradleSystemRunningSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/settings/GradleSystemRunningSettings", "getInstance"));
        }
        return gradleSystemRunningSettings;
    }

    @Nullable
    public MyState getState() {
        MyState state = new MyState();
        state.preferredTestRunner = this.myPreferredTestRunner;
        return state;
    }

    public void loadState(MyState state) {
        this.myPreferredTestRunner = state.preferredTestRunner;
    }

    @Nullable
    public PreferredTestRunner getPreferredTestRunner() {
        return this.myPreferredTestRunner;
    }

    public void setPreferredTestRunner(@Nullable PreferredTestRunner preferredTestRunner) {
        this.myPreferredTestRunner = preferredTestRunner;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GradleSystemRunningSettings)) {
            return false;
        }
        GradleSystemRunningSettings settings = (GradleSystemRunningSettings)o;
        return Objects.equal((Object)((Object)this.myPreferredTestRunner), (Object)((Object)settings.myPreferredTestRunner));
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.myPreferredTestRunner});
    }

    public static enum PreferredTestRunner {
        PLATFORM_TEST_RUNNER,
        GRADLE_TEST_RUNNER;

    }

    public static class MyState {
        public PreferredTestRunner preferredTestRunner;
    }
}

