/*
 * Decompiled with CFR 0.152.
 */
package com.jediterm.terminal;

import com.jediterm.terminal.Questioner;
import com.jediterm.terminal.TtyConnector;
import java.awt.Dimension;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;

public abstract class ProcessTtyConnector
implements TtyConnector {
    protected final InputStream myInputStream;
    protected final OutputStream myOutputStream;
    protected final InputStreamReader myReader;
    protected Charset myCharset;
    private Dimension myPendingTermSize;
    private Dimension myPendingPixelSize;
    private Process myProcess;

    public ProcessTtyConnector(@NotNull Process process, Charset charset) {
        this.myOutputStream = process.getOutputStream();
        this.myCharset = charset;
        this.myInputStream = process.getInputStream();
        this.myReader = new InputStreamReader(this.myInputStream, charset);
        this.myProcess = process;
    }

    public void resize(Dimension termSize, Dimension pixelSize) {
        this.setPendingTermSize(termSize);
        this.setPendingPixelSize(pixelSize);
        if (this.isConnected()) {
            this.resizeImmediately();
            this.setPendingTermSize(null);
            this.setPendingPixelSize(null);
        }
    }

    protected abstract void resizeImmediately();

    public abstract String getName();

    public int read(char[] buf, int offset, int length) throws IOException {
        return this.myReader.read(buf, offset, length);
    }

    public void write(byte[] bytes) throws IOException {
        this.myOutputStream.write(bytes);
        this.myOutputStream.flush();
    }

    public abstract boolean isConnected();

    public void write(String string) throws IOException {
        this.write(string.getBytes(this.myCharset));
    }

    protected void setPendingTermSize(Dimension pendingTermSize) {
        this.myPendingTermSize = pendingTermSize;
    }

    protected void setPendingPixelSize(Dimension pendingPixelSize) {
        this.myPendingPixelSize = pendingPixelSize;
    }

    protected Dimension getPendingTermSize() {
        return this.myPendingTermSize;
    }

    protected Dimension getPendingPixelSize() {
        return this.myPendingPixelSize;
    }

    public boolean init(Questioner q) {
        return this.isConnected();
    }

    public void close() {
        this.myProcess.destroy();
        try {
            this.myOutputStream.close();
        }
        catch (IOException ignored) {
            // empty catch block
        }
        try {
            this.myInputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int waitFor() throws InterruptedException {
        return this.myProcess.waitFor();
    }
}

