/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.smiles;

import java.util.Arrays;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.P3;
import javajs.util.SB;
import javajs.util.T3;
import org.jmol.java.BS;
import org.jmol.smiles.InvalidSmilesException;
import org.jmol.smiles.SmilesAromatic;
import org.jmol.smiles.SmilesAtom;
import org.jmol.smiles.SmilesBond;
import org.jmol.smiles.SmilesMeasure;
import org.jmol.smiles.SmilesParser;
import org.jmol.smiles.SmilesStereo;
import org.jmol.smiles.VTemp;
import org.jmol.util.BNode;
import org.jmol.util.BSUtil;
import org.jmol.util.Edge;
import org.jmol.util.JmolMolecule;
import org.jmol.util.Logger;
import org.jmol.util.Node;

public class SmilesSearch
extends JmolMolecule {
    private static final int INITIAL_ATOMS = 16;
    SmilesAtom[] patternAtoms = new SmilesAtom[16];
    String pattern;
    Node[] jmolAtoms;
    BNode[] bioAtoms;
    int jmolAtomCount;
    private BS bsSelected;
    BS bsRequired;
    boolean firstMatchOnly;
    boolean matchAllAtoms;
    boolean isSmarts;
    boolean isSmilesFind;
    boolean isTopology;
    SmilesSearch[] subSearches;
    boolean haveSelected;
    boolean haveBondStereochemistry;
    SmilesStereo stereo;
    boolean needRingData;
    boolean needAromatic = true;
    boolean needRingMemberships;
    int ringDataMax = Integer.MIN_VALUE;
    Lst<SmilesMeasure> measures = new Lst();
    int flags;
    SB ringSets;
    BS bsAromatic = new BS();
    BS bsAromatic5 = new BS();
    BS bsAromatic6 = new BS();
    SmilesAtom lastChainAtom;
    boolean asVector;
    boolean getMaps;
    SmilesSearch top = this;
    private boolean isSilent;
    private boolean isRingCheck;
    private int selectedAtomCount;
    private BS[] ringData;
    private int[] ringCounts;
    private int[] ringConnections;
    BS bsFound = new BS();
    private Map<String, Object> htNested;
    private int nNested;
    private SmilesBond nestedBond;
    private Lst<Object> vReturn;
    BS bsReturn = new BS();
    private boolean ignoreStereochemistry;
    boolean invertStereochemistry;
    private boolean noAromatic;
    private boolean aromaticDouble;
    private boolean noncanonical;
    private BS bsCheck;
    VTemp v = new VTemp();

    public String toString() {
        SB sB = new SB().append(this.pattern);
        sB.append("\nmolecular formula: " + this.getMolecularFormula(true, null, false));
        return sB.toString();
    }

    void setSelected(BS bS) {
        if (bS == null) {
            bS = BS.newN((int)this.jmolAtomCount);
            bS.setBits(0, this.jmolAtomCount);
        }
        this.bsSelected = bS;
    }

    void setAtomArray() {
        if (this.patternAtoms.length > this.ac) {
            this.patternAtoms = (SmilesAtom[])AU.arrayCopyObject((Object)this.patternAtoms, (int)this.ac);
        }
        this.nodes = this.patternAtoms;
    }

    SmilesAtom addAtom() {
        return this.appendAtom(new SmilesAtom());
    }

    SmilesAtom appendAtom(SmilesAtom smilesAtom) {
        if (this.ac >= this.patternAtoms.length) {
            this.patternAtoms = (SmilesAtom[])AU.doubleLength((Object)this.patternAtoms);
        }
        this.patternAtoms[this.ac] = smilesAtom.setIndex(this.ac++);
        return this.patternAtoms[this.ac];
    }

    int addNested(String string) {
        if (this.top.htNested == null) {
            this.top.htNested = new Hashtable<String, Object>();
        }
        this.setNested(++this.top.nNested, string);
        return this.top.nNested;
    }

    void clear() {
        this.bsReturn.clearAll();
        this.nNested = 0;
        this.htNested = null;
        this.nestedBond = null;
        this.clearBsFound(-1);
    }

    void setNested(int n, Object object) {
        this.top.htNested.put("_" + n, object);
    }

    Object getNested(int n) {
        return this.top.htNested.get("_" + n);
    }

    int getMissingHydrogenCount() {
        int n = 0;
        for (int i = 0; i < this.ac; ++i) {
            int n2 = this.patternAtoms[i].missingHydrogenCount;
            if (n2 < 0) continue;
            n += n2;
        }
        return n;
    }

    void setRingData(BS bS) throws InvalidSmilesException {
        if (this.isTopology) {
            this.needAromatic = false;
        }
        if (this.needAromatic) {
            this.needRingData = true;
        }
        boolean bl = (this.flags & 1) != 0;
        this.needAromatic &= bS == null & !bl;
        if (!this.needAromatic) {
            this.bsAromatic.clearAll();
            if (bS != null) {
                this.bsAromatic.or(bS);
            }
            if (!this.needRingMemberships && !this.needRingData) {
                return;
            }
        }
        this.getRingData(this.needRingData, this.flags, null);
    }

    void getRingData(boolean bl, int n, Lst<BS>[] lstArray) throws InvalidSmilesException {
        Object object;
        Object object2;
        int n2;
        boolean bl2;
        boolean bl3 = (n & 8) != 0;
        boolean bl4 = bl2 = (n & 0x10) != 0;
        if (bl3 && lstArray == null) {
            lstArray = AU.createArrayOfArrayList((int)4);
        }
        if (bl2 && this.needAromatic) {
            this.bsAromatic = SmilesAromatic.checkAromaticDefined(this.jmolAtoms, this.bsSelected);
            bl3 = false;
        }
        if (this.ringDataMax < 0) {
            this.ringDataMax = 8;
        }
        if (bl3 && this.ringDataMax < 6) {
            this.ringDataMax = 6;
        }
        if (bl) {
            this.ringCounts = new int[this.jmolAtomCount];
            this.ringConnections = new int[this.jmolAtomCount];
            this.ringData = new BS[this.ringDataMax + 1];
        }
        this.ringSets = new SB();
        String string = "****";
        while (string.length() < this.ringDataMax) {
            string = string + string;
        }
        Lst lst = null;
        for (n2 = 3; n2 <= this.ringDataMax; ++n2) {
            if (n2 > this.jmolAtomCount) continue;
            object2 = "*1" + string.substring(0, n2 - 2) + "*1";
            object = SmilesParser.getMolecule((String)object2, true);
            Lst lst2 = (Lst)this.subsearch((SmilesSearch)((Object)object), false, true);
            if (lstArray != null && n2 <= 5) {
                Lst lst3 = new Lst();
                int n3 = lst2.size();
                while (--n3 >= 0) {
                    lst3.addLast((Object)((BS)lst2.get(n3)));
                }
                lstArray[n2 - 3] = lst3;
            }
            if (this.needAromatic) {
                if (!(bl2 || bl3 && n2 != 5 && n2 != 6)) {
                    int n4 = lst2.size();
                    while (--n4 >= 0) {
                        BS bS = (BS)lst2.get(n4);
                        if (!bl2 && !SmilesAromatic.isFlatSp2Ring(this.jmolAtoms, this.bsSelected, bS, bl3 ? 0.1f : 0.01f)) continue;
                        this.bsAromatic.or(bS);
                    }
                }
                if (bl3) {
                    switch (n2) {
                        case 5: {
                            lst = lst2;
                            break;
                        }
                        case 6: {
                            if (bl2) {
                                this.bsAromatic = SmilesAromatic.checkAromaticDefined(this.jmolAtoms, this.bsAromatic);
                            } else {
                                SmilesAromatic.checkAromaticStrict(this.jmolAtoms, this.bsAromatic, (Lst<Object>)lst, (Lst<Object>)lst2);
                            }
                            lstArray[3] = new Lst();
                            this.setAromatic56((Lst<Object>)lst, this.bsAromatic5, 5, lstArray[3]);
                            this.setAromatic56((Lst<Object>)lst2, this.bsAromatic6, 6, lstArray[3]);
                        }
                    }
                }
            }
            if (!bl) continue;
            this.ringData[n2] = new BS();
            for (int i = 0; i < lst2.size(); ++i) {
                BS bS = (BS)lst2.get(i);
                this.ringData[n2].or(bS);
                int n5 = bS.nextSetBit(0);
                while (n5 >= 0) {
                    int n6 = n5;
                    this.ringCounts[n6] = this.ringCounts[n6] + 1;
                    n5 = bS.nextSetBit(n5 + 1);
                }
            }
        }
        if (bl) {
            n2 = this.bsSelected.nextSetBit(0);
            while (n2 >= 0) {
                object2 = this.jmolAtoms[n2];
                object = object2.getEdges();
                if (object != null) {
                    int n7 = ((Edge[])object).length;
                    while (--n7 >= 0) {
                        if (this.ringCounts[object2.getBondedAtomIndex(n7)] <= 0) continue;
                        int n8 = n2;
                        this.ringConnections[n8] = this.ringConnections[n8] + 1;
                    }
                }
                n2 = this.bsSelected.nextSetBit(n2 + 1);
            }
        }
    }

    private void setAromatic56(Lst<Object> lst, BS bS, int n, Lst<BS> lst2) {
        for (int i = 0; i < lst.size(); ++i) {
            BS bS2 = (BS)lst.get(i);
            this.v.bsTemp.clearAll();
            this.v.bsTemp.or(bS2);
            this.v.bsTemp.and(this.bsAromatic);
            if (this.v.bsTemp.cardinality() != n) continue;
            bS.or(bS2);
            if (lst2 == null) continue;
            lst2.addLast((Object)bS2);
        }
    }

    Object subsearch(SmilesSearch smilesSearch, boolean bl, boolean bl2) throws InvalidSmilesException {
        smilesSearch.ringSets = this.ringSets;
        smilesSearch.jmolAtoms = this.jmolAtoms;
        smilesSearch.bioAtoms = this.bioAtoms;
        smilesSearch.jmolAtomCount = this.jmolAtomCount;
        smilesSearch.bsSelected = this.bsSelected;
        smilesSearch.htNested = this.htNested;
        smilesSearch.isSmilesFind = this.isSmilesFind;
        smilesSearch.bsCheck = this.bsCheck;
        smilesSearch.isSmarts = true;
        smilesSearch.bsAromatic = this.bsAromatic;
        smilesSearch.bsAromatic5 = this.bsAromatic5;
        smilesSearch.bsAromatic6 = this.bsAromatic6;
        smilesSearch.ringData = this.ringData;
        smilesSearch.ringCounts = this.ringCounts;
        smilesSearch.ringConnections = this.ringConnections;
        if (bl) {
            smilesSearch.bsRequired = null;
            smilesSearch.firstMatchOnly = false;
            smilesSearch.matchAllAtoms = false;
        } else if (bl2) {
            smilesSearch.bsRequired = null;
            smilesSearch.isSilent = true;
            smilesSearch.isRingCheck = true;
            smilesSearch.asVector = true;
            smilesSearch.matchAllAtoms = false;
        } else {
            smilesSearch.haveSelected = this.haveSelected;
            smilesSearch.bsRequired = this.bsRequired;
            smilesSearch.firstMatchOnly = this.firstMatchOnly;
            smilesSearch.matchAllAtoms = this.matchAllAtoms;
            smilesSearch.getMaps = this.getMaps;
            smilesSearch.asVector = this.asVector;
            smilesSearch.vReturn = this.vReturn;
            smilesSearch.bsReturn = this.bsReturn;
        }
        return smilesSearch.search(bl);
    }

    Object search(boolean bl) throws InvalidSmilesException {
        this.ignoreStereochemistry = (this.flags & 2) != 0;
        this.invertStereochemistry = (this.flags & 4) != 0;
        this.noAromatic = (this.flags & 1) != 0;
        this.noncanonical = (this.flags & 0x40) != 0;
        boolean bl2 = this.aromaticDouble = (this.flags & 0x20) != 0;
        if (Logger.debugging && !this.isSilent) {
            Logger.debug((String)("SmilesSearch processing " + this.pattern));
        }
        if (this.vReturn == null && (this.asVector || this.getMaps)) {
            this.vReturn = new Lst();
        }
        if (this.bsSelected == null) {
            this.bsSelected = BS.newN((int)this.jmolAtomCount);
            this.bsSelected.setBits(0, this.jmolAtomCount);
        }
        this.selectedAtomCount = this.bsSelected.cardinality();
        if (this.subSearches != null) {
            for (int i = 0; i < this.subSearches.length; ++i) {
                if (this.subSearches[i] == null) continue;
                this.subsearch(this.subSearches[i], false, false);
                if (!this.firstMatchOnly || !(this.vReturn == null ? this.bsReturn.nextSetBit(0) >= 0 : this.vReturn.size() > 0)) {
                    continue;
                }
                break;
            }
        } else if (this.ac > 0) {
            this.checkMatch(null, -1, -1, bl);
        }
        return this.asVector || this.getMaps ? this.vReturn : this.bsReturn;
    }

    private final boolean checkMatch(SmilesAtom smilesAtom, int n, int n2, boolean bl) throws InvalidSmilesException {
        if (smilesAtom == null) {
            if (this.nestedBond == null) {
                this.clearBsFound(-1);
            } else {
                this.bsReturn.clearAll();
            }
        } else {
            int n3;
            if (this.bsFound.get(n2) || !this.bsSelected.get(n2)) {
                return true;
            }
            Node node = this.jmolAtoms[n2];
            if (!this.isRingCheck && !this.isTopology) {
                if (smilesAtom.atomsOr != null) {
                    for (int i = 0; i < smilesAtom.nAtomsOr; ++i) {
                        if (this.checkMatch(smilesAtom.atomsOr[i], n, n2, bl)) continue;
                        return false;
                    }
                    return true;
                }
                if (smilesAtom.primitives == null) {
                    if (!this.checkPrimitiveAtom(smilesAtom, n2)) {
                        return true;
                    }
                } else {
                    for (n3 = 0; n3 < smilesAtom.nPrimitives; ++n3) {
                        if (this.checkPrimitiveAtom(smilesAtom.primitives[n3], n2)) continue;
                        return true;
                    }
                }
            }
            Edge[] edgeArray = node.getEdges();
            n3 = smilesAtom.getBondCount();
            block5: while (--n3 >= 0) {
                int n4;
                SmilesBond smilesBond = smilesAtom.getBond(n3);
                if (smilesBond.getAtomIndex2() != smilesAtom.index) continue;
                SmilesAtom smilesAtom2 = smilesBond.atom1;
                int n5 = smilesAtom2.getMatchingAtomIndex();
                switch (smilesBond.order) {
                    case 96: 
                    case 112: {
                        if (this.checkMatchBond(smilesAtom, smilesAtom2, smilesBond, n2, n5, null)) continue block5;
                        return true;
                    }
                }
                for (n4 = 0; n4 < edgeArray.length && (edgeArray[n4].getAtomIndex1() != n5 && edgeArray[n4].getAtomIndex2() != n5 || !edgeArray[n4].isCovalent()); ++n4) {
                }
                if (n4 == edgeArray.length) {
                    return true;
                }
                if (this.checkMatchBond(smilesAtom, smilesAtom2, smilesBond, n2, n5, edgeArray[n4])) continue;
                return true;
            }
            this.patternAtoms[smilesAtom.index].setMatchingAtom(this.jmolAtoms[n2], n2);
            if (Logger.debugging && !this.isSilent) {
                for (n3 = 0; n3 <= n; ++n3) {
                    Logger.debug((String)("pattern atoms " + (Object)((Object)this.patternAtoms[n3])));
                }
                Logger.debug((String)"--ss--");
            }
            this.bsFound.set(n2);
        }
        if (!this.continueMatch(n, n2, bl)) {
            return false;
        }
        if (n2 >= 0) {
            this.clearBsFound(n2);
        }
        return true;
    }

    private boolean continueMatch(int n, int n2, boolean bl) throws InvalidSmilesException {
        int n3;
        int n4;
        if (++n < this.ac) {
            SmilesBond smilesBond;
            SmilesAtom smilesAtom = this.patternAtoms[n];
            SmilesBond smilesBond2 = n2 >= 0 ? smilesAtom.getBondTo(null) : (smilesBond = n == 0 ? this.nestedBond : null);
            if (smilesBond == null) {
                int n5;
                BS bS = BSUtil.copy((BS)this.bsFound);
                BS bS2 = BSUtil.copy((BS)this.bsFound);
                if (smilesAtom.notBondedIndex >= 0) {
                    SmilesAtom smilesAtom2 = this.patternAtoms[smilesAtom.notBondedIndex];
                    Node node = smilesAtom2.getMatchingAtom();
                    if (smilesAtom2.isBioAtom) {
                        n5 = ((BNode)node).getOffsetResidueAtom("\u0000", 1);
                        if (n5 >= 0) {
                            bS.set(n5);
                        }
                        if ((n5 = ((BNode)node).getOffsetResidueAtom("\u0000", -1)) >= 0) {
                            bS.set(n5);
                        }
                    } else {
                        Edge[] edgeArray = node.getEdges();
                        for (n5 = 0; n5 < edgeArray.length; ++n5) {
                            bS.set(edgeArray[n5].getOtherAtomNode(node).getIndex());
                        }
                    }
                }
                boolean bl2 = n2 >= 0 && smilesAtom.isBioAtom && (smilesAtom.atomName == null || smilesAtom.residueChar != null);
                int n6 = this.bsSelected.nextSetBit(0);
                while (n6 >= 0) {
                    if (!bS.get(n6) && !this.checkMatch(smilesAtom, n, n6, bl)) {
                        return false;
                    }
                    if (bl2 && (n5 = ((BNode)this.jmolAtoms[n6]).getOffsetResidueAtom(smilesAtom.atomName, 1)) >= 0) {
                        n6 = n5 - 1;
                    }
                    n6 = this.bsSelected.nextSetBit(n6 + 1);
                }
                this.bsFound = bS2;
                return true;
            }
            Node node = smilesBond.atom1.getMatchingAtom();
            switch (smilesBond.order) {
                case 96: {
                    int n7 = ((BNode)node).getOffsetResidueAtom(smilesAtom.atomName, 1);
                    if (n7 >= 0) {
                        BS bS = BSUtil.copy((BS)this.bsFound);
                        ((BNode)node).getGroupBits(this.bsFound);
                        if (!this.checkMatch(smilesAtom, n, n7, bl)) {
                            return false;
                        }
                        this.bsFound = bS;
                    }
                    return true;
                }
                case 112: {
                    Lst lst = new Lst();
                    ((BNode)node).getCrossLinkVector(lst, true, true);
                    BS bS = BSUtil.copy((BS)this.bsFound);
                    ((BNode)node).getGroupBits(this.bsFound);
                    for (int i = 2; i < lst.size(); i += 3) {
                        if (this.checkMatch(smilesAtom, n, (Integer)lst.get(i), bl)) continue;
                        return false;
                    }
                    this.bsFound = bS;
                    return true;
                }
            }
            Edge[] edgeArray = node.getEdges();
            if (edgeArray != null) {
                for (int i = 0; i < edgeArray.length; ++i) {
                    if (this.checkMatch(smilesAtom, n, node.getBondedAtomIndex(i), bl)) continue;
                    return false;
                }
            }
            this.clearBsFound(n2);
            return true;
        }
        if (!this.ignoreStereochemistry && !this.checkStereochemistry()) {
            return true;
        }
        BS bS = new BS();
        int n8 = 0;
        for (n4 = 0; n4 < this.ac; ++n4) {
            n3 = this.patternAtoms[n4].getMatchingAtomIndex();
            if (!bl && this.top.haveSelected && !this.patternAtoms[n4].selected) continue;
            ++n8;
            bS.set(n3);
            if (this.patternAtoms[n4].isBioAtom && this.patternAtoms[n4].atomName == null) {
                ((BNode)this.jmolAtoms[n3]).getGroupBits(bS);
            }
            if (bl) break;
            if (this.isSmarts || this.patternAtoms[n4].missingHydrogenCount <= 0) continue;
            this.getHydrogens(this.jmolAtoms[n3], bS);
        }
        if (this.bsRequired != null && !this.bsRequired.intersects(bS)) {
            return true;
        }
        if (this.matchAllAtoms && bS.cardinality() != this.selectedAtomCount) {
            return true;
        }
        if (this.bsCheck != null) {
            if (bl) {
                this.bsCheck.clearAll();
                for (n4 = 0; n4 < this.ac; ++n4) {
                    this.bsCheck.set(this.patternAtoms[n4].getMatchingAtomIndex());
                }
                if (this.bsCheck.cardinality() != this.ac) {
                    return true;
                }
            } else if (bS.cardinality() != this.ac) {
                return true;
            }
        }
        this.bsReturn.or(bS);
        if (this.getMaps) {
            int[] nArray = new int[n8];
            int n9 = 0;
            for (n3 = 0; n3 < this.ac; ++n3) {
                if (!bl && this.top.haveSelected && !this.patternAtoms[n3].selected) continue;
                nArray[n9++] = this.patternAtoms[n3].getMatchingAtomIndex();
            }
            this.vReturn.addLast((Object)nArray);
            return !this.firstMatchOnly;
        }
        if (this.asVector) {
            n4 = 1;
            n3 = this.vReturn.size();
            while (--n3 >= 0 && n4 != 0) {
                n4 = !((BS)this.vReturn.get(n3)).equals((Object)bS) ? 1 : 0;
            }
            if (n4 == 0) {
                return true;
            }
            this.vReturn.addLast((Object)bS);
        }
        if (this.isRingCheck) {
            this.ringSets.append(" ");
            n4 = n * 3 + 2;
            while (--n4 > n) {
                this.ringSets.append("-").appendI(this.patternAtoms[(n4 <= n * 2 ? n * 2 - n4 + 1 : n4 - 1) % n].getMatchingAtomIndex());
            }
            this.ringSets.append("- ");
            return true;
        }
        if (this.firstMatchOnly) {
            return false;
        }
        return bS.cardinality() != this.selectedAtomCount;
    }

    private void clearBsFound(int n) {
        if (n < 0) {
            if (this.bsCheck == null) {
                this.bsFound.clearAll();
            }
        } else {
            this.bsFound.clear(n);
        }
    }

    Node getHydrogens(Node node, BS bS) {
        Edge[] edgeArray = node.getEdges();
        int n = -1;
        for (int i = 0; i < edgeArray.length; ++i) {
            if (this.jmolAtoms[node.getBondedAtomIndex(i)].getElementNumber() != 1) continue;
            n = node.getBondedAtomIndex(i);
            if (bS == null) break;
            bS.set(n);
        }
        return n >= 0 ? this.jmolAtoms[n] : null;
    }

    private boolean checkPrimitiveAtom(SmilesAtom smilesAtom, int n) throws InvalidSmilesException {
        boolean bl;
        block20: {
            block23: {
                int n2;
                block26: {
                    block27: {
                        Node node;
                        block25: {
                            int n3;
                            block24: {
                                block21: {
                                    BNode bNode;
                                    block22: {
                                        block19: {
                                            node = this.jmolAtoms[n];
                                            bl = smilesAtom.not;
                                            if (smilesAtom.iNested <= 0) break block19;
                                            Object object = this.getNested(smilesAtom.iNested);
                                            if (object instanceof SmilesSearch) {
                                                SmilesSearch smilesSearch = (SmilesSearch)((Object)object);
                                                if (smilesAtom.isBioAtom) {
                                                    smilesSearch.nestedBond = smilesAtom.getBondTo(null);
                                                }
                                                if ((object = this.subsearch(smilesSearch, true, false)) == null) {
                                                    object = new BS();
                                                }
                                                if (!smilesAtom.isBioAtom) {
                                                    this.setNested(smilesAtom.iNested, object);
                                                }
                                            }
                                            bl = smilesAtom.not != ((BS)object).get(n);
                                            break block20;
                                        }
                                        if (smilesAtom.atomNumber != Integer.MIN_VALUE && smilesAtom.atomNumber != ((BNode)node).getAtomNumber() || smilesAtom.elementNumber >= 0 && smilesAtom.elementNumber != node.getElementNumber() || smilesAtom.jmolIndex >= 0 && node.getIndex() != smilesAtom.jmolIndex || smilesAtom.atomName != null && (!smilesAtom.isLeadAtom() ? !smilesAtom.atomName.equals(((BNode)node).getAtomName().toUpperCase()) : !((BNode)node).isLeadAtom())) break block20;
                                        if (!smilesAtom.isBioResidue) break block21;
                                        bNode = (BNode)node;
                                        if (smilesAtom.residueName != null && !smilesAtom.residueName.equals(bNode.getGroup3(false).toUpperCase()) || smilesAtom.residueNumber != Integer.MIN_VALUE && smilesAtom.residueNumber != bNode.getResno()) break block20;
                                        if (smilesAtom.residueChar == null && smilesAtom.elementNumber != -2) break block22;
                                        char c = bNode.getBioSmilesType();
                                        char c2 = smilesAtom.getBioSmilesType();
                                        char c3 = smilesAtom.residueChar == null ? (char)'*' : (char)smilesAtom.residueChar.charAt(0);
                                        boolean bl2 = true;
                                        boolean bl3 = false;
                                        switch (c2) {
                                            case '*': {
                                                bl2 = true;
                                                break;
                                            }
                                            case 'n': {
                                                bl2 = c == 'r' || c == 'c';
                                                bl3 = true;
                                                break;
                                            }
                                            case 'c': 
                                            case 'r': {
                                                bl3 = true;
                                            }
                                            default: {
                                                boolean bl4 = bl2 = c == c2;
                                            }
                                        }
                                        if (!bl2) break block20;
                                        String string = bNode.getGroup1('\u0000').toUpperCase();
                                        boolean bl5 = c3 == string.charAt(0);
                                        switch (c3) {
                                            case '*': {
                                                bl5 = true;
                                                break;
                                            }
                                            case 'N': {
                                                bl5 = bl3 ? c == 'r' || c == 'c' : bl5;
                                                break;
                                            }
                                            case 'R': {
                                                bl5 = bl3 ? bNode.isPurine() : bl5;
                                                break;
                                            }
                                            case 'Y': {
                                                boolean bl6 = bl5 = bl3 ? bNode.isPyrimidine() : bl5;
                                            }
                                        }
                                        if (!bl5) break block20;
                                    }
                                    if (!smilesAtom.isBioAtom || !smilesAtom.notCrossLinked || !bNode.getCrossLinkVector(null, true, true)) break block23;
                                    break block20;
                                }
                                if (smilesAtom.atomType != null && !smilesAtom.atomType.equals(node.getAtomType())) break block20;
                                boolean bl7 = smilesAtom.isAromatic();
                                if (!this.noAromatic && !smilesAtom.aromaticAmbiguous && bl7 != this.bsAromatic.get(n) && (!this.noncanonical || smilesAtom.getExplicitHydrogenCount() != node.getCovalentHydrogenCount())) break block20;
                                n2 = smilesAtom.getAtomicMass();
                                if (n2 == Integer.MIN_VALUE) break block24;
                                n3 = node.getIsotopeNumber();
                                if (n2 >= 0 && n2 != n3 || n2 < 0 && n3 != 0 && -n2 != n3) break block20;
                            }
                            if ((n2 = smilesAtom.getCharge()) != Integer.MIN_VALUE && n2 != node.getFormalCharge() || (n2 = smilesAtom.getCovalentHydrogenCount() + smilesAtom.missingHydrogenCount) >= 0 && n2 != node.getCovalentHydrogenCount()) break block20;
                            n2 = smilesAtom.implicitHydrogenCount;
                            if (n2 == Integer.MIN_VALUE) break block25;
                            n3 = node.getImplicitHydrogenCount();
                            if (n2 != -1 ? n2 != n3 : n3 == 0) break block20;
                        }
                        if (smilesAtom.degree > 0 && smilesAtom.degree != node.getCovalentBondCount() || smilesAtom.nonhydrogenDegree > 0 && smilesAtom.nonhydrogenDegree != node.getCovalentBondCount() - node.getCovalentHydrogenCount() || smilesAtom.valence > 0 && smilesAtom.valence != node.getValence() || smilesAtom.connectivity > 0 && smilesAtom.connectivity != node.getCovalentBondCount() + node.getImplicitHydrogenCount()) break block20;
                        if (this.ringData == null || smilesAtom.ringSize < -1) break block26;
                        if (smilesAtom.ringSize > 0) break block27;
                        if (this.ringCounts[n] == 0 == (smilesAtom.ringSize == 0)) break block26;
                        break block20;
                    }
                    BS bS = this.ringData[smilesAtom.ringSize == 500 ? 5 : (smilesAtom.ringSize == 600 ? 6 : smilesAtom.ringSize)];
                    if (bS == null || !bS.get(n) || !this.noAromatic && (smilesAtom.ringSize != 500 ? smilesAtom.ringSize == 600 && !this.bsAromatic6.get(n) : !this.bsAromatic5.get(n))) break block20;
                }
                if (this.ringData != null && smilesAtom.ringMembership >= -1 && (smilesAtom.ringMembership != -1 ? this.ringCounts[n] != smilesAtom.ringMembership : this.ringCounts[n] == 0)) break block20;
                if (smilesAtom.ringConnectivity < 0) break block23;
                n2 = this.ringConnections[n];
                if (smilesAtom.ringConnectivity == -1 && n2 == 0 || smilesAtom.ringConnectivity != -1 && n2 != smilesAtom.ringConnectivity) break block20;
            }
            bl = !bl;
        }
        return bl;
    }

    private boolean checkMatchBond(SmilesAtom smilesAtom, SmilesAtom smilesAtom2, SmilesBond smilesBond, int n, int n2, Edge edge) {
        if (smilesBond.bondsOr != null) {
            for (int i = 0; i < smilesBond.nBondsOr; ++i) {
                if (!this.checkMatchBond(smilesAtom, smilesAtom2, smilesBond.bondsOr[i], n, n2, edge)) continue;
                return true;
            }
            return false;
        }
        if (smilesBond.primitives == null) {
            if (!this.checkPrimitiveBond(smilesBond, n, n2, edge)) {
                return false;
            }
        } else {
            for (int i = 0; i < smilesBond.nPrimitives; ++i) {
                if (this.checkPrimitiveBond(smilesBond.primitives[i], n, n2, edge)) continue;
                return false;
            }
        }
        smilesBond.matchingBond = edge;
        return true;
    }

    private boolean checkPrimitiveBond(SmilesBond smilesBond, int n, int n2, Edge edge) {
        boolean bl = false;
        switch (smilesBond.order) {
            case 96: {
                return smilesBond.isNot != (this.bioAtoms[n2].getOffsetResidueAtom("\u0000", 1) == this.bioAtoms[n].getOffsetResidueAtom("\u0000", 0));
            }
            case 112: {
                return smilesBond.isNot != this.bioAtoms[n].isCrossLinked(this.bioAtoms[n2]);
            }
        }
        boolean bl2 = !this.noAromatic && this.bsAromatic.get(n);
        boolean bl3 = !this.noAromatic && this.bsAromatic.get(n2);
        int n3 = edge.getCovalentOrder();
        if (bl2 && bl3) {
            switch (smilesBond.order) {
                case 17: 
                case 65: {
                    bl = SmilesSearch.isRingBond(this.ringSets, n, n2);
                    break;
                }
                case 1: {
                    bl = !this.isSmarts || !SmilesSearch.isRingBond(this.ringSets, n, n2);
                    break;
                }
                case 2: {
                    bl = !this.isSmarts || this.aromaticDouble && (n3 == 2 || n3 == 514);
                    break;
                }
                case -1: 
                case 81: 
                case 769: 
                case 1025: {
                    bl = true;
                }
            }
        } else {
            switch (smilesBond.order) {
                case -1: 
                case 81: {
                    bl = true;
                    break;
                }
                case 1: 
                case 257: 
                case 513: {
                    bl = n3 == 1 || n3 == 1041 || n3 == 1025;
                    break;
                }
                case 769: {
                    bl = n3 == (this.isSmilesFind ? 33 : 1);
                    break;
                }
                case 1025: {
                    bl = n3 == (this.isSmilesFind ? 97 : 1);
                    break;
                }
                case 2: {
                    bl = n3 == 2;
                    break;
                }
                case 3: {
                    bl = n3 == 3;
                    break;
                }
                case 65: {
                    bl = SmilesSearch.isRingBond(this.ringSets, n, n2);
                }
            }
        }
        return bl != smilesBond.isNot;
    }

    static boolean isRingBond(SB sB, int n, int n2) {
        return sB != null && sB.indexOf("-" + n + "-" + n2 + "-") >= 0;
    }

    private boolean checkStereochemistry() {
        int n;
        for (n = 0; n < this.measures.size(); ++n) {
            if (((SmilesMeasure)this.measures.get(n)).check()) continue;
            return false;
        }
        if (this.stereo != null && !this.stereo.checkStereoChemistry(this, this.v)) {
            return false;
        }
        if (this.haveBondStereochemistry) {
            for (n = 0; n < this.ac; ++n) {
                int n2;
                boolean bl;
                SmilesBond smilesBond;
                int n3;
                SmilesAtom smilesAtom = this.patternAtoms[n];
                SmilesAtom smilesAtom2 = null;
                SmilesAtom smilesAtom3 = null;
                SmilesAtom smilesAtom4 = null;
                int n4 = 0;
                int n5 = 0;
                int n6 = 0;
                int n7 = smilesAtom.getBondCount();
                boolean bl2 = false;
                block9: for (n3 = 0; n3 < n7; ++n3) {
                    smilesBond = smilesAtom.getBond(n3);
                    bl = smilesBond.atom2 == smilesAtom;
                    n2 = smilesBond.order;
                    switch (n2) {
                        case 2: 
                        case 769: 
                        case 1025: {
                            if (bl) continue block9;
                            smilesAtom2 = smilesBond.atom2;
                            n6 = n2;
                            boolean bl3 = bl2 = n2 != 2;
                            if (!bl2) continue block9;
                            n4 = smilesBond.isNot ? -1 : 1;
                            continue block9;
                        }
                        case 257: 
                        case 513: {
                            smilesAtom3 = bl ? smilesBond.atom1 : smilesBond.atom2;
                            n4 = bl != (n2 == 257) ? 1 : -1;
                        }
                    }
                }
                if (bl2) {
                    smilesBond = smilesAtom.getBondNotTo(smilesAtom2, false);
                    if (smilesBond == null) {
                        return false;
                    }
                    smilesAtom3 = smilesBond.getOtherAtom(smilesAtom);
                    smilesBond = smilesAtom2.getBondNotTo(smilesAtom, false);
                    if (smilesBond == null) {
                        return false;
                    }
                    smilesAtom4 = smilesBond.getOtherAtom(smilesAtom2);
                } else {
                    if (smilesAtom2 == null || n4 == 0) continue;
                    n7 = smilesAtom2.getBondCount();
                    for (n3 = 0; n3 < n7 && n5 == 0; ++n3) {
                        smilesBond = smilesAtom2.getBond(n3);
                        bl = smilesBond.atom2 == smilesAtom2;
                        n2 = smilesBond.order;
                        switch (n2) {
                            case 257: 
                            case 513: {
                                smilesAtom4 = bl ? smilesBond.atom1 : smilesBond.atom2;
                                n5 = bl != (n2 == 257) ? 1 : -1;
                            }
                        }
                    }
                    if (n5 == 0) continue;
                }
                if (this.isSmilesFind) {
                    this.setSmilesBondCoordinates(smilesAtom, smilesAtom2, n6);
                }
                Node node = smilesAtom.getMatchingAtom();
                Node node2 = smilesAtom2.getMatchingAtom();
                Node node3 = smilesAtom3.getMatchingAtom();
                Node node4 = smilesAtom4.getMatchingAtom();
                if (node3 == null || node4 == null) {
                    return false;
                }
                SmilesMeasure.setTorsionData((P3)node3, (P3)node, (P3)node2, (P3)node4, this.v, bl2);
                if (bl2) {
                    n5 = n6 == 769 ? 1 : -1;
                    float f = this.v.vTemp1.dot((T3)this.v.vTemp2);
                    if (!(f < 0.05f) && !(f > 0.95f) && !(this.v.vNorm1.dot((T3)this.v.vNorm2) * (float)n4 * (float)n5 > 0.0f)) continue;
                    return false;
                }
                if (!(this.v.vTemp1.dot((T3)this.v.vTemp2) * (float)n4 * (float)n5 < 0.0f)) continue;
                return false;
            }
        }
        return true;
    }

    private void setSmilesBondCoordinates(SmilesAtom smilesAtom, SmilesAtom smilesAtom2, int n) {
        Node node = this.jmolAtoms[smilesAtom.getMatchingAtomIndex()];
        Node node2 = this.jmolAtoms[smilesAtom2.getMatchingAtomIndex()];
        node.set(-1.0f, 0.0f, 0.0f);
        node2.set(1.0f, 0.0f, 0.0f);
        if (n == 2) {
            Node[] nodeArray;
            int n2 = 0;
            int n3 = 0;
            Edge[] edgeArray = node.getEdges();
            int n4 = edgeArray.length;
            while (--n4 >= 0) {
                nodeArray = edgeArray[n4];
                Node node3 = nodeArray.getOtherAtomNode(node);
                if (node3 == node2) continue;
                node3.set(-1.0f, n2++ == 0 ? -1.0f : 1.0f, 0.0f);
                int n5 = nodeArray.getAtomIndex2() == node.getIndex() ? n2 : -n2;
                switch (nodeArray.order) {
                    case 1025: {
                        n3 = n5;
                        break;
                    }
                    case 1041: {
                        n3 = -n5;
                    }
                }
            }
            n4 = 0;
            n2 = 0;
            nodeArray = new Node[2];
            edgeArray = node2.getEdges();
            int n6 = edgeArray.length;
            while (--n6 >= 0) {
                Edge edge = edgeArray[n6];
                Node node4 = edge.getOtherAtomNode(node2);
                if (node4 == node) continue;
                nodeArray[n2] = node4;
                node4.set(1.0f, n2++ == 0 ? 1.0f : -1.0f, 0.0f);
                int n7 = edge.getAtomIndex2() == node2.getIndex() ? n2 : -n2;
                switch (edge.order) {
                    case 1025: {
                        n4 = n7;
                        break;
                    }
                    case 1041: {
                        n4 = -n7;
                    }
                }
            }
            if (n3 * n4 > 0 == (Math.abs(n3) % 2 == Math.abs(n4) % 2)) {
                float f = ((P3)nodeArray[0]).y;
                ((P3)nodeArray[0]).y = ((P3)nodeArray[1]).y;
                ((P3)nodeArray[1]).y = f;
            }
        } else {
            Node node5;
            Edge edge;
            Edge[] edgeArray = node.getEdges();
            int n8 = 0;
            int n9 = edgeArray.length;
            while (--n9 >= 0) {
                edge = edgeArray[n9];
                if (edge.getOtherAtomNode(node) != node2) continue;
                n8 = edge.order == 33 ? 1 : -1;
                break;
            }
            n9 = edgeArray.length;
            while (--n9 >= 0) {
                edge = edgeArray[n9];
                node5 = edge.getOtherAtomNode(node);
                if (node5 == node2) continue;
                node5.set(-1.0f, 1.0f, 0.0f);
            }
            edgeArray = node2.getEdges();
            n9 = edgeArray.length;
            while (--n9 >= 0) {
                edge = edgeArray[n9];
                node5 = edge.getOtherAtomNode(node2);
                if (node5 == node) continue;
                node5.set(1.0f, 1.0f, (float)(-n8) / 2.0f);
            }
        }
    }

    int[] getMappedAtoms(Node node, Node node2, Node[] nodeArray) {
        int n;
        int n2;
        int[] nArray = new int[nodeArray[4] == null ? 4 : (nodeArray[5] == null ? 5 : 6)];
        for (n2 = 0; n2 < nArray.length; ++n2) {
            nArray[n2] = nodeArray[n2] == null ? 104 + n2 * 100 : nodeArray[n2].getIndex();
        }
        Edge[] edgeArray = node.getEdges();
        Edge[] edgeArray2 = node2 == null ? null : node2.getEdges();
        for (n = 0; n < nArray.length; ++n) {
            for (n2 = 0; n2 < edgeArray.length && edgeArray[n2].getOtherAtomNode(node) != nodeArray[n]; ++n2) {
            }
            if (n2 < edgeArray.length) {
                nArray[n] = n2 * 10 + 100 + n;
                continue;
            }
            if (node2 == null) continue;
            for (n2 = 0; n2 < edgeArray2.length && edgeArray2[n2].getOtherAtomNode(node2) != nodeArray[n]; ++n2) {
            }
            if (n2 >= edgeArray2.length) continue;
            nArray[n] = n2 * 10 + 300 + n;
        }
        Arrays.sort(nArray);
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = nArray[n] % 10;
        }
        return nArray;
    }

    void createTopoMap(BS bS) {
        SmilesBond smilesBond;
        SmilesAtom smilesAtom;
        int n;
        Edge[] edgeArray;
        int n2;
        if (bS == null) {
            bS = new BS();
        }
        int n3 = this.getMissingHydrogenCount();
        SmilesAtom[] smilesAtomArray = new SmilesAtom[this.ac + n3];
        this.jmolAtoms = smilesAtomArray;
        int n4 = 0;
        BS bS2 = new BS();
        for (n2 = 0; n2 < this.ac; ++n2) {
            edgeArray = this.patternAtoms[n2];
            n = edgeArray.missingHydrogenCount;
            if (n < 0) {
                n = 0;
            }
            smilesAtom = smilesAtomArray[n4] = new SmilesAtom().setAll(0, n4, edgeArray.elementNumber, edgeArray.getCharge());
            smilesAtom.stereo = edgeArray.stereo;
            smilesAtom.atomName = edgeArray.atomName;
            smilesAtom.residueName = edgeArray.residueName;
            smilesAtom.residueChar = edgeArray.residueChar;
            smilesAtom.residueNumber = edgeArray.residueNumber;
            smilesAtom.atomNumber = edgeArray.residueNumber;
            smilesAtom.isBioAtom = edgeArray.isBioAtom;
            smilesAtom.bioType = edgeArray.bioType;
            smilesAtom.isLeadAtom = edgeArray.isLeadAtom;
            smilesAtom.mapIndex = n2;
            smilesAtom.setAtomicMass(edgeArray.getAtomicMass());
            if (edgeArray.isAromatic()) {
                bS.set(n4);
            }
            if (!edgeArray.isFirst && n == 1 && edgeArray.getChiralClass() > 0) {
                bS2.set(n4);
            }
            edgeArray.setMatchingAtom(null, n4++);
            SmilesBond[] smilesBondArray = new SmilesBond[edgeArray.getBondCount() + n];
            smilesAtom.setBonds(smilesBondArray);
            while (--n >= 0) {
                SmilesAtom smilesAtom2 = smilesAtomArray[n4] = new SmilesAtom().setAll(0, n4, 1, 0);
                smilesAtom2.mapIndex = -n2 - 1;
                ++n4;
                smilesAtom2.setBonds(new SmilesBond[1]);
                smilesBond = new SmilesBond(smilesAtom, smilesAtom2, 1, false);
                if (!Logger.debugging) continue;
                Logger.info((String)("" + (Object)((Object)smilesBond)));
            }
        }
        for (n2 = 0; n2 < this.ac; ++n2) {
            edgeArray = this.patternAtoms[n2];
            n = edgeArray.getMatchingAtomIndex();
            smilesAtom = smilesAtomArray[n];
            int n5 = edgeArray.getBondCount();
            for (int i = 0; i < n5; ++i) {
                Object object;
                boolean bl;
                smilesBond = edgeArray.getBond(i);
                boolean bl2 = bl = smilesBond.atom1 == edgeArray;
                if (bl) {
                    int n6 = 1;
                    switch (smilesBond.order) {
                        case 769: {
                            n6 = 33;
                            break;
                        }
                        case 1025: {
                            n6 = 97;
                            break;
                        }
                        case 257: {
                            n6 = 1025;
                            break;
                        }
                        case 513: {
                            n6 = 1041;
                            break;
                        }
                        case 96: 
                        case 112: {
                            n6 = smilesBond.order;
                            break;
                        }
                        case 1: {
                            n6 = 1;
                            break;
                        }
                        case 17: {
                            n6 = 514;
                            break;
                        }
                        case 2: {
                            n6 = 2;
                            break;
                        }
                        case 3: {
                            n6 = 3;
                        }
                    }
                    object = smilesAtomArray[smilesBond.atom2.getMatchingAtomIndex()];
                    SmilesBond smilesBond2 = new SmilesBond(smilesAtom, (SmilesAtom)((Object)object), n6, false);
                    --((SmilesAtom)((Object)object)).bondCount;
                    if (!Logger.debugging) continue;
                    Logger.info((String)("" + (Object)((Object)smilesBond2)));
                    continue;
                }
                SmilesAtom smilesAtom3 = smilesAtomArray[smilesBond.atom1.getMatchingAtomIndex()];
                object = smilesAtom3.getBondTo(smilesAtom);
                smilesAtom.addBond((SmilesBond)((Object)object));
            }
        }
        n2 = bS2.nextSetBit(0);
        while (n2 >= 0) {
            edgeArray = smilesAtomArray[n2].getEdges();
            Edge edge = edgeArray[0];
            edgeArray[0] = edgeArray[1];
            edgeArray[1] = edge;
            n2 = bS2.nextSetBit(n2 + 1);
        }
    }

    public void setTop(SmilesSearch smilesSearch) {
        this.top = smilesSearch == null ? this : smilesSearch.getTop();
    }

    SmilesSearch getTop() {
        return this.top == this ? this : this.top.getTop();
    }

    void getSelections() {
        Map<String, Object> map = this.top.htNested;
        if (map == null || this.jmolAtoms.length == 0) {
            return;
        }
        Hashtable<String, BS> hashtable = new Hashtable<String, BS>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            BS bS;
            String string = entry.getValue().toString();
            if (!string.startsWith("select")) continue;
            BS bS2 = bS = hashtable.containsKey(string) ? (BS)hashtable.get(string) : this.jmolAtoms[0].findAtomsLike(string.substring(6));
            if (bS == null) {
                bS = new BS();
            }
            hashtable.put(string, bS);
            entry.setValue(bS);
        }
    }
}

