"use strict";

var _Promise = require("babel-runtime/core-js/promise")["default"];

var _regeneratorRuntime = require("babel-runtime/regenerator")["default"];

var _getIterator = require("babel-runtime/core-js/get-iterator")["default"];

var _interopRequireDefault = require("babel-runtime/helpers/interop-require-default")["default"];

exports.__esModule = true;

var _request = require("request");

var _request2 = _interopRequireDefault(_request);

var cache = {};

function getInfo(packageName) {
  if (cache[packageName]) {
    return cache[packageName];
  } else {
    return cache[packageName] = new _Promise(function (resolve, reject) {
      _request2["default"].get({
        url: "https://registry.npmjs.org/" + packageName + "/latest",
        json: true
      }, function (err, res, body) {
        if (err) {
          reject(err);
        } else {
          resolve(cache[packageName] = body);
        }
      });
    });
  }
}

exports["default"] = function callee$0$0(packages) {
  var filteredPackages, promises, _iterator, _isArray, _i, _ref, pkg, infos, messages, i, info;

  return _regeneratorRuntime.async(function callee$0$0$(context$1$0) {
    while (1) switch (context$1$0.prev = context$1$0.next) {
      case 0:
        filteredPackages = [];
        promises = [];
        _iterator = packages, _isArray = Array.isArray(_iterator), _i = 0, _iterator = _isArray ? _iterator : _getIterator(_iterator);

      case 3:
        if (!_isArray) {
          context$1$0.next = 9;
          break;
        }

        if (!(_i >= _iterator.length)) {
          context$1$0.next = 6;
          break;
        }

        return context$1$0.abrupt("break", 20);

      case 6:
        _ref = _iterator[_i++];
        context$1$0.next = 13;
        break;

      case 9:
        _i = _iterator.next();

        if (!_i.done) {
          context$1$0.next = 12;
          break;
        }

        return context$1$0.abrupt("break", 20);

      case 12:
        _ref = _i.value;

      case 13:
        pkg = _ref;

        if (!(pkg.name.indexOf("babel-") !== 0)) {
          context$1$0.next = 16;
          break;
        }

        return context$1$0.abrupt("continue", 18);

      case 16:

        promises.push(getInfo(pkg.name));
        filteredPackages.push(pkg);

      case 18:
        context$1$0.next = 3;
        break;

      case 20:
        context$1$0.next = 22;
        return _regeneratorRuntime.awrap(_Promise.all(promises));

      case 22:
        infos = context$1$0.sent;
        messages = [];
        i = 0;

      case 25:
        if (!(i < infos.length)) {
          context$1$0.next = 34;
          break;
        }

        info = infos[i];
        pkg = filteredPackages[i];

        if (!(pkg.name === "babel-runtime")) {
          context$1$0.next = 30;
          break;
        }

        return context$1$0.abrupt("continue", 31);

      case 30:

        if (info.version !== pkg.version) {
          messages.push(pkg.name + " - Latest is " + info.version + ". Local version is " + pkg.version);
        }

      case 31:
        i++;
        context$1$0.next = 25;
        break;

      case 34:
        if (!messages.length) {
          context$1$0.next = 38;
          break;
        }

        return context$1$0.abrupt("return", [false, "We found some outdated packages:\n\n- " + messages.join("\n- ")]);

      case 38:
        return context$1$0.abrupt("return", [true, "All babel packages appear to be up to date"]);

      case 39:
      case "end":
        return context$1$0.stop();
    }
  }, null, this);
};

module.exports = exports["default"];

// https://github.com/babel/babel/issues/2915