#!/bin/sh
#

XPMPAT="X pixmap image text"

conv_xpm() 
{
  FILNAM="$1"
###
### Check if file parmater is present
###
  if [ -z "$FILNAM" ] ; then
    echo "Error: no file parameter"
    echo "Usage: `basename $0` XPM-file"
    exit 1
  fi
###
### Check if extension is specified
###
  if [ -z `echo $FILNAM|grep ".xpm$"` ] 
  then INPNAM="$FILNAM.xpm"
  else INPNAM="$FILNAM"
       FILNAM="`echo $FILNAM|sed 's/.xpm$//'`"
  fi
###
### Check if file is present
###
  if [ ! -f "$INPNAM" ] ; then
    echo "Error: file $INPNAM does not exist"
    exit 2
  fi
###
### Check if file is a correct XPM file
###
  RES=`file $INPNAM|grep "$XPMPAT"`
  if [ -z "$RES" ] ; then
    echo "Error: file $INPNAM is no valid XPM-file"
    exit 3
  fi
###
### Create output name
###
  if [ ! -z "$2" ] 
  then FILOUT="$2.gif"
  else FILOUT="$FILNAM.gif"
  fi
###
### Do conversion...
###
  xpmtoppm "$INPNAM" | ppmtogif  > "$FILOUT"
}

for F in $*
do echo "Converting $F..."
   conv_xpm $F
done
