/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.resourcetracker;

import de.intarsys.tools.resourcetracker.IResourceReference;
import de.intarsys.tools.resourcetracker.PhantomResourceReference;
import java.lang.ref.ReferenceQueue;

public class ResourceFinalizer
extends Thread {
    private static ResourceFinalizer DEFAULT;
    private final ReferenceQueue queue = new ReferenceQueue();
    private boolean started = false;

    public static synchronized ResourceFinalizer get() {
        if (DEFAULT == null) {
            DEFAULT = new ResourceFinalizer();
        }
        return DEFAULT;
    }

    public ResourceFinalizer() {
        super("resource finalizer");
        this.setDaemon(true);
    }

    protected void drainQueue() {
        IResourceReference iResourceReference;
        while ((iResourceReference = (IResourceReference)((Object)this.queue.poll())) != null) {
            iResourceReference.dispose();
        }
        return;
    }

    protected synchronized void ensureStarted() {
        if (this.started) {
            return;
        }
        this.start();
    }

    public ReferenceQueue getQueue() {
        return this.queue;
    }

    @Override
    public void run() {
        try {
            while (true) {
                PhantomResourceReference phantomResourceReference;
                if ((phantomResourceReference = (PhantomResourceReference)this.queue.remove()) == null) {
                    continue;
                }
                phantomResourceReference.dispose();
            }
        }
        catch (Exception exception) {
            return;
        }
    }

    @Override
    public synchronized void start() {
        this.started = true;
        super.start();
    }
}

