/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.console.business.parser.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import jcmdline.BooleanParam;
import jcmdline.FileParam;
import jcmdline.Parameter;
import jcmdline.PdfFileParam;
import jcmdline.StringParam;
import org.pdfsam.console.business.parser.handlers.interfaces.AbstractCmdHandler;

public class SetViewerCmdHandler
extends AbstractCmdHandler {
    private static final String COMMAND_DESCRIPTION = "Set vewer options for the pdf documents.";
    private final List setviewerOptions = new ArrayList<Parameter>(Arrays.asList(new FileParam("o", "output directory", 65526, false, false), new PdfFileParam("f", "pdf files to set the viewer options: a list of existing pdf files (EX. -f /tmp/file1.pdf -f /tmp/file2.pdf)", 65519, true, true), new StringParam("p", "prefix for the output files name", true), new StringParam("layout", "layout for the viewer. { onecolumn, singlepage, twocolumnl, twocolumnr, twopagel, twopager} ", new String[]{"onecolumn", "singlepage", "twocolumnl", "twocolumnr", "twopagel", "twopager"}, true, false), new StringParam("mode", "open mode for the viewer {attachments, fullscreen, none, ocontent, outlines, thumbs}. If omitted it uses none", new String[]{"attachments", "fullscreen", "none", "ocontent", "outlines", "thumbs"}, true, false), new StringParam("nfsmode", "non full screen mode for the viewer when exiting full screen mode {nfsnone, nfsocontent, nfsoutlines, nfsthumbs}. If omitted it uses nfsnone", new String[]{"nfsnone", "nfsocontent", "nfsoutlines", "nfsthumbs"}, true, false), new StringParam("direction", "direction {l2r, r2l}. If omitted it uses l2r", new String[]{"l2r", "r2l"}, true, false), new FileParam("d", "directory containing pdf files to set the viewer options.", 65511, true, false), new BooleanParam("hidemenu", "hide the menu bar"), new BooleanParam("hidetoolbar", "hide the toolbar"), new BooleanParam("hidewindowui", "hide user interface elements"), new BooleanParam("fitwindow", "resize the window to fit the page size"), new BooleanParam("centerwindow", "center of the screen"), new BooleanParam("displaydoctitle", "display document title metadata as window title"), new BooleanParam("noprintscaling", "no page scaling in print dialog")));
    private static final String SET_VIEWER_HELP_TEXT = "Set vewer options for the pdf documents. \nYou must specify '-o /home/user' to set the output directory.\nYou must specify '-f /tmp/file1.pdf /tmp/file2.pdf:password -f /tmp/file3.pdf [...]' to specify a file list do apply the viewer options (use filename:password if the file is password protected).\n'-p prefix_' to specify a prefix for output names of files. If it contains \"[TIMESTAMP]\" it performs variable substitution. (Ex. [BASENAME]_prefix_[TIMESTAMP] generates FileName_prefix_20070517_113423471.pdf)\nAvailable prefix variables: [TIMESTAMP], [BASENAME].\n'-layout chosenlayout' to set the viewer layout for the document. Possible values { onecolumn, singlepage, twocolumnl, twocolumnr, twopagel, twopager} \n'-mode chosenmode' to set the viewer mode for the document. Possible values {attachments, fullscreen, none, ocontent, outlines, thumbs}. If omitted it uses none\n'-nfsmode chosennonfullscreenmode' to set the viewer mode for the document when exiting full screen mode. Possible values {nfsnone, nfsocontent, nfsoutlines, nfsthumbs}. If omitted it uses nfsnone \n'-direction chosendirection' to set the viewer direction. Possible values {l2r, r2l}\n'-d /tmp' a directory containing the pdf files to set the viewer options.\n'-hidemenu' hide the menu bar.\n'-hidetoolbar' hide the toolbar.\n'-hidewindowui' hide the user interface elements (scrollbars, ...).\n'-fitwindow' resize the window to fit the page displayed.\n'-centerwindow' display the document window at the center of the screen.\n'-displaydoctitle' display document title metadata as window title (filename otherwise).\n'-noprintscaling' no page scaling in print dialog\n";
    private static final String SET_VIEWER_EXAMPLE = "Example: java -jar pdfsam-console-2.4.3e.jar -f /tmp/1.pdf -o /tmp -layout onecolumn -mode fullscreen -nfsmode nfsoutlines -direction l2r -hidemenu -displaydoctitle -noprintscaling -overwrite setviewer\n";
    private final List setviewerArguments = new ArrayList<Parameter>(Arrays.asList(new StringParam("command", "command to execute {[setviewer]}", new String[]{"setviewer"}, false)));

    public Collection getArguments() {
        return this.setviewerArguments;
    }

    public String getCommandDescription() {
        return COMMAND_DESCRIPTION;
    }

    public String getHelpExamples() {
        return SET_VIEWER_EXAMPLE;
    }

    public Collection getOptions() {
        return this.setviewerOptions;
    }

    public String getHelpMessage() {
        return SET_VIEWER_HELP_TEXT;
    }
}

