/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.console.business.parser.validators;

import java.io.File;
import java.util.Iterator;
import jcmdline.BooleanParam;
import jcmdline.CmdLineHandler;
import jcmdline.FileParam;
import jcmdline.PdfFileParam;
import jcmdline.StringParam;
import jcmdline.dto.PdfFile;
import org.apache.commons.lang.StringUtils;
import org.pdfsam.console.business.dto.PageRotation;
import org.pdfsam.console.business.dto.commands.AbstractParsedCommand;
import org.pdfsam.console.business.dto.commands.ConcatParsedCommand;
import org.pdfsam.console.business.parser.validators.interfaces.AbstractCmdValidator;
import org.pdfsam.console.exceptions.console.ConsoleException;
import org.pdfsam.console.exceptions.console.ParseException;
import org.pdfsam.console.utils.FileUtility;
import org.pdfsam.console.utils.ValidationUtility;

public class ConcatCmdValidator
extends AbstractCmdValidator {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AbstractParsedCommand validateArguments(CmdLineHandler cmdLineHandler) throws ConsoleException {
        ConcatParsedCommand parsedCommandDTO = new ConcatParsedCommand();
        if (cmdLineHandler == null) throw new ConsoleException(2);
        FileParam oOption = (FileParam)cmdLineHandler.getOption("o");
        if (!oOption.isSet()) {
            throw new ParseException(15);
        }
        File outFile = oOption.getFile();
        ValidationUtility.assertValidPdfExtension(outFile.getName());
        parsedCommandDTO.setOutputFile(outFile);
        FileParam lOption = (FileParam)cmdLineHandler.getOption("l");
        PdfFileParam fOption = (PdfFileParam)cmdLineHandler.getOption("f");
        FileParam dOption = (FileParam)cmdLineHandler.getOption("d");
        if (!lOption.isSet() && !fOption.isSet() && !dOption.isSet()) throw new ParseException(4);
        if (!(lOption.isSet() ^ fOption.isSet() ^ dOption.isSet())) throw new ParseException(5);
        if (fOption.isSet()) {
            Iterator fIterator = fOption.getPdfFiles().iterator();
            while (fIterator.hasNext()) {
                PdfFile currentFile = (PdfFile)fIterator.next();
                if (currentFile.getFile().getName().toLowerCase().endsWith(".pdf") && currentFile.getFile().getName().length() > ".pdf".length()) continue;
                throw new ParseException(7, new String[]{currentFile.getFile().getPath()});
            }
            parsedCommandDTO.setInputFileList(FileUtility.getPdfFiles(fOption.getPdfFiles()));
        } else if (lOption.isSet()) {
            if (!lOption.getFile().getPath().toLowerCase().endsWith(".csv") && !lOption.getFile().getPath().toLowerCase().endsWith(".xml")) throw new ParseException(6);
            parsedCommandDTO.setInputCvsOrXmlFile(lOption.getFile());
        } else if (dOption.isSet()) {
            File inputDir = dOption.getFile();
            ValidationUtility.assertValidDirectory(inputDir);
            parsedCommandDTO.setInputDirectory(inputDir);
        }
        StringParam uOption = (StringParam)cmdLineHandler.getOption("u");
        if (uOption.isSet()) {
            String[] selections = StringUtils.split((String)uOption.getValue(), (String)":");
            String[] trimmedSelection = new String[selections.length];
            for (int i = 0; i < selections.length; ++i) {
                trimmedSelection[i] = selections[i].trim();
            }
            ValidationUtility.assertValidPageSelectionsArray(trimmedSelection);
            parsedCommandDTO.setPageSelections(trimmedSelection);
        }
        parsedCommandDTO.setCopyFields(((BooleanParam)cmdLineHandler.getOption("copyfields")).isTrue());
        StringParam rOption = (StringParam)cmdLineHandler.getOption("r");
        if (!rOption.isSet()) return parsedCommandDTO;
        PageRotation[] rotations = ValidationUtility.getPagesRotation(rOption.getValue());
        parsedCommandDTO.setRotations(rotations);
        return parsedCommandDTO;
    }
}

