/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.guiclient.commons.frames;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Toolkit;
import java.net.URL;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.border.EtchedBorder;
import javax.swing.text.DefaultEditorKit;
import org.apache.log4j.Logger;
import org.pdfsam.guiclient.business.actions.HideFrameAction;
import org.pdfsam.guiclient.configuration.Configuration;
import org.pdfsam.guiclient.dto.PdfSelectionTableItem;
import org.pdfsam.i18n.GettextResource;

public class JDocumentPropertiesFrame
extends JFrame {
    private static final long serialVersionUID = -3836869268177748519L;
    private static final Logger log = Logger.getLogger(JDocumentPropertiesFrame.class.getPackage().getName());
    private static final int HEIGHT = 480;
    private static final int WIDTH = 640;
    private static JDocumentPropertiesFrame instance = null;
    private final JPanel mainPanel = new JPanel();
    private JScrollPane mainScrollPanel;
    private JTextPane textInfoArea;
    private JPopupMenu jPopupMenu = new JPopupMenu();

    private JDocumentPropertiesFrame() {
        this.initialize();
    }

    public static synchronized JDocumentPropertiesFrame getInstance() {
        if (instance == null) {
            instance = new JDocumentPropertiesFrame();
        }
        return instance;
    }

    public synchronized void showProperties(PdfSelectionTableItem props) {
        StringBuilder sb = new StringBuilder();
        if (props != null) {
            sb.append("<html><head></head><body style=\"margin: 3\"><b>");
            sb.append(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"File name"));
            sb.append(":</b> ");
            sb.append(props.getInputFile().getAbsolutePath());
            sb.append("<br>\n<b>");
            sb.append(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Number of pages"));
            sb.append(":</b> ");
            sb.append(props.getPagesNumber());
            sb.append("<br>\n<b>");
            sb.append(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"File size"));
            sb.append(":</b> ");
            sb.append(props.getFileSize());
            sb.append("B<br>\n<b>");
            sb.append(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Pdf version"));
            sb.append(":</b> ");
            sb.append(props.getPdfVersionDescription());
            sb.append("<br>\n<b>");
            sb.append(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Encryption"));
            sb.append(":</b> ");
            sb.append(props.isEncrypted() ? props.getEncryptionAlgorithm() : GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Not encrypted"));
            sb.append("<br>\n");
            if (props.isEncrypted()) {
                sb.append("<b>");
                sb.append(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Permissions"));
                sb.append(":</b> ");
                sb.append(props.getPermissions());
                sb.append("<br>\n");
            }
            if (props.getDocumentMetaData() != null) {
                sb.append("<b>");
                sb.append(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Title"));
                sb.append(":</b> ");
                sb.append(props.getDocumentMetaData().getTitle());
                sb.append("<br>\n<b>");
                sb.append(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Author"));
                sb.append(":</b> ");
                sb.append(props.getDocumentMetaData().getAuthor());
                sb.append("<br>\n<b>");
                sb.append(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Subject"));
                sb.append(":</b> ");
                sb.append(props.getDocumentMetaData().getSubject());
                sb.append("<br>\n<b>");
                sb.append(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Producer"));
                sb.append(":</b> ");
                sb.append(props.getDocumentMetaData().getProducer());
                sb.append("<br>\n<b>");
                sb.append(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Creator"));
                sb.append(":</b> ");
                sb.append(props.getDocumentMetaData().getCreator());
                sb.append("<br>\n<b>");
                sb.append(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Creation date"));
                sb.append(":</b> ");
                sb.append(props.getDocumentMetaData().getCreationDate());
                sb.append("<br>\n<b>");
                sb.append(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Modification date"));
                sb.append(":</b> ");
                sb.append(props.getDocumentMetaData().getModificationDate());
                sb.append("<br>\n<b>");
                sb.append(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Keywords"));
                sb.append(":</b> ");
                sb.append(props.getDocumentMetaData().getKeywords());
                sb.append("<br>\n");
            }
            sb.append("</body></html>");
            this.textInfoArea.setMargin(new Insets(5, 5, 5, 5));
            this.textInfoArea.setText(sb.toString());
            this.setVisible(true);
        }
    }

    private void initialize() {
        try {
            URL iconUrl = this.getClass().getResource("/images/info.png");
            this.setTitle(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Document properties"));
            this.setIconImage(new ImageIcon(iconUrl).getImage());
            this.setSize(640, 480);
            this.setExtendedState(0);
            this.setDefaultCloseOperation(1);
            JMenuBar menuBar = new JMenuBar();
            JMenu menuFile = new JMenu();
            menuFile.setText(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"File"));
            menuFile.setMnemonic(70);
            JMenuItem closeItem = new JMenuItem();
            closeItem.setAction(new HideFrameAction(this));
            menuFile.add(closeItem);
            menuBar.add(menuFile);
            this.getRootPane().setJMenuBar(menuBar);
            this.textInfoArea = new JTextPane();
            this.textInfoArea.setFont(new Font("Dialog", 0, 9));
            this.textInfoArea.setBorder(new EtchedBorder(1));
            this.textInfoArea.setContentType("text/html");
            this.textInfoArea.setEditable(false);
            this.mainPanel.add(this.textInfoArea);
            this.mainScrollPanel = new JScrollPane(this.textInfoArea);
            this.getContentPane().add(this.mainScrollPanel);
            JMenuItem menuCopy = new JMenuItem(new DefaultEditorKit.CopyAction());
            menuCopy.setText(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Copy"));
            menuCopy.setIcon(new ImageIcon(this.getClass().getResource("/images/edit-copy.png")));
            this.jPopupMenu.add(menuCopy);
            this.textInfoArea.setComponentPopupMenu(this.jPopupMenu);
            Toolkit tk = Toolkit.getDefaultToolkit();
            Dimension screenSize = tk.getScreenSize();
            int screenHeight = screenSize.height;
            int screenWidth = screenSize.width;
            if (screenWidth > 640 && screenHeight > 480) {
                this.setLocation((screenWidth - 640) / 2, (screenHeight - 480) / 2);
            }
        }
        catch (Exception e) {
            log.error(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Error creating properties panel."), e);
        }
    }
}

