/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.guiclient.commons.renderers;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.pdfsam.guiclient.commons.models.AbstractPdfSelectionTableModel;

public class ArrowHeaderRenderer
extends JLabel
implements TableCellRenderer {
    private static final long serialVersionUID = -1266775322573196447L;
    private AbstractPdfSelectionTableModel tableModel;
    private TableCellRenderer tableCellRenderer;

    public ArrowHeaderRenderer(AbstractPdfSelectionTableModel tableModel, TableCellRenderer tableCellRenderer) {
        this.tableModel = tableModel;
        this.tableCellRenderer = tableCellRenderer;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component c = this.tableCellRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (c instanceof JLabel) {
            JLabel l = (JLabel)c;
            l.setHorizontalTextPosition(2);
            int modelColumn = table.convertColumnIndexToModel(column);
            l.setIcon(this.getHeaderRendererIcon(modelColumn, l.getFont().getSize()));
        }
        return c;
    }

    private Icon getHeaderRendererIcon(int column, int size) {
        Arrow retVal = null;
        AbstractPdfSelectionTableModel.SortingState sortingState = this.tableModel.getSortingState();
        if (sortingState != null && 0 != sortingState.getSortType() && column == sortingState.getCol()) {
            retVal = new Arrow(sortingState.getSortType() != -1, size);
        }
        return retVal;
    }

    private static class Arrow
    implements Icon {
        private boolean descending;
        private int size;

        public Arrow(boolean descending, int size) {
            this.descending = descending;
            this.size = size;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Color color = c == null ? Color.GRAY : c.getBackground();
            int dx = this.size / 2;
            int dy = this.descending ? dx : -dx;
            y = y + 5 * this.size / 6 + (this.descending ? -dy : 0);
            int shift = this.descending ? 1 : -1;
            g.translate(x, y);
            g.setColor(color.darker());
            g.drawLine(dx / 2, dy, 0, 0);
            g.drawLine(dx / 2, dy + shift, 0, shift);
            g.setColor(color.brighter());
            g.drawLine(dx / 2, dy, dx, 0);
            g.drawLine(dx / 2, dy + shift, dx, shift);
            if (this.descending) {
                g.setColor(color.darker().darker());
            } else {
                g.setColor(color.brighter().brighter());
            }
            g.drawLine(dx, 0, 0, 0);
            g.setColor(color);
            g.translate(-x, -y);
        }

        @Override
        public int getIconWidth() {
            return this.size;
        }

        @Override
        public int getIconHeight() {
            return this.size;
        }
    }
}

