/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.guiclient.plugins;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.pdfsam.guiclient.configuration.Configuration;
import org.pdfsam.guiclient.exceptions.PluginException;
import org.pdfsam.guiclient.plugins.interfaces.AbstractPlugablePanel;
import org.pdfsam.guiclient.plugins.models.PluginDataModel;
import org.pdfsam.guiclient.utils.XmlUtility;
import org.pdfsam.guiclient.utils.filters.JarFilter;
import org.pdfsam.i18n.GettextResource;

public class PlugInsLoader {
    private static final Logger log = Logger.getLogger(PlugInsLoader.class.getPackage().getName());
    private File pluginsDirectory;
    private File[] pluginsList;
    private static final Class<?> PLUGIN_SUPER_CLASS = AbstractPlugablePanel.class;

    public PlugInsLoader(String pluginsDirectory) throws PluginException {
        if (pluginsDirectory != null && pluginsDirectory.length() > 0) {
            this.pluginsDirectory = new File(pluginsDirectory);
        } else {
            try {
                String configSearchPath = new File(URLDecoder.decode(this.getClass().getProtectionDomain().getCodeSource().getLocation().getPath(), "UTF-8")).getParent();
                this.pluginsDirectory = new File(configSearchPath, "plugins");
            }
            catch (Exception e) {
                throw new PluginException(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Error getting plugins directory."), e);
            }
        }
        this.pluginsList = this.getPlugInsList();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private File[] getPlugInsList() throws PluginException {
        ArrayList<File> retVal = new ArrayList<File>();
        if (this.pluginsDirectory == null) throw new PluginException(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Plugins directory is null."));
        if (!this.pluginsDirectory.isDirectory() || !this.pluginsDirectory.canRead()) throw new PluginException(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Cannot read plugins directory ") + this.pluginsDirectory.getAbsolutePath());
        try {
            File[] pluginsSubDirs = this.pluginsDirectory.listFiles();
            for (int i = 0; i < pluginsSubDirs.length; ++i) {
                if (!pluginsSubDirs[i].isDirectory()) continue;
                retVal.add(pluginsSubDirs[i]);
            }
            return retVal.toArray(new File[retVal.size()]);
        }
        catch (Exception e) {
            throw new PluginException("Error getting plugins list", e);
        }
    }

    private File getMostRecent(File[] files, String parentDirectory) {
        File retVal = null;
        if (files.length > 0) {
            if (files.length == 1) {
                retVal = files[0];
            } else {
                log.warn(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Found many plugins in ") + parentDirectory + ".");
                for (File currentFile : files) {
                    if (retVal != null && currentFile.lastModified() <= retVal.lastModified()) continue;
                    retVal = currentFile;
                }
                log.warn(retVal.getAbsolutePath() + " " + GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"selected as the most recent plugin") + ".");
            }
        } else {
            log.error(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"No plugin found in ") + parentDirectory);
        }
        return retVal;
    }

    public Map<PluginDataModel, AbstractPlugablePanel> loadPlugins() throws PluginException {
        TreeMap<PluginDataModel, AbstractPlugablePanel> retMap = new TreeMap<PluginDataModel, AbstractPlugablePanel>();
        URLClassLoader urlClassLoader = null;
        ArrayList<URL> urlList = new ArrayList<URL>();
        ArrayList<String> classList = new ArrayList<String>();
        for (File currentDir : this.pluginsList) {
            if (currentDir != null && currentDir.isDirectory()) {
                try {
                    Document document = XmlUtility.parseXmlFile(new File(currentDir.getAbsolutePath(), "config.xml"));
                    File[] fileList = currentDir.listFiles(new JarFilter(false));
                    File selectedFile = this.getMostRecent(fileList, currentDir.getAbsolutePath());
                    if (selectedFile == null) continue;
                    urlList.add(selectedFile.toURI().toURL());
                    classList.add(XmlUtility.getXmlValue(document, "/plugin/data/classname"));
                }
                catch (Exception e) {
                    log.error(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Exception loading plugins."), e);
                }
                continue;
            }
            log.error(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Cannot read plugin directory ") + currentDir);
        }
        urlClassLoader = new URLClassLoader(urlList.toArray(new URL[urlList.size()]));
        for (String className : classList) {
            try {
                Class<?> currentClass = urlClassLoader.loadClass(className);
                if (currentClass.getSuperclass().isAssignableFrom(PLUGIN_SUPER_CLASS)) {
                    AbstractPlugablePanel instance = (AbstractPlugablePanel)currentClass.newInstance();
                    PluginDataModel pluginDataModel = new PluginDataModel(instance.getPluginName(), instance.getVersion(), instance.getPluginAuthor(), className);
                    retMap.put(pluginDataModel, instance);
                    log.info(pluginDataModel.getName() + GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)" plugin loaded."));
                    continue;
                }
                log.error(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Unable to load a plugin that is not JPanel subclass."));
            }
            catch (Exception e) {
                log.error(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Error loading class ") + className, e);
            }
        }
        return retMap;
    }
}

