/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.io;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.io.SeekableInput;

public class SeekableByteArrayInputStream
extends ByteArrayInputStream
implements SeekableInput {
    private static final Logger log = Logger.getLogger(SeekableByteArrayInputStream.class.toString());
    private int m_iBeginningOffset;
    private Object m_oCurrentUser;

    public SeekableByteArrayInputStream(byte[] buf) {
        super(buf);
        this.m_iBeginningOffset = 0;
    }

    public SeekableByteArrayInputStream(byte[] buf, int offset, int length) {
        super(buf, offset, length);
        this.m_iBeginningOffset = offset;
    }

    public void seekAbsolute(long absolutePosition) {
        int absPos = (int)(absolutePosition & 0xFFFFFFFFFFFFFFFFL);
        this.pos = this.m_iBeginningOffset + absPos;
    }

    public void seekRelative(long relativeOffset) {
        int relOff = (int)(relativeOffset & 0xFFFFFFFFFFFFFFFFL);
        int currPos = this.pos + relOff;
        if (currPos < this.m_iBeginningOffset) {
            currPos = this.m_iBeginningOffset;
        }
        this.pos = currPos;
    }

    public void seekEnd() {
        this.seekAbsolute(this.getLength());
    }

    public long getAbsolutePosition() {
        int absPos = this.pos - this.m_iBeginningOffset;
        return (long)absPos & 0xFFFFFFFFFFFFFFFFL;
    }

    public long getLength() {
        int len = this.count - this.m_iBeginningOffset;
        return (long)len & 0xFFFFFFFFFFFFFFFFL;
    }

    public InputStream getInputStream() {
        return this;
    }

    public synchronized void beginThreadAccess() {
        Thread requestingUser = Thread.currentThread();
        while (true) {
            if (this.m_oCurrentUser == null) {
                this.m_oCurrentUser = requestingUser;
                break;
            }
            if (this.m_oCurrentUser == requestingUser) break;
            try {
                this.wait(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public synchronized void endThreadAccess() {
        Thread requestingUser = Thread.currentThread();
        if (this.m_oCurrentUser == null) {
            this.notifyAll();
        } else if (this.m_oCurrentUser == requestingUser) {
            this.m_oCurrentUser = null;
            this.notifyAll();
        } else if (log.isLoggable(Level.SEVERE)) {
            log.severe("ERROR:  Thread finished using SeekableInput, but it wasn't locked by that Thread\n        Thread: " + Thread.currentThread() + "\n" + "        Locking Thread: " + this.m_oCurrentUser + "\n" + "        SeekableInput: " + this);
        }
    }
}

