/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.swing.graphics;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class BackedPanel
extends JPanel
implements Serializable {
    private Graphics backingGraphics = null;
    protected BufferedImage backingImage = null;
    private Object lock = new Object();
    private Dimension oldDimension = new Dimension();
    private Dimension dim = new Dimension();
    protected Rectangle clip = new Rectangle();
    private static final String NON_NULL_BORDER_ERROR = "BackedPanel does not support borders.";

    public BackedPanel(boolean opaque) {
        super(false);
        this.setOpaque(opaque);
    }

    public Graphics getGraphics() {
        return this.backingGraphics;
    }

    public Object getLock() {
        return this.lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintComponent(Graphics g) {
        if (g != null && this.backingImage != null) {
            this.clip = g.getClipBounds(this.clip);
            Object object = this.getLock();
            synchronized (object) {
                BufferedImage subimage = this.backingImage.getSubimage(this.clip.x, this.clip.y, this.clip.width, this.clip.height);
                g.drawImage(subimage, this.clip.x, this.clip.y, this);
            }
        }
    }

    public void paintBorder(Graphics g) {
    }

    public void paintChildren(Graphics g) {
    }

    public void printComponent(Graphics g) {
    }

    public void printBorder(Graphics g) {
    }

    public void printChildren(Graphics g) {
    }

    public final void setBorder(Border border) {
        if (border != null) {
            throw new IllegalArgumentException(NON_NULL_BORDER_ERROR);
        }
    }

    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        this.makeImage();
    }

    public void reshape(int x, int y, int w, int h) {
        super.reshape(x, y, w, h);
        this.makeImage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeImage() {
        this.dim = this.getSize(this.dim);
        int w = this.dim.width;
        int h = this.dim.height;
        if (w > 0 && h > 0) {
            if (!this.oldDimension.equals(this.dim)) {
                Object object = this.getLock();
                synchronized (object) {
                    this.backingImage = this.isOpaque() ? (BufferedImage)super.createImage(w, h) : new BufferedImage(w, h, 2);
                    this.backingGraphics = this.backingImage.getGraphics();
                    this.oldDimension.setSize(this.dim);
                }
            }
        } else {
            Object object = this.getLock();
            synchronized (object) {
                this.backingImage = null;
                this.backingGraphics = null;
            }
        }
    }
}

