/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.model;

import java.nio.file.Path;
import java.nio.file.Paths;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.parosproxy.paros.Constant;
import org.zaproxy.zap.model.SessionUtils;

public class SessionUtilsUnitTest {
    private static final String ZAP_HOME = "/zap/";
    private static final String ZAP_SESSION_DIR = "/zap/session";

    @Test
    public void shouldRetrieveExistingSessionFileFromAbsolutePath() throws Exception {
        String string = "/test.session";
        Path path = SessionUtils.getSessionPath(string);
        Assert.assertThat((Object)path, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)Paths.get("/test.session", new String[0]))));
    }

    @Test
    public void shouldAppendSessionFiletypeAndRetrieveSessionFileFromAbsolutePath() throws Exception {
        String string = "/test";
        Path path = SessionUtils.getSessionPath(string);
        Assert.assertThat((Object)path, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)Paths.get("/test.session", new String[0]))));
    }

    @Test
    public void shouldRetrieveExistingSessionFileFromRelativePath() throws Exception {
        Constant.setZapHome(ZAP_HOME);
        String string = "test.session";
        Path path = SessionUtils.getSessionPath(string);
        Assert.assertThat((Object)path, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)Paths.get(ZAP_SESSION_DIR, "test.session"))));
    }

    @Test
    public void shouldAppendSessionFiletypeAndRetrieveSessionFileFromRelativePath() throws Exception {
        Constant.setZapHome(ZAP_HOME);
        String string = "test";
        Path path = SessionUtils.getSessionPath(string);
        Assert.assertThat((Object)path, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)Paths.get(ZAP_SESSION_DIR, "test.session"))));
    }

    @Test(expected=NullPointerException.class)
    public void shouldFailOnNullForSessionInput() throws Exception {
        SessionUtils.getSessionPath(null);
    }
}

