/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.utils;

import net.sf.json.JSONObject;
import org.parosproxy.paros.model.Model;
import org.zaproxy.zap.extension.api.ApiException;
import org.zaproxy.zap.model.Context;

public final class ApiUtils {
    public static int getIntParam(JSONObject jSONObject, String string) throws ApiException {
        int n;
        try {
            n = jSONObject.getInt(string);
        }
        catch (Exception exception) {
            throw new ApiException(ApiException.Type.MISSING_PARAMETER, string + ": " + exception.getLocalizedMessage());
        }
        return n;
    }

    public static String getOptionalStringParam(JSONObject jSONObject, String string) {
        if (jSONObject.containsKey((Object)string)) {
            return jSONObject.getString(string);
        }
        return null;
    }

    public static String getNonEmptyStringParam(JSONObject jSONObject, String string) throws ApiException {
        if (!jSONObject.containsKey((Object)string)) {
            throw new ApiException(ApiException.Type.MISSING_PARAMETER, string);
        }
        String string2 = jSONObject.getString(string);
        if (string2 == null || string2.isEmpty()) {
            throw new ApiException(ApiException.Type.MISSING_PARAMETER, string);
        }
        return string2;
    }

    public static <E extends Enum<E>> E getOptionalEnumParam(JSONObject jSONObject, String string, Class<E> clazz) throws ApiException {
        String string2 = jSONObject.optString(string, null);
        E e = null;
        if (string2 != null && !string2.isEmpty()) {
            try {
                e = Enum.valueOf(clazz, string2);
            }
            catch (Exception exception) {
                throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, string + ": " + exception.getLocalizedMessage());
            }
        }
        return e;
    }

    public static Context getContextByParamId(JSONObject jSONObject, String string) throws ApiException {
        int n = ApiUtils.getIntParam(jSONObject, string);
        Context context = Model.getSingleton().getSession().getContext(n);
        if (context == null) {
            throw new ApiException(ApiException.Type.CONTEXT_NOT_FOUND, string);
        }
        return context;
    }

    private ApiUtils() {
    }
}

