/*
 * Decompiled with CFR 0.152.
 */
import java.sql.PreparedStatement;
import java.util.Vector;

class GdaJPStmt {
    private PreparedStatement ps;
    private Vector<GdaJValue> param_values;

    private static native void initIDs();

    public GdaJPStmt(PreparedStatement preparedStatement) {
        this.ps = preparedStatement;
        this.param_values = new Vector(0);
    }

    public void declareParamTypes(long l, byte[] byArray) throws Exception {
        int n = this.ps.getParameterMetaData().getParameterCount();
        if (byArray.length != n) {
            throw new Exception("Number of types differs from number of parameters: got " + byArray.length + " and expected " + n);
        }
        for (int i = 0; i < n; ++i) {
            GdaJValue gdaJValue = GdaJValue.proto_type_to_jvalue(byArray[i]);
            gdaJValue.setGdaConnectionPointer(l);
            this.param_values.add(gdaJValue);
        }
    }

    public void setParameterValue(int n, long l) throws Exception {
        GdaJValue gdaJValue = this.param_values.elementAt(n);
        gdaJValue.getCValue(this.ps, n, l);
    }

    public void clearParameters() throws Exception {
        this.ps.clearParameters();
    }

    public boolean execute() throws Exception {
        return this.ps.execute();
    }

    public GdaJResultSet getResultSet() throws Exception {
        return new GdaJResultSet(this.ps.getResultSet());
    }

    public int getImpactedRows() throws Exception {
        return this.ps.getUpdateCount();
    }

    static {
        GdaJPStmt.initIDs();
    }
}

