/*
 * Decompiled with CFR 0.152.
 */
package net.adaptivebox.space;

import net.adaptivebox.space.DesignDim;

public class DesignSpace {
    private DesignDim[] dimProps;

    public DesignSpace(int n) {
        this.dimProps = new DesignDim[n];
    }

    public void setElemAt(DesignDim designDim, int n) {
        this.dimProps[n] = designDim;
    }

    public int getDimension() {
        if (this.dimProps == null) {
            return -1;
        }
        return this.dimProps.length;
    }

    public double boundAdjustAt(double d, int n) {
        return this.dimProps[n].paramBound.boundAdjust(d);
    }

    public void mutationAt(double[] dArray, int n) {
        dArray[n] = this.dimProps[n].paramBound.getRandomValue();
    }

    public double getMagnitudeIn(int n) {
        return this.dimProps[n].paramBound.getLength();
    }

    public void initializeGene(double[] dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this.dimProps[i].paramBound.getRandomValue();
        }
    }

    public double[] getFreshGene() {
        double[] dArray = new double[this.getDimension()];
        this.initializeGene(dArray);
        return dArray;
    }

    public void getMappingPoint(double[] dArray) {
        for (int i = 0; i < this.getDimension(); ++i) {
            dArray[i] = this.dimProps[i].paramBound.annulusAdjust(dArray[i]);
            if (!this.dimProps[i].isDiscrete()) continue;
            dArray[i] = this.dimProps[i].getGrainedValue(dArray[i]);
        }
    }
}

