/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.report.pentaho.output.text;

import java.util.HashMap;
import java.util.Map;
import org.jfree.layouting.input.style.values.CSSNumericValue;
import org.jfree.report.ReportProcessingException;
import org.jfree.report.structure.Element;
import org.jfree.report.structure.Section;
import org.jfree.report.util.AttributeNameGenerator;
import org.libreoffice.report.pentaho.model.OfficeMasterPage;
import org.libreoffice.report.pentaho.model.OfficeMasterStyles;
import org.libreoffice.report.pentaho.model.OfficeStyles;
import org.libreoffice.report.pentaho.model.PageLayout;
import org.libreoffice.report.pentaho.model.RawText;

public class MasterPageFactory {
    private static final String DEFAULT_PAGE_NAME = "Default";
    private final OfficeMasterStyles predefinedStyles;
    private final AttributeNameGenerator masterPageNameGenerator;
    private final Map<MasterPageFactoryKey, OfficeMasterPage> masterPages;
    private final AttributeNameGenerator pageLayoutNameGenerator;
    private final Map<PageLayoutKey, String> pageLayouts;

    public MasterPageFactory(OfficeMasterStyles officeMasterStyles) {
        this.predefinedStyles = officeMasterStyles;
        this.masterPages = new HashMap<MasterPageFactoryKey, OfficeMasterPage>();
        this.masterPageNameGenerator = new AttributeNameGenerator();
        this.pageLayouts = new HashMap<PageLayoutKey, String>();
        this.pageLayoutNameGenerator = new AttributeNameGenerator();
    }

    public OfficeMasterPage getMasterPage(String string, String string2, String string3) {
        MasterPageFactoryKey masterPageFactoryKey = new MasterPageFactoryKey(string, string2, string3);
        return this.masterPages.get(masterPageFactoryKey);
    }

    public boolean containsMasterPage(String string, String string2, String string3) {
        MasterPageFactoryKey masterPageFactoryKey = new MasterPageFactoryKey(string, string2, string3);
        return this.masterPages.containsKey(masterPageFactoryKey);
    }

    public OfficeMasterPage createMasterPage(String string, String string2, String string3) {
        MasterPageFactoryKey masterPageFactoryKey = new MasterPageFactoryKey(string, string2, string3);
        OfficeMasterPage officeMasterPage = this.masterPages.get(masterPageFactoryKey);
        if (officeMasterPage != null) {
            return officeMasterPage;
        }
        String string4 = this.masterPages.isEmpty() ? "Standard" : string;
        OfficeMasterPage officeMasterPage2 = this.predefinedStyles.getMasterPage(string);
        if (officeMasterPage2 == null) {
            officeMasterPage2 = this.predefinedStyles.getMasterPage(DEFAULT_PAGE_NAME);
        }
        if (officeMasterPage2 != null) {
            try {
                OfficeMasterPage officeMasterPage3 = (OfficeMasterPage)officeMasterPage2.clone();
                return this.setupMasterPage(officeMasterPage3, string4, string2, string3, masterPageFactoryKey);
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IllegalStateException("Implementation error: Unable to derive page", cloneNotSupportedException);
            }
        }
        OfficeMasterPage officeMasterPage4 = new OfficeMasterPage();
        officeMasterPage4.setNamespace("urn:oasis:names:tc:opendocument:xmlns:style:1.0");
        officeMasterPage4.setType("master-page");
        return this.setupMasterPage(officeMasterPage4, string4, string2, string3, masterPageFactoryKey);
    }

    private OfficeMasterPage setupMasterPage(OfficeMasterPage officeMasterPage, String string, String string2, String string3, MasterPageFactoryKey masterPageFactoryKey) {
        Section section;
        officeMasterPage.setStyleName(this.masterPageNameGenerator.generateName(string));
        this.masterPages.put(masterPageFactoryKey, officeMasterPage);
        if (string2 != null) {
            section = new Section();
            section.setNamespace("urn:oasis:names:tc:opendocument:xmlns:style:1.0");
            section.setType("header");
            section.addNode(new RawText(string2));
            officeMasterPage.addNode(section);
        }
        if (string3 != null) {
            section = new Section();
            section.setNamespace("urn:oasis:names:tc:opendocument:xmlns:style:1.0");
            section.setType("footer");
            section.addNode(new RawText(string3));
            officeMasterPage.addNode(section);
        }
        return officeMasterPage;
    }

    public String createPageStyle(OfficeStyles officeStyles, CSSNumericValue cSSNumericValue, CSSNumericValue cSSNumericValue2) {
        Section section;
        PageLayoutKey pageLayoutKey = new PageLayoutKey(null, cSSNumericValue, cSSNumericValue2);
        PageLayout pageLayout = new PageLayout();
        String string = this.pageLayoutNameGenerator.generateName("autogenerated");
        pageLayout.setStyleName(string);
        officeStyles.addPageStyle(pageLayout);
        if (cSSNumericValue != null) {
            section = new Section();
            section.setNamespace("urn:oasis:names:tc:opendocument:xmlns:style:1.0");
            section.setType("header-style");
            pageLayout.addNode(section);
            MasterPageFactory.applyHeaderFooterHeight(section, cSSNumericValue);
        }
        if (cSSNumericValue2 != null) {
            section = new Section();
            section.setNamespace("urn:oasis:names:tc:opendocument:xmlns:style:1.0");
            section.setType("footer-style");
            pageLayout.addNode(section);
            MasterPageFactory.applyHeaderFooterHeight(section, cSSNumericValue2);
        }
        this.pageLayouts.put(pageLayoutKey, string);
        return string;
    }

    public String derivePageStyle(String string, OfficeStyles officeStyles, OfficeStyles officeStyles2, CSSNumericValue cSSNumericValue, CSSNumericValue cSSNumericValue2) throws ReportProcessingException {
        if (string == null) {
            throw new NullPointerException("A style-name must be given");
        }
        PageLayoutKey pageLayoutKey = new PageLayoutKey(string, cSSNumericValue, cSSNumericValue2);
        String string2 = this.pageLayouts.get(pageLayoutKey);
        if (string2 != null) {
            return string2;
        }
        PageLayout pageLayout = officeStyles.getPageStyle(string);
        if (pageLayout == null) {
            throw new ReportProcessingException("Invalid page-layout '" + string + "', will not continue.");
        }
        try {
            Section section;
            PageLayout pageLayout2 = (PageLayout)pageLayout.clone();
            String string3 = this.pageLayoutNameGenerator.generateName(string);
            pageLayout2.setStyleName(string3);
            officeStyles2.addPageStyle(pageLayout2);
            if (cSSNumericValue != null) {
                section = pageLayout2.getHeaderStyle();
                if (section == null) {
                    section = new Section();
                    section.setNamespace("urn:oasis:names:tc:opendocument:xmlns:style:1.0");
                    section.setType("header-style");
                    pageLayout2.addNode(section);
                }
                MasterPageFactory.applyHeaderFooterHeight(section, cSSNumericValue);
            }
            if (cSSNumericValue2 != null) {
                section = pageLayout2.getFooterStyle();
                if (section == null) {
                    section = new Section();
                    section.setNamespace("urn:oasis:names:tc:opendocument:xmlns:style:1.0");
                    section.setType("footer-style");
                    pageLayout2.addNode(section);
                }
                MasterPageFactory.applyHeaderFooterHeight(section, cSSNumericValue2);
            }
            this.pageLayouts.put(pageLayoutKey, string3);
            return string3;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException("Clone failed.", cloneNotSupportedException);
        }
    }

    private static void applyHeaderFooterHeight(Section section, CSSNumericValue cSSNumericValue) {
        Element element = section.findFirstChild("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "header-footer-properties");
        if (element == null) {
            element = new Section();
            element.setNamespace("urn:oasis:names:tc:opendocument:xmlns:style:1.0");
            element.setType("header-footer-properties");
            section.addNode(element);
        }
        element.setAttribute("urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0", "height", cSSNumericValue.getValue() + cSSNumericValue.getType().getType());
    }

    private static class PageLayoutKey {
        private final String templateName;
        private final CSSNumericValue headerHeight;
        private final CSSNumericValue footerHeight;

        public PageLayoutKey(String string, CSSNumericValue cSSNumericValue, CSSNumericValue cSSNumericValue2) {
            this.templateName = string;
            this.headerHeight = cSSNumericValue;
            this.footerHeight = cSSNumericValue2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            PageLayoutKey pageLayoutKey = (PageLayoutKey)object;
            if (this.footerHeight != null ? !this.footerHeight.equals(pageLayoutKey.footerHeight) : pageLayoutKey.footerHeight != null) {
                return false;
            }
            if (this.headerHeight != null ? !this.headerHeight.equals(pageLayoutKey.headerHeight) : pageLayoutKey.headerHeight != null) {
                return false;
            }
            return !(this.templateName == null ? pageLayoutKey.templateName != null : !this.templateName.equals(pageLayoutKey.templateName));
        }

        public int hashCode() {
            int n = this.templateName != null ? this.templateName.hashCode() : 0;
            n = 31 * n + (this.headerHeight != null ? this.headerHeight.hashCode() : 0);
            n = 31 * n + (this.footerHeight != null ? this.footerHeight.hashCode() : 0);
            return n;
        }
    }

    private static class MasterPageFactoryKey {
        private final String template;
        private final String pageHeader;
        private final String pageFooter;

        public MasterPageFactoryKey(String string, String string2, String string3) {
            this.template = string;
            this.pageHeader = string2;
            this.pageFooter = string3;
        }

        public boolean equals(Object object) {
            if (this != object) {
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                MasterPageFactoryKey masterPageFactoryKey = (MasterPageFactoryKey)object;
                if (this.pageFooter != null ? !this.pageFooter.equals(masterPageFactoryKey.pageFooter) : masterPageFactoryKey.pageFooter != null) {
                    return false;
                }
                if (this.pageHeader != null ? !this.pageHeader.equals(masterPageFactoryKey.pageHeader) : masterPageFactoryKey.pageHeader != null) {
                    return false;
                }
                if (this.template != null ? !this.template.equals(masterPageFactoryKey.template) : masterPageFactoryKey.template != null) {
                    return false;
                }
            }
            return true;
        }

        public int hashCode() {
            int n = this.template != null ? this.template.hashCode() : 0;
            n = 31 * n + (this.pageHeader != null ? this.pageHeader.hashCode() : 0);
            n = 31 * n + (this.pageFooter != null ? this.pageFooter.hashCode() : 0);
            return n;
        }
    }
}

