/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.objects.AllocateObjectNode;
import org.jruby.truffle.nodes.objects.AllocateObjectNodeGen;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.layouts.Layouts;

@CoreClass(name="Time")
public abstract class TimeNodes {
    private static final DateTime ZERO = new DateTime(0L);

    public static DateTime getDateTime(DynamicObject time) {
        return Layouts.TIME.getDateTime(time);
    }

    @CoreMethod(names={"allocate"}, constructor=true)
    public static abstract class AllocateNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private AllocateObjectNode allocateObjectNode;

        public AllocateNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.allocateObjectNode = AllocateObjectNodeGen.create(context, sourceSection, null, null);
        }

        @Specialization
        public DynamicObject allocate(DynamicObject rubyClass) {
            return this.allocateObjectNode.allocate(rubyClass, ZERO, this.getContext().getCoreLibrary().getNilObject());
        }
    }

    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="self"), @NodeChild(type=RubyNode.class, value="offset")})
    public static abstract class InternalSetOffsetNode
    extends CoreMethodNode {
        public InternalSetOffsetNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object internalSetOffset(DynamicObject time, Object offset) {
            Layouts.TIME.setOffset(time, offset);
            return offset;
        }
    }

    @NodeChild(type=RubyNode.class, value="self")
    public static abstract class InternalOffsetNode
    extends CoreMethodNode {
        public InternalOffsetNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object internalOffset(DynamicObject time) {
            return Layouts.TIME.getOffset(time);
        }
    }

    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="self"), @NodeChild(type=RubyNode.class, value="isGMT")})
    public static abstract class InternalSetGMTNode
    extends CoreMethodNode {
        public InternalSetGMTNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public boolean internalSetGMT(DynamicObject time, boolean isGMT) {
            if (isGMT) {
                Layouts.TIME.setDateTime(time, TimeNodes.getDateTime(time).withZone(DateTimeZone.UTC));
            }
            return isGMT;
        }
    }

    @NodeChild(type=RubyNode.class, value="self")
    public static abstract class InternalGMTNode
    extends CoreMethodNode {
        public InternalGMTNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean internalGMT(DynamicObject time) {
            return Layouts.TIME.getOffset(time) == this.nil() && (TimeNodes.getDateTime(time).getZone().equals((Object)DateTimeZone.UTC) || TimeNodes.getDateTime(time).getZone().getOffset(TimeNodes.getDateTime(time).getMillis()) == 0);
        }
    }

    @CoreMethod(names={"initialize_copy"}, required=1)
    public static abstract class InitializeCopyNode
    extends CoreMethodArrayArgumentsNode {
        public InitializeCopyNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubyTime(from)"})
        public Object initializeCopy(DynamicObject self, DynamicObject from) {
            Layouts.TIME.setDateTime(self, TimeNodes.getDateTime(from));
            Layouts.TIME.setOffset(self, Layouts.TIME.getOffset(from));
            return self;
        }
    }
}

