/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.guiclient.commons.business.loaders.callable;

import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.Callable;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.pdfsam.guiclient.commons.panels.JPdfSelectionPanel;
import org.pdfsam.guiclient.configuration.Configuration;
import org.pdfsam.guiclient.dto.PdfSelectionTableItem;
import org.pdfsam.guiclient.utils.filters.PdfFilter;
import org.pdfsam.i18n.GettextResource;

public class AddPdfDocument
implements Callable<Boolean> {
    private static final Logger LOG = Logger.getLogger(AddPdfDocument.class.getPackage().getName());
    private static String TITLE = PdfName.decodeName((String)PdfName.TITLE.toString());
    private static String PRODUCER = PdfName.decodeName((String)PdfName.PRODUCER.toString());
    private static String AUTHOR = PdfName.decodeName((String)PdfName.AUTHOR.toString());
    private static String SUBJECT = PdfName.decodeName((String)PdfName.SUBJECT.toString());
    private static String CREATOR = PdfName.decodeName((String)PdfName.CREATOR.toString());
    private static String MODDATE = PdfName.decodeName((String)PdfName.MODDATE.toString());
    private static String CREATIONDATE = PdfName.decodeName((String)PdfName.CREATIONDATE.toString());
    private static String KEYWORDS = PdfName.decodeName((String)PdfName.KEYWORDS.toString());
    String wipText;
    File inputFile;
    String password;
    String pageSelection;
    JPdfSelectionPanel panel;

    public AddPdfDocument(File inputFile, JPdfSelectionPanel panel) {
        this(inputFile, panel, null, null);
    }

    public AddPdfDocument(File inputFile, JPdfSelectionPanel panel, String password, String pageSelection) {
        this.inputFile = inputFile;
        this.pageSelection = pageSelection;
        this.password = password;
        this.panel = panel;
    }

    @Override
    public Boolean call() {
        Boolean retVal = Boolean.FALSE;
        try {
            if (this.inputFile != null) {
                if (new PdfFilter(false).accept(this.inputFile)) {
                    this.wipText = GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Please wait while reading") + " " + this.inputFile.getName() + " ...";
                    this.panel.addWipText(this.wipText);
                    this.panel.addTableRow(this.getPdfSelectionTableItem(this.inputFile, this.password, this.pageSelection));
                    this.panel.removeWipText(this.wipText);
                    retVal = Boolean.TRUE;
                } else {
                    LOG.warn(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Selected file is not a pdf document.") + " " + this.inputFile.getName());
                }
            }
        }
        catch (Throwable e) {
            LOG.error(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Error: "), e);
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PdfSelectionTableItem getPdfSelectionTableItem(File fileToAdd, String password, String pageSelection) {
        PdfSelectionTableItem tableItem = null;
        PdfReader pdfReader = null;
        if (fileToAdd != null) {
            tableItem = new PdfSelectionTableItem();
            tableItem.setInputFile(fileToAdd);
            tableItem.setPassword(password);
            tableItem.setPageSelection(pageSelection);
            try {
                pdfReader = new PdfReader(new RandomAccessFileOrArray(fileToAdd.getAbsolutePath()), password != null ? password.getBytes() : null);
                tableItem.setEncrypted(pdfReader.isEncrypted());
                tableItem.setFullPermission(pdfReader.isOpenedWithFullPermissions());
                if (tableItem.isEncrypted()) {
                    tableItem.setPermissions(this.getPermissionsVerbose(pdfReader.getPermissions()));
                    int cMode = pdfReader.getCryptoMode();
                    switch (cMode) {
                        case 0: {
                            tableItem.setEncryptionAlgorithm("RC4-40b");
                            break;
                        }
                        case 1: {
                            tableItem.setEncryptionAlgorithm("RC4-128b");
                            break;
                        }
                        case 2: {
                            tableItem.setEncryptionAlgorithm("AES-128b");
                            break;
                        }
                    }
                }
                tableItem.setPagesNumber(Integer.toString(pdfReader.getNumberOfPages()));
                tableItem.setFileSize(fileToAdd.length());
                tableItem.setPdfVersion(pdfReader.getPdfVersion());
                tableItem.setSyntaxErrors(pdfReader.isRebuilt());
                this.initTableItemDocumentData(pdfReader, tableItem);
            }
            catch (Exception e) {
                tableItem.setLoadedWithErrors(true);
                LOG.error(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Error loading ") + fileToAdd.getAbsolutePath() + " :", e);
            }
            finally {
                if (pdfReader != null) {
                    pdfReader.close();
                    pdfReader = null;
                }
            }
        }
        return tableItem;
    }

    private String getPermissionsVerbose(int permissions) {
        StringBuffer buf = new StringBuffer();
        if ((0x804 & permissions) == 2052) {
            buf.append(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Print"));
        }
        if ((8 & permissions) == 8) {
            buf.append(", " + GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Modify"));
        }
        if ((0x10 & permissions) == 16) {
            buf.append(", " + GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Copy or extract"));
        }
        if ((0x20 & permissions) == 32) {
            buf.append(", " + GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Add or modify text annotations"));
        }
        if ((0x100 & permissions) == 256) {
            buf.append(", " + GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Fill form fields"));
        }
        if ((0x200 & permissions) == 512) {
            buf.append(", " + GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Extract for use by accessibility dev."));
        }
        if ((0x400 & permissions) == 1024) {
            buf.append(", " + GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Manipulate pages and add bookmarks"));
        }
        if ((4 & permissions) == 4) {
            buf.append(", " + GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Low quality print"));
        }
        return buf.toString();
    }

    private void initTableItemDocumentData(PdfReader reader, PdfSelectionTableItem tableItem) {
        HashMap info;
        if (reader != null && tableItem != null && (info = reader.getInfo()) != null && info.size() > 0) {
            for (Map.Entry entry : info.entrySet()) {
                if (entry == null) continue;
                String key = (String)entry.getKey();
                String value = StringUtils.trimToEmpty((String)((String)entry.getValue()));
                if (key.equals(TITLE)) {
                    tableItem.getDocumentMetaData().setTitle(value);
                    continue;
                }
                if (key.equals(PRODUCER)) {
                    tableItem.getDocumentMetaData().setProducer(value);
                    continue;
                }
                if (key.equals(AUTHOR)) {
                    tableItem.getDocumentMetaData().setAuthor(value);
                    continue;
                }
                if (key.equals(SUBJECT)) {
                    tableItem.getDocumentMetaData().setSubject(value);
                    continue;
                }
                if (key.equals(CREATOR)) {
                    tableItem.getDocumentMetaData().setCreator(value);
                    continue;
                }
                if (key.equals(MODDATE)) {
                    tableItem.getDocumentMetaData().setModificationDate(value);
                    continue;
                }
                if (key.equals(CREATIONDATE)) {
                    tableItem.getDocumentMetaData().setCreationDate(value);
                    continue;
                }
                if (!key.equals(KEYWORDS)) continue;
                tableItem.getDocumentMetaData().setKeywords(value);
            }
        }
    }
}

