/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.pd;

import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSStream;
import de.intarsys.pdf.pd.PDCSCalGray;
import de.intarsys.pdf.pd.PDCSCalRGB;
import de.intarsys.pdf.pd.PDCSDeviceCMYK;
import de.intarsys.pdf.pd.PDCSDeviceGray;
import de.intarsys.pdf.pd.PDCSDeviceN;
import de.intarsys.pdf.pd.PDCSDeviceRGB;
import de.intarsys.pdf.pd.PDCSICCBased;
import de.intarsys.pdf.pd.PDCSIndexed;
import de.intarsys.pdf.pd.PDCSLab;
import de.intarsys.pdf.pd.PDCSPattern;
import de.intarsys.pdf.pd.PDCSSeparation;
import de.intarsys.pdf.pd.PDObject;

public abstract class PDColorSpace
extends PDObject {
    public static final COSName CN_CS_CalGray = COSName.constant("CalGray");
    public static final COSName CN_CS_CalRGB = COSName.constant("CalRGB");
    public static final COSName CN_CS_CMYK = COSName.constant("CMYK");
    public static final COSName CN_CS_DeviceCMYK = COSName.constant("DeviceCMYK");
    public static final COSName CN_CS_DeviceGray = COSName.constant("DeviceGray");
    public static final COSName CN_CS_DeviceN = COSName.constant("DeviceN");
    public static final COSName CN_CS_DeviceRGB = COSName.constant("DeviceRGB");
    public static final COSName CN_CS_DefaultGray = COSName.constant("DefaultGray");
    public static final COSName CN_CS_DefaultCMYK = COSName.constant("DefaultCMYK");
    public static final COSName CN_CS_DefaultRGB = COSName.constant("DefaultRGB");
    public static final COSName CN_CS_G = COSName.constant("G");
    public static final COSName CN_CS_ICCBased = COSName.constant("ICCBased");
    public static final COSName CN_CS_Indexed = COSName.constant("Indexed");
    public static final COSName CN_CS_I = COSName.constant("I");
    public static final COSName CN_CS_Lab = COSName.constant("Lab");
    public static final COSName CN_CS_Pattern = COSName.constant("Pattern");
    public static final COSName CN_CS_RGB = COSName.constant("RGB");
    public static final COSName CN_CS_Separation = COSName.constant("Separation");
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());

    public static PDColorSpace getNamed(COSName cOSName) {
        if (cOSName.equals(CN_CS_Pattern)) {
            return new PDCSPattern(cOSName);
        }
        return PDColorSpace.getSingleton(cOSName);
    }

    public static PDColorSpace getSingleton(COSName cOSName) {
        if (CN_CS_DeviceGray.equals(cOSName)) {
            return PDCSDeviceGray.SINGLETON;
        }
        if (CN_CS_G.equals(cOSName)) {
            return PDCSDeviceGray.SINGLETON;
        }
        if (CN_CS_DeviceRGB.equals(cOSName)) {
            return PDCSDeviceRGB.SINGLETON;
        }
        if (CN_CS_RGB.equals(cOSName)) {
            return PDCSDeviceRGB.SINGLETON;
        }
        if (CN_CS_DeviceCMYK.equals(cOSName)) {
            return PDCSDeviceCMYK.SINGLETON;
        }
        if (CN_CS_CMYK.equals(cOSName)) {
            return PDCSDeviceCMYK.SINGLETON;
        }
        return null;
    }

    protected PDColorSpace(COSObject cOSObject) {
        super(cOSObject);
    }

    public static class MetaClass
    extends PDObject.MetaClass {
        protected MetaClass(Class clazz) {
            super(clazz);
        }

        @Override
        protected COSBasedObject doCreateCOSBasedObject(COSObject cOSObject) {
            if (cOSObject instanceof COSName) {
                return PDColorSpace.getNamed((COSName)cOSObject);
            }
            if (cOSObject instanceof COSArray) {
                COSArray cOSArray = (COSArray)cOSObject;
                COSName cOSName = cOSArray.get(0).asName();
                if (cOSName == null) {
                    throw new IllegalArgumentException("ColorSpace array has no type");
                }
                if (cOSName.equals(CN_CS_DeviceCMYK) || cOSName.equals(CN_CS_CMYK)) {
                    return PDCSDeviceCMYK.SINGLETON;
                }
                if (cOSName.equals(CN_CS_DeviceRGB) || cOSName.equals(CN_CS_RGB)) {
                    return PDCSDeviceRGB.SINGLETON;
                }
                if (cOSName.equals(CN_CS_DeviceGray) || cOSName.equals(CN_CS_G)) {
                    return PDCSDeviceGray.SINGLETON;
                }
            }
            return this.doCreateCOSBasedObjectBasic(cOSObject);
        }

        public COSBasedObject doCreateCOSBasedObjectBasic(COSObject cOSObject) {
            return null;
        }

        @Override
        protected COSBasedObject.MetaClass doDetermineClass(COSObject cOSObject) {
            if (cOSObject instanceof COSStream) {
                return PDCSICCBased.META;
            }
            if (cOSObject instanceof COSArray) {
                COSName cOSName = ((COSArray)cOSObject).get(0).asName();
                if (cOSName == null) {
                    throw new IllegalArgumentException("ColorSpace array has no type");
                }
                if (cOSName.equals(CN_CS_CalGray)) {
                    return PDCSCalGray.META;
                }
                if (cOSName.equals(CN_CS_CalRGB)) {
                    return PDCSCalRGB.META;
                }
                if (cOSName.equals(CN_CS_Lab)) {
                    return PDCSLab.META;
                }
                if (cOSName.equals(CN_CS_ICCBased)) {
                    return PDCSICCBased.META;
                }
                if (cOSName.equals(CN_CS_Indexed) || cOSName.equals(CN_CS_I)) {
                    return PDCSIndexed.META;
                }
                if (cOSName.equals(CN_CS_Pattern)) {
                    return PDCSPattern.META;
                }
                if (cOSName.equals(CN_CS_Separation)) {
                    return PDCSSeparation.META;
                }
                if (cOSName.equals(CN_CS_DeviceN)) {
                    return PDCSDeviceN.META;
                }
            }
            return super.doDetermineClass(cOSObject);
        }

        @Override
        public Class getRootClass() {
            return PDColorSpace.class;
        }
    }
}

