/*
 * Decompiled with CFR 0.152.
 */
package net.adaptivebox.deps.behavior;

import net.adaptivebox.deps.behavior.AbsGTBehavior;
import net.adaptivebox.goodness.IGoodnessCompareEngine;
import net.adaptivebox.knowledge.Library;
import net.adaptivebox.knowledge.SearchPoint;
import net.adaptivebox.problem.ProblemEncoder;
import net.adaptivebox.space.BasicPoint;
import net.adaptivebox.space.DesignSpace;

public class PSGTBehavior
extends AbsGTBehavior {
    public double c1 = 2.0;
    public double c2 = 2.0;
    public double weight = 0.4;
    public double CL = 0.0;
    private BasicPoint pold_t;
    private BasicPoint pcurrent_t;
    private SearchPoint pbest_t;

    public void setMemPoints(SearchPoint searchPoint, BasicPoint basicPoint, BasicPoint basicPoint2) {
        this.pcurrent_t = basicPoint;
        this.pbest_t = searchPoint;
        this.pold_t = basicPoint2;
    }

    public void generateBehavior(SearchPoint searchPoint, ProblemEncoder problemEncoder) {
        SearchPoint searchPoint2 = this.socialLib.getGbest();
        DesignSpace designSpace = problemEncoder.getDesignSpace();
        int n = designSpace.getDimension();
        for (int i = 0; i < n; ++i) {
            double d;
            if (Math.random() < this.CL) {
                designSpace.mutationAt(searchPoint.getLocation(), i);
                continue;
            }
            double d2 = this.weight * (this.pcurrent_t.getLocation()[i] - this.pold_t.getLocation()[i]) + this.c1 * Math.random() * (this.pbest_t.getLocation()[i] - this.pcurrent_t.getLocation()[i]) + this.c2 * Math.random() * (searchPoint2.getLocation()[i] - this.pcurrent_t.getLocation()[i]);
            if (d2 < -(d = 0.5 * designSpace.getMagnitudeIn(i))) {
                d2 = -d;
            } else if (d2 > d) {
                d2 = d;
            }
            searchPoint.getLocation()[i] = this.pcurrent_t.getLocation()[i] + d2;
        }
    }

    public void testBehavior(SearchPoint searchPoint, IGoodnessCompareEngine iGoodnessCompareEngine) {
        Library.replace(iGoodnessCompareEngine, searchPoint, this.pbest_t);
        this.pold_t.importLocation(this.pcurrent_t);
        this.pcurrent_t.importLocation(searchPoint);
    }
}

