/*
 * Decompiled with CFR 0.152.
 */
package com.kitfox.svg;

import com.kitfox.svg.RenderableElement;
import com.kitfox.svg.SVGElement;
import com.kitfox.svg.SVGException;
import com.kitfox.svg.ShapeElement;
import com.kitfox.svg.xml.StyleAttribute;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.net.URI;

public class Use
extends ShapeElement {
    public static final String TAG_NAME = "use";
    float x = 0.0f;
    float y = 0.0f;
    float width = 1.0f;
    float height = 1.0f;
    URI href = null;
    AffineTransform refXform;

    @Override
    public String getTagName() {
        return TAG_NAME;
    }

    @Override
    protected void build() throws SVGException {
        super.build();
        StyleAttribute styleAttribute = new StyleAttribute();
        if (this.getPres(styleAttribute.setName("x"))) {
            this.x = styleAttribute.getFloatValueWithUnits();
        }
        if (this.getPres(styleAttribute.setName("y"))) {
            this.y = styleAttribute.getFloatValueWithUnits();
        }
        if (this.getPres(styleAttribute.setName("width"))) {
            this.width = styleAttribute.getFloatValueWithUnits();
        }
        if (this.getPres(styleAttribute.setName("height"))) {
            this.height = styleAttribute.getFloatValueWithUnits();
        }
        if (this.getPres(styleAttribute.setName("xlink:href"))) {
            URI uRI;
            this.href = uRI = styleAttribute.getURIValue(this.getXMLBase());
        }
        this.refXform = new AffineTransform();
        this.refXform.translate(this.x, this.y);
    }

    @Override
    public void render(Graphics2D graphics2D) throws SVGException {
        this.beginLayer(graphics2D);
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.transform(this.refXform);
        SVGElement sVGElement = this.diagram.getUniverse().getElement(this.href);
        if (sVGElement == null || !(sVGElement instanceof RenderableElement)) {
            return;
        }
        RenderableElement renderableElement = (RenderableElement)sVGElement;
        renderableElement.pushParentContext(this);
        renderableElement.render(graphics2D);
        renderableElement.popParentContext();
        graphics2D.setTransform(affineTransform);
        this.finishLayer(graphics2D);
    }

    @Override
    public Shape getShape() {
        SVGElement sVGElement = this.diagram.getUniverse().getElement(this.href);
        if (sVGElement instanceof ShapeElement) {
            Shape shape = ((ShapeElement)sVGElement).getShape();
            shape = this.refXform.createTransformedShape(shape);
            shape = this.shapeToParent(shape);
            return shape;
        }
        return null;
    }

    @Override
    public Rectangle2D getBoundingBox() throws SVGException {
        SVGElement sVGElement = this.diagram.getUniverse().getElement(this.href);
        if (sVGElement instanceof ShapeElement) {
            ShapeElement shapeElement = (ShapeElement)sVGElement;
            shapeElement.pushParentContext(this);
            Rectangle2D rectangle2D = shapeElement.getBoundingBox();
            shapeElement.popParentContext();
            rectangle2D = this.refXform.createTransformedShape(rectangle2D).getBounds2D();
            rectangle2D = this.boundsToParent(rectangle2D);
            return rectangle2D;
        }
        return null;
    }

    @Override
    public boolean updateTime(double d) throws SVGException {
        URI uRI;
        float f;
        boolean bl = super.updateTime(d);
        StyleAttribute styleAttribute = new StyleAttribute();
        boolean bl2 = false;
        if (this.getPres(styleAttribute.setName("x")) && (f = styleAttribute.getFloatValueWithUnits()) != this.x) {
            this.x = f;
            bl2 = true;
        }
        if (this.getPres(styleAttribute.setName("y")) && (f = styleAttribute.getFloatValueWithUnits()) != this.y) {
            this.y = f;
            bl2 = true;
        }
        if (this.getPres(styleAttribute.setName("width")) && (f = styleAttribute.getFloatValueWithUnits()) != this.width) {
            this.width = f;
            bl2 = true;
        }
        if (this.getPres(styleAttribute.setName("height")) && (f = styleAttribute.getFloatValueWithUnits()) != this.height) {
            this.height = f;
            bl2 = true;
        }
        if (this.getPres(styleAttribute.setName("xlink:href")) && !(uRI = styleAttribute.getURIValue(this.getXMLBase())).equals(this.href)) {
            this.href = uRI;
            bl2 = true;
        }
        if (bl2) {
            this.build();
        }
        return bl || bl2;
    }
}

