/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data;

import java.awt.Color;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReader;
import javax.json.JsonString;
import javax.json.JsonValue;
import javax.json.JsonWriter;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.data.preferences.ColorProperty;
import org.openstreetmap.josm.io.CachedFile;
import org.openstreetmap.josm.io.OfflineAccessException;
import org.openstreetmap.josm.io.OnlineResource;
import org.openstreetmap.josm.io.XmlWriter;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.ColorHelper;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;
import org.xml.sax.SAXException;

public class Preferences {
    private static final String[] OBSOLETE_PREF_KEYS = new String[]{"remote.control.host", "osm.notes.enableDownload", "mappaint.style.migration.switchedToMapCSS", "mappaint.style.migration.changedXmlName"};
    private File preferencesDir;
    private File cacheDir;
    private File userdataDir;
    private boolean saveOnPut = true;
    protected final SortedMap<String, Setting<?>> settingsMap = new TreeMap();
    protected final SortedMap<String, Setting<?>> defaultsMap = new TreeMap();
    protected final SortedMap<String, String> colornames = new TreeMap<String, String>();
    private final CopyOnWriteArrayList<PreferenceChangedListener> listeners = new CopyOnWriteArrayList();
    protected XMLStreamReader parser;

    public void addPreferenceChangeListener(PreferenceChangedListener preferenceChangedListener) {
        if (preferenceChangedListener != null) {
            this.listeners.addIfAbsent(preferenceChangedListener);
        }
    }

    public void removePreferenceChangeListener(PreferenceChangedListener preferenceChangedListener) {
        this.listeners.remove(preferenceChangedListener);
    }

    protected void firePreferenceChanged(String string, Setting<?> setting, Setting<?> setting2) {
        DefaultPreferenceChangeEvent defaultPreferenceChangeEvent = new DefaultPreferenceChangeEvent(string, setting, setting2);
        for (PreferenceChangedListener preferenceChangedListener : this.listeners) {
            preferenceChangedListener.preferenceChanged(defaultPreferenceChangeEvent);
        }
    }

    public File getPreferencesDirectory() {
        if (this.preferencesDir != null) {
            return this.preferencesDir;
        }
        String string = System.getProperty("josm.pref");
        this.preferencesDir = string != null ? new File(string).getAbsoluteFile() : ((string = System.getProperty("josm.home")) != null ? new File(string).getAbsoluteFile() : Main.platform.getDefaultPrefDirectory());
        return this.preferencesDir;
    }

    public File getUserDataDirectory() {
        if (this.userdataDir != null) {
            return this.userdataDir;
        }
        String string = System.getProperty("josm.userdata");
        this.userdataDir = string != null ? new File(string).getAbsoluteFile() : ((string = System.getProperty("josm.home")) != null ? new File(string).getAbsoluteFile() : Main.platform.getDefaultUserDataDirectory());
        return this.userdataDir;
    }

    public File getPreferenceFile() {
        return new File(this.getPreferencesDirectory(), "preferences.xml");
    }

    public File getPluginsDirectory() {
        return new File(this.getUserDataDirectory(), "plugins");
    }

    public File getCacheDirectory() {
        if (this.cacheDir != null) {
            return this.cacheDir;
        }
        String string = System.getProperty("josm.cache");
        this.cacheDir = string != null ? new File(string).getAbsoluteFile() : ((string = System.getProperty("josm.home")) != null ? new File(string, "cache") : ((string = this.get("cache.folder", null)) != null ? new File(string).getAbsoluteFile() : Main.platform.getDefaultCacheDirectory()));
        if (!this.cacheDir.exists() && !this.cacheDir.mkdirs()) {
            Main.warn(I18n.tr("Failed to create missing cache directory: {0}", this.cacheDir.getAbsoluteFile()));
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>Failed to create missing cache directory: {0}</html>", this.cacheDir.getAbsoluteFile()), I18n.tr("Error", new Object[0]), 0);
        }
        return this.cacheDir;
    }

    private static void addPossibleResourceDir(Set<String> set, String string) {
        if (string != null) {
            if (!string.endsWith(File.separator)) {
                string = string + File.separator;
            }
            set.add(string);
        }
    }

    public Collection<String> getAllPossiblePreferenceDirs() {
        HashSet<String> hashSet = new HashSet<String>();
        Preferences.addPossibleResourceDir(hashSet, this.getPreferencesDirectory().getPath());
        Preferences.addPossibleResourceDir(hashSet, this.getUserDataDirectory().getPath());
        Preferences.addPossibleResourceDir(hashSet, System.getenv("JOSM_RESOURCES"));
        Preferences.addPossibleResourceDir(hashSet, System.getProperty("josm.resources"));
        if (Main.isPlatformWindows()) {
            String string = System.getenv("APPDATA");
            if (System.getenv("ALLUSERSPROFILE") != null && string != null && string.lastIndexOf(File.separator) != -1) {
                string = string.substring(string.lastIndexOf(File.separator));
                hashSet.add(new File(new File(System.getenv("ALLUSERSPROFILE"), string), "JOSM").getPath());
            }
        } else {
            hashSet.add("/usr/local/share/josm/");
            hashSet.add("/usr/local/lib/josm/");
            hashSet.add("/usr/share/josm/");
            hashSet.add("/usr/lib/josm/");
        }
        return hashSet;
    }

    public synchronized String get(String string) {
        String string2 = this.get(string, null);
        return string2 == null ? "" : string2;
    }

    public synchronized String get(String string, String string2) {
        return (String)this.getSetting(string, new StringSetting(string2), StringSetting.class).getValue();
    }

    public synchronized Map<String, String> getAllPrefix(String string) {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        for (Map.Entry<String, Setting<?>> entry : this.settingsMap.entrySet()) {
            if (!entry.getKey().startsWith(string) || !(entry.getValue() instanceof StringSetting)) continue;
            treeMap.put(entry.getKey(), (String)((StringSetting)entry.getValue()).getValue());
        }
        return treeMap;
    }

    public synchronized List<String> getAllPrefixCollectionKeys(String string) {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (Map.Entry<String, Setting<?>> entry : this.settingsMap.entrySet()) {
            if (!entry.getKey().startsWith(string) || !(entry.getValue() instanceof ListSetting)) continue;
            linkedList.add(entry.getKey());
        }
        return linkedList;
    }

    public synchronized Map<String, String> getAllColors() {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        for (Map.Entry<String, Setting<?>> entry : this.defaultsMap.entrySet()) {
            StringSetting stringSetting;
            if (!entry.getKey().startsWith("color.") || !(entry.getValue() instanceof StringSetting) || (stringSetting = (StringSetting)entry.getValue()).getValue() == null) continue;
            treeMap.put(entry.getKey().substring(6), (String)stringSetting.getValue());
        }
        for (Map.Entry<String, Setting<?>> entry : this.settingsMap.entrySet()) {
            if (!entry.getKey().startsWith("color.") || !(entry.getValue() instanceof StringSetting)) continue;
            treeMap.put(entry.getKey().substring(6), (String)((StringSetting)entry.getValue()).getValue());
        }
        return treeMap;
    }

    public synchronized boolean getBoolean(String string) {
        String string2 = this.get(string, null);
        return string2 == null ? false : Boolean.parseBoolean(string2);
    }

    public synchronized boolean getBoolean(String string, boolean bl) {
        return Boolean.parseBoolean(this.get(string, Boolean.toString(bl)));
    }

    public synchronized boolean getBoolean(String string, String string2, boolean bl) {
        boolean bl2 = this.getBoolean(string, bl);
        String string3 = string + '.' + string2;
        Setting setting = (Setting)this.settingsMap.get(string3);
        if (setting instanceof StringSetting) {
            return Boolean.parseBoolean((String)((StringSetting)setting).getValue());
        }
        return bl2;
    }

    public boolean put(String string, String string2) {
        if (string2 != null && string2.isEmpty()) {
            string2 = null;
        }
        return this.putSetting(string, string2 == null ? null : new StringSetting(string2));
    }

    public boolean put(String string, boolean bl) {
        return this.put(string, Boolean.toString(bl));
    }

    public boolean putInteger(String string, Integer n) {
        return this.put(string, Integer.toString(n));
    }

    public boolean putDouble(String string, Double d) {
        return this.put(string, Double.toString(d));
    }

    public boolean putLong(String string, Long l) {
        return this.put(string, Long.toString(l));
    }

    public void save() throws IOException {
        this.putInteger("josm.version", Version.getInstance().getVersion());
        this.updateSystemProperties();
        File file = this.getPreferenceFile();
        File file2 = new File(file + "_backup");
        if (file.exists()) {
            Utils.copyFile(file, file2);
        }
        try (Object object = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(file + "_tmp"), StandardCharsets.UTF_8), false);){
            ((PrintWriter)object).print(this.toXML(false));
        }
        object = new File(file + "_tmp");
        Utils.copyFile((File)object, file);
        if (!((File)object).delete()) {
            Main.warn(I18n.tr("Unable to delete temporary file {0}", ((File)object).getAbsolutePath()));
        }
        Preferences.setCorrectPermissions(file);
        Preferences.setCorrectPermissions(file2);
    }

    private static void setCorrectPermissions(File file) {
        if (!file.setReadable(false, false) && Main.isDebugEnabled()) {
            Main.debug(I18n.tr("Unable to set file non-readable {0}", file.getAbsolutePath()));
        }
        if (!file.setWritable(false, false) && Main.isDebugEnabled()) {
            Main.debug(I18n.tr("Unable to set file non-writable {0}", file.getAbsolutePath()));
        }
        if (!file.setExecutable(false, false) && Main.isDebugEnabled()) {
            Main.debug(I18n.tr("Unable to set file non-executable {0}", file.getAbsolutePath()));
        }
        if (!file.setReadable(true, true) && Main.isDebugEnabled()) {
            Main.debug(I18n.tr("Unable to set file readable {0}", file.getAbsolutePath()));
        }
        if (!file.setWritable(true, true) && Main.isDebugEnabled()) {
            Main.debug(I18n.tr("Unable to set file writable {0}", file.getAbsolutePath()));
        }
    }

    public void load() throws IOException, SAXException, XMLStreamException {
        this.settingsMap.clear();
        File file = this.getPreferenceFile();
        try (BufferedReader bufferedReader = Files.newBufferedReader(file.toPath(), StandardCharsets.UTF_8);){
            this.validateXML(bufferedReader);
        }
        bufferedReader = Files.newBufferedReader(file.toPath(), StandardCharsets.UTF_8);
        var3_3 = null;
        try {
            this.fromXML(bufferedReader);
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (bufferedReader != null) {
                if (var3_3 != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    bufferedReader.close();
                }
            }
        }
        this.updateSystemProperties();
        this.removeObsolete();
    }

    public void init(boolean bl) {
        File file = this.getPreferencesDirectory();
        if (file.exists()) {
            if (!file.isDirectory()) {
                Main.warn(I18n.tr("Failed to initialize preferences. Preference directory ''{0}'' is not a directory.", file.getAbsoluteFile()));
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>Failed to initialize preferences.<br>Preference directory ''{0}'' is not a directory.</html>", file.getAbsoluteFile()), I18n.tr("Error", new Object[0]), 0);
                return;
            }
        } else if (!file.mkdirs()) {
            Main.warn(I18n.tr("Failed to initialize preferences. Failed to create missing preference directory: {0}", file.getAbsoluteFile()));
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>Failed to initialize preferences.<br>Failed to create missing preference directory: {0}</html>", file.getAbsoluteFile()), I18n.tr("Error", new Object[0]), 0);
            return;
        }
        File file2 = this.getPreferenceFile();
        try {
            if (!file2.exists()) {
                Main.info(I18n.tr("Missing preference file ''{0}''. Creating a default preference file.", file2.getAbsoluteFile()));
                this.resetToDefault();
                this.save();
            } else if (bl) {
                Main.warn(I18n.tr("Replacing existing preference file ''{0}'' with default preference file.", file2.getAbsoluteFile()));
                this.resetToDefault();
                this.save();
            }
        }
        catch (IOException iOException) {
            Main.error(iOException);
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>Failed to initialize preferences.<br>Failed to reset preference file to default: {0}</html>", this.getPreferenceFile().getAbsoluteFile()), I18n.tr("Error", new Object[0]), 0);
            return;
        }
        try {
            this.load();
        }
        catch (Exception exception) {
            Main.error(exception);
            File file3 = new File(file, "preferences.xml.bak");
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>Preferences file had errors.<br> Making backup of old one to <br>{0}<br> and creating a new default preference file.</html>", file3.getAbsoluteFile()), I18n.tr("Error", new Object[0]), 0);
            Main.platform.rename(file2, file3);
            try {
                this.resetToDefault();
                this.save();
            }
            catch (IOException iOException) {
                Main.error(iOException);
                Main.warn(I18n.tr("Failed to initialize preferences. Failed to reset preference file to default: {0}", this.getPreferenceFile()));
            }
        }
    }

    public final void resetToDefault() {
        this.settingsMap.clear();
    }

    public synchronized Color getColor(String string, Color color) {
        return this.getColor(string, null, color);
    }

    public synchronized Color getUIColor(String string) {
        return UIManager.getColor(string);
    }

    public synchronized String getColorName(String string) {
        Matcher matcher;
        try {
            matcher = Pattern.compile("mappaint\\.(.+?)\\.(.+)").matcher(string);
            if (matcher.matches()) {
                return I18n.tr("Paint style {0}: {1}", I18n.tr(I18n.escape(matcher.group(1)), new Object[0]), I18n.tr(I18n.escape(matcher.group(2)), new Object[0]));
            }
        }
        catch (Exception exception) {
            Main.warn(exception);
        }
        try {
            matcher = Pattern.compile("layer (.+)").matcher(string);
            if (matcher.matches()) {
                return I18n.tr("Layer: {0}", I18n.tr(I18n.escape(matcher.group(1)), new Object[0]));
            }
        }
        catch (Exception exception) {
            Main.warn(exception);
        }
        return I18n.tr(I18n.escape(this.colornames.containsKey(string) ? (String)this.colornames.get(string) : string), new Object[0]);
    }

    public Color getColor(ColorKey colorKey) {
        return this.getColor(colorKey.getColorName(), colorKey.getSpecialName(), colorKey.getDefaultValue());
    }

    public synchronized Color getColor(String string, String string2, Color color) {
        String string3;
        String string4 = ColorProperty.getColorKey(string);
        if (!string4.equals(string)) {
            this.colornames.put(string4, string);
        }
        String string5 = string3 = string2 != null ? this.get("color." + string2) : "";
        if (string3.isEmpty()) {
            string3 = this.get("color." + string4, ColorHelper.color2html(color, true));
        }
        if (string3 != null && !string3.isEmpty()) {
            return ColorHelper.html2color(string3);
        }
        return color;
    }

    public synchronized Color getDefaultColor(String string) {
        StringSetting stringSetting = Utils.cast(this.defaultsMap.get("color." + string), StringSetting.class);
        String string2 = stringSetting == null ? null : (String)stringSetting.getValue();
        return string2 == null || string2.isEmpty() ? null : ColorHelper.html2color(string2);
    }

    public synchronized boolean putColor(String string, Color color) {
        return this.put("color." + string, color != null ? ColorHelper.color2html(color, true) : null);
    }

    public synchronized int getInteger(String string, int n) {
        String string2 = this.get(string, Integer.toString(n));
        if (string2.isEmpty()) {
            return n;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            if (Main.isTraceEnabled()) {
                Main.trace(numberFormatException.getMessage());
            }
            return n;
        }
    }

    public synchronized int getInteger(String string, String string2, int n) {
        String string3 = this.get(string + '.' + string2);
        if (string3.isEmpty()) {
            string3 = this.get(string, Integer.toString(n));
        }
        if (string3.isEmpty()) {
            return n;
        }
        try {
            return Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            if (Main.isTraceEnabled()) {
                Main.trace(numberFormatException.getMessage());
            }
            return n;
        }
    }

    public synchronized long getLong(String string, long l) {
        String string2 = this.get(string, Long.toString(l));
        if (null == string2) {
            return l;
        }
        try {
            return Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {
            if (Main.isTraceEnabled()) {
                Main.trace(numberFormatException.getMessage());
            }
            return l;
        }
    }

    public synchronized double getDouble(String string, double d) {
        String string2 = this.get(string, Double.toString(d));
        if (null == string2) {
            return d;
        }
        try {
            return Double.parseDouble(string2);
        }
        catch (NumberFormatException numberFormatException) {
            if (Main.isTraceEnabled()) {
                Main.trace(numberFormatException.getMessage());
            }
            return d;
        }
    }

    public Collection<String> getCollection(String string, Collection<String> collection) {
        return (Collection)this.getSetting(string, ListSetting.create(collection), ListSetting.class).getValue();
    }

    public Collection<String> getCollection(String string) {
        Collection<String> collection = this.getCollection(string, null);
        return collection == null ? Collections.emptyList() : collection;
    }

    public synchronized void removeFromCollection(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>(this.getCollection(string, Collections.emptyList()));
        arrayList.remove(string2);
        this.putCollection(string, arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean putSetting(String string, Setting<?> setting) {
        Setting setting2;
        CheckParameterUtil.ensureParameterNotNull(string);
        if (setting != null && setting.getValue() == null) {
            throw new IllegalArgumentException("setting argument must not have null value");
        }
        Setting<?> setting3 = null;
        Preferences preferences = this;
        synchronized (preferences) {
            if (setting == null) {
                setting2 = (Setting)this.settingsMap.remove(string);
                if (setting2 == null) {
                    return false;
                }
            } else {
                setting2 = (Setting)this.settingsMap.get(string);
                if (setting.equals(setting2)) {
                    return false;
                }
                if (setting2 == null && setting.equals(this.defaultsMap.get(string))) {
                    return false;
                }
                setting3 = setting.copy();
                this.settingsMap.put(string, setting3);
            }
            if (this.saveOnPut) {
                try {
                    this.save();
                }
                catch (IOException iOException) {
                    Main.warn(I18n.tr("Failed to persist preferences to ''{0}''", this.getPreferenceFile().getAbsoluteFile()));
                }
            }
        }
        this.firePreferenceChanged(string, setting2, setting3);
        return true;
    }

    public synchronized Setting<?> getSetting(String string, Setting<?> setting) {
        return this.getSetting(string, setting, Setting.class);
    }

    public synchronized <T extends Setting<?>> T getSetting(String string, T t, Class<T> clazz) {
        Setting setting;
        CheckParameterUtil.ensureParameterNotNull(string);
        CheckParameterUtil.ensureParameterNotNull(t);
        Setting setting2 = (Setting)this.defaultsMap.get(string);
        if (setting2 != null && setting2.getValue() != null && t.getValue() != null && !t.equals(setting2)) {
            Main.info("Defaults for " + string + " differ: " + t + " != " + this.defaultsMap.get(string));
        }
        if (t.getValue() != null || setting2 == null) {
            this.defaultsMap.put(string, t.copy());
        }
        if (clazz.isInstance(setting = (Setting)this.settingsMap.get(string))) {
            return (T)setting;
        }
        return t;
    }

    public boolean putCollection(String string, Collection<String> collection) {
        return this.putSetting(string, collection == null ? null : ListSetting.create(collection));
    }

    public boolean putCollectionBounded(String string, int n, Collection<String> collection) {
        ArrayList<String> arrayList = new ArrayList<String>(Math.min(n, collection.size()));
        for (String string2 : collection) {
            if (arrayList.size() >= n) break;
            arrayList.add(string2);
        }
        return this.putCollection(string, arrayList);
    }

    public synchronized Collection<Collection<String>> getArray(String string, Collection<Collection<String>> collection) {
        ListListSetting listListSetting = this.getSetting(string, ListListSetting.create(collection), ListListSetting.class);
        return (Collection)listListSetting.getValue();
    }

    public Collection<Collection<String>> getArray(String string) {
        Collection<Collection<String>> collection = this.getArray(string, null);
        return collection == null ? Collections.emptyList() : collection;
    }

    public boolean putArray(String string, Collection<Collection<String>> collection) {
        return this.putSetting(string, collection == null ? null : ListListSetting.create(collection));
    }

    public Collection<Map<String, String>> getListOfStructs(String string, Collection<Map<String, String>> collection) {
        return (Collection)this.getSetting(string, new MapListSetting((List<Map<String, String>>)(collection == null ? null : new ArrayList<Map<String, String>>(collection))), MapListSetting.class).getValue();
    }

    public boolean putListOfStructs(String string, Collection<Map<String, String>> collection) {
        return this.putSetting(string, collection == null ? null : new MapListSetting((List<Map<String, String>>)new ArrayList<Map<String, String>>(collection)));
    }

    public <T> List<T> getListOfStructs(String string, Class<T> clazz) {
        List<T> list = this.getListOfStructs(string, null, clazz);
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    public <T> List<T> getListOfStructs(String string, Collection<T> collection, Class<T> clazz) {
        Collection<Map<String, String>> collection2 = this.getListOfStructs(string, collection == null ? null : Preferences.serializeListOfStructs(collection, clazz));
        if (collection2 == null) {
            return collection == null ? null : new ArrayList<T>(collection);
        }
        ArrayList<T> arrayList = new ArrayList<T>();
        for (Map<String, String> map : collection2) {
            T t = Preferences.deserializeStruct(map, clazz);
            arrayList.add(t);
        }
        return arrayList;
    }

    public <T> boolean putListOfStructs(String string, Collection<T> collection, Class<T> clazz) {
        return this.putListOfStructs(string, Preferences.serializeListOfStructs(collection, clazz));
    }

    private static <T> Collection<Map<String, String>> serializeListOfStructs(Collection<T> collection, Class<T> clazz) {
        if (collection == null) {
            return null;
        }
        ArrayList<Map<String, String>> arrayList = new ArrayList<Map<String, String>>();
        for (T t : collection) {
            if (t == null) continue;
            arrayList.add(Preferences.serializeStruct(t, clazz));
        }
        return arrayList;
    }

    private static String mapToJson(Map map) {
        StringWriter stringWriter = new StringWriter();
        try (JsonWriter jsonWriter = Json.createWriter(stringWriter);){
            JsonObjectBuilder jsonObjectBuilder = Json.createObjectBuilder();
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry;
                Map.Entry entry2 = entry = iterator.next();
                jsonObjectBuilder.add(entry2.getKey().toString(), entry2.getValue().toString());
            }
            jsonWriter.writeObject(jsonObjectBuilder.build());
        }
        return stringWriter.toString();
    }

    private static Map mapFromJson(String string) {
        HashMap hashMap = null;
        try (JsonReader jsonReader = Json.createReader(new StringReader(string));){
            JsonObject jsonObject = jsonReader.readObject();
            hashMap = new HashMap(jsonObject.size());
            for (Map.Entry entry : jsonObject.entrySet()) {
                JsonValue jsonValue = (JsonValue)entry.getValue();
                if (jsonValue instanceof JsonString) {
                    hashMap.put(entry.getKey(), ((JsonString)jsonValue).getString());
                    continue;
                }
                hashMap.put(entry.getKey(), ((JsonValue)entry.getValue()).toString());
            }
        }
        return hashMap;
    }

    public static <T> Map<String, String> serializeStruct(T t, Class<T> clazz) {
        T t2;
        try {
            t2 = clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException);
        }
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        for (Field field : clazz.getDeclaredFields()) {
            if (field.getAnnotation(pref.class) == null) continue;
            field.setAccessible(true);
            try {
                Object object = field.get(t);
                Object object2 = field.get(t2);
                if (object == null || field.getAnnotation(writeExplicitly.class) == null && Objects.equals(object, object2)) continue;
                String string = field.getName().replace('_', '-');
                if (object instanceof Map) {
                    linkedHashMap.put(string, Preferences.mapToJson((Map)object));
                    continue;
                }
                linkedHashMap.put(string, object.toString());
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                throw new RuntimeException(exception);
            }
        }
        return linkedHashMap;
    }

    public static <T> T deserializeStruct(Map<String, String> map, Class<T> clazz) {
        T t = null;
        try {
            t = clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException);
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            Field field;
            Object object;
            block21: {
                object = null;
                try {
                    field = clazz.getDeclaredField(entry.getKey().replace('-', '_'));
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    continue;
                }
                catch (SecurityException securityException) {
                    throw new RuntimeException(securityException);
                }
                if (field.getAnnotation(pref.class) == null) continue;
                field.setAccessible(true);
                if (field.getType() == Boolean.class || field.getType() == Boolean.TYPE) {
                    object = Boolean.valueOf(entry.getValue());
                } else {
                    if (field.getType() == Integer.class || field.getType() == Integer.TYPE) {
                        try {
                            object = Integer.valueOf(entry.getValue());
                            break block21;
                        }
                        catch (NumberFormatException numberFormatException) {
                            continue;
                        }
                    }
                    if (field.getType() == Double.class || field.getType() == Double.TYPE) {
                        try {
                            object = Double.valueOf(entry.getValue());
                            break block21;
                        }
                        catch (NumberFormatException numberFormatException) {
                            continue;
                        }
                    }
                    if (field.getType() == String.class) {
                        object = entry.getValue();
                    } else if (field.getType().isAssignableFrom(Map.class)) {
                        object = Preferences.mapFromJson(entry.getValue());
                    } else {
                        throw new RuntimeException("unsupported preference primitive type");
                    }
                }
            }
            try {
                field.set(t, object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new AssertionError((Object)illegalArgumentException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException);
            }
        }
        return t;
    }

    public Map<String, Setting<?>> getAllSettings() {
        return new TreeMap(this.settingsMap);
    }

    public Map<String, Setting<?>> getAllDefaults() {
        return new TreeMap(this.defaultsMap);
    }

    public void updateSystemProperties() {
        block6: {
            if ("true".equals(this.get("prefer.ipv6", "auto")) && !"true".equals(Utils.updateSystemProperty("java.net.preferIPv6Addresses", "true"))) {
                Main.info(I18n.tr("Try enabling IPv6 network, prefering IPv6 over IPv4 (only works on early startup).", new Object[0]));
            }
            Utils.updateSystemProperty("http.agent", Version.getInstance().getAgentString());
            Utils.updateSystemProperty("user.language", this.get("language"));
            if (!GraphicsEnvironment.isHeadless()) {
                try {
                    Field field = Toolkit.class.getDeclaredField("resources");
                    field.setAccessible(true);
                    field.set(null, ResourceBundle.getBundle("sun.awt.resources.awt"));
                }
                catch (Exception | InternalError throwable) {
                    if (!Main.isTraceEnabled()) break block6;
                    Main.trace(throwable.getMessage());
                }
            }
        }
        if (this.getBoolean("jdk.tls.disableSNIExtension", true)) {
            Utils.updateSystemProperty("jsse.enableSNIExtension", "false");
        }
        if (this.getBoolean("jdk.Arrays.useLegacyMergeSort", !Version.getInstance().isLocalBuild())) {
            Utils.updateSystemProperty("java.util.Arrays.useLegacyMergeSort", "true");
        }
    }

    public Collection<String> getPluginSites() {
        return this.getCollection("pluginmanager.sites", Collections.singleton(Main.getJOSMWebsite() + "/pluginicons%<?plugins=>"));
    }

    public Collection<String> getOnlinePluginSites() {
        ArrayList<String> arrayList = new ArrayList<String>(this.getPluginSites());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            try {
                OnlineResource.JOSM_WEBSITE.checkOfflineAccess((String)iterator.next(), Main.getJOSMWebsite());
            }
            catch (OfflineAccessException offlineAccessException) {
                Main.warn(offlineAccessException, false);
                iterator.remove();
            }
        }
        return arrayList;
    }

    public void setPluginSites(Collection<String> collection) {
        this.putCollection("pluginmanager.sites", collection);
    }

    public void validateXML(Reader reader) throws IOException, SAXException {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try (InputStream inputStream = new CachedFile("resource://data/preferences.xsd").getInputStream();){
            Schema schema = schemaFactory.newSchema(new StreamSource(inputStream));
            Validator validator = schema.newValidator();
            validator.validate(new StreamSource(reader));
        }
    }

    public void fromXML(Reader reader) throws XMLStreamException {
        XMLStreamReader xMLStreamReader;
        this.parser = xMLStreamReader = XMLInputFactory.newInstance().createXMLStreamReader(reader);
        this.parse();
    }

    public void parse() throws XMLStreamException {
        int n = this.parser.getEventType();
        while (true) {
            if (n == 1) {
                this.parseRoot();
            } else if (n == 2) {
                return;
            }
            if (!this.parser.hasNext()) break;
            n = this.parser.next();
        }
        this.parser.close();
    }

    public void parseRoot() throws XMLStreamException {
        while (true) {
            int n;
            if ((n = this.parser.next()) == 1) {
                String string;
                switch (string = this.parser.getLocalName()) {
                    case "tag": {
                        this.settingsMap.put(this.parser.getAttributeValue(null, "key"), new StringSetting(this.parser.getAttributeValue(null, "value")));
                        this.jumpToEnd();
                        break;
                    }
                    case "list": 
                    case "collection": 
                    case "lists": 
                    case "maps": {
                        this.parseToplevelList();
                        break;
                    }
                    default: {
                        this.throwException("Unexpected element: " + string);
                        break;
                    }
                }
                continue;
            }
            if (n == 2) break;
        }
    }

    private void jumpToEnd() throws XMLStreamException {
        while (true) {
            int n;
            if ((n = this.parser.next()) == 1) {
                this.jumpToEnd();
                continue;
            }
            if (n == 2) break;
        }
    }

    protected void parseToplevelList() throws XMLStreamException {
        String string = this.parser.getAttributeValue(null, "key");
        String string2 = this.parser.getLocalName();
        ArrayList<String> arrayList = null;
        ArrayList<List<String>> arrayList2 = null;
        ArrayList<Map<String, String>> arrayList3 = null;
        while (true) {
            int n;
            if ((n = this.parser.next()) == 1) {
                String string3;
                switch (string3 = this.parser.getLocalName()) {
                    case "entry": {
                        if (arrayList == null) {
                            arrayList = new ArrayList<String>();
                        }
                        arrayList.add(this.parser.getAttributeValue(null, "value"));
                        this.jumpToEnd();
                        break;
                    }
                    case "list": {
                        if (arrayList2 == null) {
                            arrayList2 = new ArrayList<List<String>>();
                        }
                        arrayList2.add(this.parseInnerList());
                        break;
                    }
                    case "map": {
                        if (arrayList3 == null) {
                            arrayList3 = new ArrayList<Map<String, String>>();
                        }
                        arrayList3.add(this.parseMap());
                        break;
                    }
                    default: {
                        this.throwException("Unexpected element: " + string3);
                        break;
                    }
                }
                continue;
            }
            if (n == 2) break;
        }
        if (arrayList != null) {
            this.settingsMap.put(string, new ListSetting(Collections.unmodifiableList(arrayList)));
        } else if (arrayList2 != null) {
            this.settingsMap.put(string, new ListListSetting(Collections.unmodifiableList(arrayList2)));
        } else if (arrayList3 != null) {
            this.settingsMap.put(string, new MapListSetting(Collections.unmodifiableList(arrayList3)));
        } else if ("lists".equals(string2)) {
            this.settingsMap.put(string, new ListListSetting(Collections.emptyList()));
        } else if ("maps".equals(string2)) {
            this.settingsMap.put(string, new MapListSetting(Collections.emptyList()));
        } else {
            this.settingsMap.put(string, new ListSetting(Collections.emptyList()));
        }
    }

    protected List<String> parseInnerList() throws XMLStreamException {
        ArrayList<String> arrayList = new ArrayList<String>();
        while (true) {
            int n;
            if ((n = this.parser.next()) == 1) {
                if ("entry".equals(this.parser.getLocalName())) {
                    arrayList.add(this.parser.getAttributeValue(null, "value"));
                    this.jumpToEnd();
                    continue;
                }
                this.throwException("Unexpected element: " + this.parser.getLocalName());
                continue;
            }
            if (n == 2) break;
        }
        return Collections.unmodifiableList(arrayList);
    }

    protected Map<String, String> parseMap() throws XMLStreamException {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        while (true) {
            int n;
            if ((n = this.parser.next()) == 1) {
                if ("tag".equals(this.parser.getLocalName())) {
                    linkedHashMap.put(this.parser.getAttributeValue(null, "key"), this.parser.getAttributeValue(null, "value"));
                    this.jumpToEnd();
                    continue;
                }
                this.throwException("Unexpected element: " + this.parser.getLocalName());
                continue;
            }
            if (n == 2) break;
        }
        return Collections.unmodifiableMap(linkedHashMap);
    }

    protected void throwException(String string) {
        throw new RuntimeException(string + I18n.tr(" (at line {0}, column {1})", this.parser.getLocation().getLineNumber(), this.parser.getLocation().getColumnNumber()));
    }

    public String toXML(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<preferences xmlns=\"").append(Main.getXMLBase()).append("/preferences-1.0\" version=\"").append(Version.getInstance().getVersion()).append("\">\n");
        SettingToXml settingToXml = new SettingToXml(stringBuilder, bl);
        for (Map.Entry<String, Setting<?>> entry : this.settingsMap.entrySet()) {
            settingToXml.setKey(entry.getKey());
            entry.getValue().visit(settingToXml);
        }
        stringBuilder.append("</preferences>\n");
        return stringBuilder.toString();
    }

    public void removeObsolete() {
        if (this.getInteger("josm.version", Version.getInstance().getVersion()) < 8099) {
            for (String string : new String[]{"mappaint.style.entries", "taggingpreset.entries"}) {
                Collection<Map<String, String>> collection = this.getListOfStructs(string, (Collection<Map<String, String>>)null);
                if (collection == null) continue;
                ArrayList<Map<String, String>> arrayList = new ArrayList<Map<String, String>>();
                boolean bl = false;
                for (Map<String, String> map : collection) {
                    LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
                    for (Map.Entry<String, String> entry : map.entrySet()) {
                        String string2 = entry.getValue();
                        String string3 = entry.getKey();
                        if ("url".equals(string3) && string2.contains("josm.openstreetmap.de/josmfile") && !string2.contains("zip=1")) {
                            string2 = string2 + "&zip=1";
                            bl = true;
                        }
                        linkedHashMap.put(string3, string2);
                    }
                    arrayList.add(linkedHashMap);
                }
                if (!bl) continue;
                this.putListOfStructs(string, arrayList);
            }
        }
        for (String string : OBSOLETE_PREF_KEYS) {
            if (!this.settingsMap.containsKey(string)) continue;
            this.settingsMap.remove(string);
            Main.info(I18n.tr("Preference setting {0} has been removed since it is no longer used.", string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void enableSaveOnPut(boolean bl) {
        Preferences preferences = this;
        synchronized (preferences) {
            this.saveOnPut = bl;
        }
    }

    private class SettingToXml
    implements SettingVisitor {
        private StringBuilder b;
        private boolean noPassword;
        private String key;

        SettingToXml(StringBuilder stringBuilder, boolean bl) {
            this.b = stringBuilder;
            this.noPassword = bl;
        }

        public void setKey(String string) {
            this.key = string;
        }

        @Override
        public void visit(StringSetting stringSetting) {
            if (this.noPassword && "osm-server.password".equals(this.key)) {
                return;
            }
            if (stringSetting.equals(Preferences.this.defaultsMap.get(this.key))) {
                return;
            }
            this.b.append("  <tag key='");
            this.b.append(XmlWriter.encode(this.key));
            this.b.append("' value='");
            this.b.append(XmlWriter.encode((String)stringSetting.getValue()));
            this.b.append("'/>\n");
        }

        @Override
        public void visit(ListSetting listSetting) {
            if (listSetting.equals(Preferences.this.defaultsMap.get(this.key))) {
                return;
            }
            this.b.append("  <list key='").append(XmlWriter.encode(this.key)).append("'>\n");
            for (String string : (List)listSetting.getValue()) {
                this.b.append("    <entry value='").append(XmlWriter.encode(string)).append("'/>\n");
            }
            this.b.append("  </list>\n");
        }

        @Override
        public void visit(ListListSetting listListSetting) {
            if (listListSetting.equals(Preferences.this.defaultsMap.get(this.key))) {
                return;
            }
            this.b.append("  <lists key='").append(XmlWriter.encode(this.key)).append("'>\n");
            for (List list : (List)listListSetting.getValue()) {
                this.b.append("    <list>\n");
                for (String string : list) {
                    this.b.append("      <entry value='").append(XmlWriter.encode(string)).append("'/>\n");
                }
                this.b.append("    </list>\n");
            }
            this.b.append("  </lists>\n");
        }

        @Override
        public void visit(MapListSetting mapListSetting) {
            this.b.append("  <maps key='").append(XmlWriter.encode(this.key)).append("'>\n");
            for (Map map : (List)mapListSetting.getValue()) {
                this.b.append("    <map>\n");
                for (Map.Entry entry : map.entrySet()) {
                    this.b.append("      <tag key='").append(XmlWriter.encode((String)entry.getKey())).append("' value='").append(XmlWriter.encode((String)entry.getValue())).append("'/>\n");
                }
                this.b.append("    </map>\n");
            }
            this.b.append("  </maps>\n");
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface writeExplicitly {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface pref {
    }

    public static interface ColorKey {
        public String getColorName();

        public String getSpecialName();

        public Color getDefaultValue();
    }

    private static class DefaultPreferenceChangeEvent
    implements PreferenceChangeEvent {
        private final String key;
        private final Setting<?> oldValue;
        private final Setting<?> newValue;

        DefaultPreferenceChangeEvent(String string, Setting<?> setting, Setting<?> setting2) {
            this.key = string;
            this.oldValue = setting;
            this.newValue = setting2;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public Setting<?> getOldValue() {
            return this.oldValue;
        }

        @Override
        public Setting<?> getNewValue() {
            return this.newValue;
        }
    }

    public static interface PreferenceChangedListener {
        public void preferenceChanged(PreferenceChangeEvent var1);
    }

    public static interface PreferenceChangeEvent {
        public String getKey();

        public Setting<?> getOldValue();

        public Setting<?> getNewValue();
    }

    public static interface SettingVisitor {
        public void visit(StringSetting var1);

        public void visit(ListSetting var1);

        public void visit(ListListSetting var1);

        public void visit(MapListSetting var1);
    }

    public static class MapListSetting
    extends AbstractSetting<List<Map<String, String>>> {
        public MapListSetting(List<Map<String, String>> list) {
            super(list);
            this.consistencyTest();
        }

        @Override
        public boolean equalVal(List<Map<String, String>> list) {
            if (this.value == null) {
                return list == null;
            }
            if (list == null) {
                return false;
            }
            if (((List)this.value).size() != list.size()) {
                return false;
            }
            Iterator iterator = ((List)this.value).iterator();
            Iterator<Map<String, String>> iterator2 = list.iterator();
            while (iterator.hasNext()) {
                if (MapListSetting.equalMap((Map)iterator.next(), iterator2.next())) continue;
                return false;
            }
            return true;
        }

        private static boolean equalMap(Map<String, String> map, Map<String, String> map2) {
            if (map == null) {
                return map2 == null;
            }
            if (map2 == null) {
                return false;
            }
            if (map.size() != map2.size()) {
                return false;
            }
            for (Map.Entry<String, String> entry : map.entrySet()) {
                if (Objects.equals(entry.getValue(), map2.get(entry.getKey()))) continue;
                return false;
            }
            return true;
        }

        public MapListSetting copy() {
            if (this.value == null) {
                return new MapListSetting(null);
            }
            ArrayList arrayList = new ArrayList(((List)this.value).size());
            for (Map map : (List)this.value) {
                LinkedHashMap linkedHashMap = new LinkedHashMap(map);
                arrayList.add(Collections.unmodifiableMap(linkedHashMap));
            }
            return new MapListSetting(Collections.unmodifiableList(arrayList));
        }

        private void consistencyTest() {
            if (this.value == null) {
                return;
            }
            if (((List)this.value).contains(null)) {
                throw new RuntimeException("Error: Null as list element in preference setting");
            }
            for (Map map : (List)this.value) {
                if (map.keySet().contains(null)) {
                    throw new RuntimeException("Error: Null as map key in preference setting");
                }
                if (!map.values().contains(null)) continue;
                throw new RuntimeException("Error: Null as map value in preference setting");
            }
        }

        @Override
        public void visit(SettingVisitor settingVisitor) {
            settingVisitor.visit(this);
        }

        public MapListSetting getNullInstance() {
            return new MapListSetting(null);
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof MapListSetting)) {
                return false;
            }
            return this.equalVal((List)((MapListSetting)object).getValue());
        }
    }

    public static class ListListSetting
    extends AbstractSetting<List<List<String>>> {
        public ListListSetting(List<List<String>> list) {
            super(list);
            this.consistencyTest();
        }

        public static ListListSetting create(Collection<Collection<String>> collection) {
            if (collection != null) {
                ArrayList<List<String>> arrayList = new ArrayList<List<String>>(collection.size());
                for (Collection<String> collection2 : collection) {
                    arrayList.add(new ArrayList<String>(collection2));
                }
                return new ListListSetting((List<List<String>>)arrayList);
            }
            return new ListListSetting(null);
        }

        @Override
        public boolean equalVal(List<List<String>> list) {
            if (this.value == null) {
                return list == null;
            }
            if (list == null) {
                return false;
            }
            if (((List)this.value).size() != list.size()) {
                return false;
            }
            Iterator iterator = ((List)this.value).iterator();
            Iterator<List<String>> iterator2 = list.iterator();
            while (iterator.hasNext()) {
                if (ListSetting.equalCollection((Collection)iterator.next(), (Collection<String>)iterator2.next())) continue;
                return false;
            }
            return true;
        }

        public ListListSetting copy() {
            if (this.value == null) {
                return new ListListSetting(null);
            }
            ArrayList arrayList = new ArrayList(((List)this.value).size());
            for (Collection collection : (List)this.value) {
                ArrayList arrayList2 = new ArrayList(collection);
                arrayList.add(Collections.unmodifiableList(arrayList2));
            }
            return new ListListSetting(Collections.unmodifiableList(arrayList));
        }

        private void consistencyTest() {
            if (this.value == null) {
                return;
            }
            if (((List)this.value).contains(null)) {
                throw new RuntimeException("Error: Null as list element in preference setting");
            }
            for (Collection collection : (List)this.value) {
                if (!collection.contains(null)) continue;
                throw new RuntimeException("Error: Null as inner list element in preference setting");
            }
        }

        @Override
        public void visit(SettingVisitor settingVisitor) {
            settingVisitor.visit(this);
        }

        public ListListSetting getNullInstance() {
            return new ListListSetting(null);
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof ListListSetting)) {
                return false;
            }
            return this.equalVal((List)((ListListSetting)object).getValue());
        }
    }

    public static class ListSetting
    extends AbstractSetting<List<String>> {
        public ListSetting(List<String> list) {
            super(list);
            this.consistencyTest();
        }

        public static ListSetting create(Collection<String> collection) {
            return new ListSetting(collection == null ? null : Collections.unmodifiableList(new ArrayList<String>(collection)));
        }

        @Override
        public boolean equalVal(List<String> list) {
            return ListSetting.equalCollection((Collection)this.value, list);
        }

        public static boolean equalCollection(Collection<String> collection, Collection<String> collection2) {
            if (collection == null) {
                return collection2 == null;
            }
            if (collection2 == null) {
                return false;
            }
            if (collection.size() != collection2.size()) {
                return false;
            }
            Iterator<String> iterator = collection.iterator();
            Iterator<String> iterator2 = collection2.iterator();
            while (iterator.hasNext()) {
                String string;
                String string2 = iterator.next();
                if (Objects.equals(string2, string = iterator2.next())) continue;
                return false;
            }
            return true;
        }

        public ListSetting copy() {
            return ListSetting.create((Collection)this.value);
        }

        private void consistencyTest() {
            if (this.value != null && ((List)this.value).contains(null)) {
                throw new RuntimeException("Error: Null as list element in preference setting");
            }
        }

        @Override
        public void visit(SettingVisitor settingVisitor) {
            settingVisitor.visit(this);
        }

        public ListSetting getNullInstance() {
            return new ListSetting(null);
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof ListSetting)) {
                return false;
            }
            return this.equalVal((List)((ListSetting)object).getValue());
        }
    }

    public static class StringSetting
    extends AbstractSetting<String> {
        public StringSetting(String string) {
            super(string);
        }

        @Override
        public boolean equalVal(String string) {
            if (this.value == null) {
                return string == null;
            }
            return ((String)this.value).equals(string);
        }

        public StringSetting copy() {
            return new StringSetting((String)this.value);
        }

        @Override
        public void visit(SettingVisitor settingVisitor) {
            settingVisitor.visit(this);
        }

        public StringSetting getNullInstance() {
            return new StringSetting(null);
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof StringSetting)) {
                return false;
            }
            return this.equalVal((String)((StringSetting)object).getValue());
        }
    }

    public static abstract class AbstractSetting<T>
    implements Setting<T> {
        protected final T value;

        public AbstractSetting(T t) {
            this.value = t;
        }

        @Override
        public T getValue() {
            return this.value;
        }

        public String toString() {
            return this.value != null ? this.value.toString() : "null";
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + (this.value == null ? 0 : this.value.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (!(object instanceof AbstractSetting)) {
                return false;
            }
            AbstractSetting abstractSetting = (AbstractSetting)object;
            return !(this.value == null ? abstractSetting.value != null : !this.value.equals(abstractSetting.value));
        }
    }

    public static interface Setting<T> {
        public T getValue();

        public boolean equalVal(T var1);

        public Setting<T> copy();

        public void visit(SettingVisitor var1);

        public Setting<T> getNullInstance();
    }
}

