/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.imagery;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.io.CachedFile;
import org.openstreetmap.josm.io.OfflineAccessException;
import org.openstreetmap.josm.io.OnlineResource;
import org.openstreetmap.josm.io.imagery.ImageryReader;
import org.xml.sax.SAXException;

public class ImageryLayerInfo {
    public static final ImageryLayerInfo instance = new ImageryLayerInfo();
    private final List<ImageryInfo> layers = new ArrayList<ImageryInfo>();
    private final Map<String, ImageryInfo> layerIds = new HashMap<String, ImageryInfo>();
    private static final List<ImageryInfo> defaultLayers = new ArrayList<ImageryInfo>();
    private static final Map<String, ImageryInfo> defaultLayerIds = new HashMap<String, ImageryInfo>();
    private static final String[] DEFAULT_LAYER_SITES = new String[]{Main.getJOSMWebsite() + "/maps"};

    public static Collection<String> getImageryLayersSites() {
        return Main.pref.getCollection("imagery.layers.sites", Arrays.asList(DEFAULT_LAYER_SITES));
    }

    private ImageryLayerInfo() {
    }

    public ImageryLayerInfo(ImageryLayerInfo imageryLayerInfo) {
        this.layers.addAll(imageryLayerInfo.layers);
    }

    public void clear() {
        this.layers.clear();
        this.layerIds.clear();
    }

    public void load() {
        this.clear();
        List<ImageryInfo.ImageryPreferenceEntry> list = Main.pref.getListOfStructs("imagery.entries", null, ImageryInfo.ImageryPreferenceEntry.class);
        if (list != null) {
            for (ImageryInfo.ImageryPreferenceEntry imageryPreferenceEntry : list) {
                try {
                    ImageryInfo imageryInfo = new ImageryInfo(imageryPreferenceEntry);
                    this.add(imageryInfo);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Main.warn("Unable to load imagery preference entry:" + illegalArgumentException);
                }
            }
            Collections.sort(this.layers);
        }
        this.loadDefaults(false);
    }

    public void loadDefaults(boolean bl) {
        defaultLayers.clear();
        defaultLayerIds.clear();
        for (String string : ImageryLayerInfo.getImageryLayersSites()) {
            boolean bl2 = true;
            try {
                OnlineResource.JOSM_WEBSITE.checkOfflineAccess(string, Main.getJOSMWebsite());
            }
            catch (OfflineAccessException offlineAccessException) {
                Main.warn(offlineAccessException.getMessage());
                bl2 = false;
            }
            if (bl && bl2) {
                CachedFile.cleanup(string);
            }
            try {
                ImageryReader imageryReader = new ImageryReader(string);
                List<ImageryInfo> list = imageryReader.parse();
                defaultLayers.addAll(list);
            }
            catch (IOException iOException) {
                Main.error(iOException, false);
            }
            catch (SAXException sAXException) {
                Main.error(sAXException);
            }
        }
        while (defaultLayers.remove(null)) {
        }
        Collections.sort(defaultLayers);
        ImageryLayerInfo.buildIdMap(defaultLayers, defaultLayerIds);
        this.updateEntriesFromDefaults();
        ImageryLayerInfo.buildIdMap(this.layers, this.layerIds);
    }

    private static void buildIdMap(List<ImageryInfo> list, Map<String, ImageryInfo> map) {
        map.clear();
        HashSet<String> hashSet = new HashSet<String>();
        for (ImageryInfo object : list) {
            if (object.getId() == null) continue;
            if (map.containsKey(object.getId())) {
                hashSet.add(object.getId());
                Main.error("Id ''{0}'' is not unique - used by ''{1}'' and ''{2}''!", object.getId(), object.getName(), map.get(object.getId()).getName());
                continue;
            }
            map.put(object.getId(), object);
        }
        for (String string : hashSet) {
            map.remove(string);
        }
    }

    public void updateEntriesFromDefaults() {
        ImageryInfo imageryInfo;
        Object object2;
        boolean bl = false;
        Collection<String> collection = Main.pref.getCollection("imagery.layers.default");
        TreeSet<String> treeSet = new TreeSet<String>(collection);
        for (ImageryInfo object22 : defaultLayers) {
            boolean bl2;
            if (object22.getNoTileHeaders() != null || object22.getTileSize() > 0 || object22.getMetadataHeaders() != null) {
                for (ImageryInfo bl3 : this.layers) {
                    if (!this.isSimilar(object22, bl3)) continue;
                    if (object22.getNoTileHeaders() != null) {
                        bl3.setNoTileHeaders(object22.getNoTileHeaders());
                    }
                    if (object22.getTileSize() > 0) {
                        bl3.setTileSize(object22.getTileSize());
                    }
                    if (object22.getMetadataHeaders() != null && object22.getMetadataHeaders().size() > 0) {
                        bl3.setMetadataHeaders(object22.getMetadataHeaders());
                    }
                    bl = true;
                }
            }
            if (!object22.isDefaultEntry()) continue;
            boolean i = false;
            for (Object object2 : collection) {
                if (!ImageryLayerInfo.isSimilar((String)object2, object22.getUrl())) continue;
                i = true;
                break;
            }
            boolean imageryInfo3 = false;
            if (!i) {
                treeSet.add(object22.getUrl());
                object2 = this.layers.iterator();
                while (object2.hasNext()) {
                    imageryInfo = object2.next();
                    if (!this.isSimilar(object22, imageryInfo)) continue;
                    bl2 = true;
                    break;
                }
            }
            if (i || bl2) continue;
            this.add(new ImageryInfo(object22));
            bl = true;
        }
        Main.pref.putCollection("imagery.layers.default", treeSet);
        Collection<String> collection2 = Main.pref.getCollection("imagery.layers.addedIds");
        TreeSet<String> treeSet2 = new TreeSet<String>(collection2);
        for (ImageryInfo imageryInfo2 : this.layers) {
            object2 = defaultLayers.iterator();
            while (object2.hasNext()) {
                imageryInfo = (ImageryInfo)object2.next();
                if (!this.isSimilar(imageryInfo, imageryInfo2) || imageryInfo.getId() == null || collection2.contains(imageryInfo.getId()) || !defaultLayerIds.containsKey(imageryInfo.getId())) continue;
                treeSet2.add(imageryInfo.getId());
                if (imageryInfo2.getId() != null) continue;
                imageryInfo2.setId(imageryInfo.getId());
                bl = true;
            }
        }
        Main.pref.putCollection("imagery.layers.addedIds", treeSet2);
        for (int i = 0; i < this.layers.size(); ++i) {
            ImageryInfo imageryInfo3 = this.layers.get(i);
            if (imageryInfo3.getId() == null || (object2 = defaultLayerIds.get(imageryInfo3.getId())) == null || ((ImageryInfo)object2).equalsPref(imageryInfo3)) continue;
            this.layers.set(i, (ImageryInfo)object2);
            bl = true;
        }
        if (bl) {
            this.save();
        }
    }

    private boolean isSimilar(ImageryInfo imageryInfo, ImageryInfo imageryInfo2) {
        if (imageryInfo == null) {
            return false;
        }
        if (!imageryInfo.getImageryType().equals((Object)imageryInfo2.getImageryType())) {
            return false;
        }
        if (imageryInfo.getId() != null && imageryInfo2.getId() != null) {
            return imageryInfo.getId().equals(imageryInfo2.getId());
        }
        return ImageryLayerInfo.isSimilar(imageryInfo.getUrl(), imageryInfo2.getUrl());
    }

    private static boolean isSimilar(String string, String string2) {
        return Objects.equals(string, string2) || string != null && string2 != null && !string.isEmpty() && !string2.isEmpty() && (string.contains(string2) || string2.contains(string));
    }

    public void add(ImageryInfo imageryInfo) {
        this.layers.add(imageryInfo);
    }

    public void remove(ImageryInfo imageryInfo) {
        this.layers.remove(imageryInfo);
    }

    public void save() {
        ArrayList<ImageryInfo.ImageryPreferenceEntry> arrayList = new ArrayList<ImageryInfo.ImageryPreferenceEntry>();
        for (ImageryInfo imageryInfo : this.layers) {
            arrayList.add(new ImageryInfo.ImageryPreferenceEntry(imageryInfo));
        }
        Main.pref.putListOfStructs("imagery.entries", arrayList, ImageryInfo.ImageryPreferenceEntry.class);
    }

    public List<ImageryInfo> getLayers() {
        return Collections.unmodifiableList(this.layers);
    }

    public List<ImageryInfo> getDefaultLayers() {
        return Collections.unmodifiableList(defaultLayers);
    }

    public static void addLayer(ImageryInfo imageryInfo) {
        instance.add(imageryInfo);
        instance.save();
    }

    public static void addLayers(Collection<ImageryInfo> collection) {
        for (ImageryInfo imageryInfo : collection) {
            instance.add(imageryInfo);
        }
        instance.save();
        Collections.sort(ImageryLayerInfo.instance.layers);
    }

    public String getUniqueId(ImageryInfo imageryInfo) {
        if (imageryInfo.getId() != null && this.layerIds.get(imageryInfo.getId()) == imageryInfo) {
            return imageryInfo.getId();
        }
        return null;
    }
}

