/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.plaf.basic.BasicArrowButton;
import org.openstreetmap.josm.tools.Destroyable;
import org.openstreetmap.josm.tools.ImageProvider;

public class SideButton
extends JButton
implements Destroyable {
    private static final int iconHeight = 20;
    private transient PropertyChangeListener propertyChangeListener;

    public SideButton(Action action) {
        super(action);
        this.fixIcon(action);
        this.doStyle();
    }

    public SideButton(Action action, boolean bl) {
        super(action);
        if (!bl) {
            this.setText(null);
            this.fixIcon(action);
            this.doStyle();
        }
    }

    public SideButton(Action action, String string) {
        super(action);
        this.setIcon(SideButton.makeIcon(string));
        this.doStyle();
    }

    private void fixIcon(Action action) {
        Icon icon;
        if (action != null) {
            this.propertyChangeListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getPropertyName() == "SmallIcon") {
                        SideButton.this.fixIcon(null);
                    }
                }
            };
            action.addPropertyChangeListener(this.propertyChangeListener);
        }
        if ((icon = this.getIcon()) instanceof ImageIcon && icon.getIconHeight() != 20) {
            this.setIcon(SideButton.getScaledImage(((ImageIcon)icon).getImage()));
        }
    }

    private static ImageIcon getScaledImage(Image image) {
        int n = image.getWidth(null) * 20 / image.getHeight(null);
        return new ImageIcon(image.getScaledInstance(n, 20, 4));
    }

    public static ImageIcon makeIcon(String string) {
        Image image = ImageProvider.get("dialogs", string).getImage();
        return SideButton.getScaledImage(image);
    }

    private void doStyle() {
        this.setLayout(new BorderLayout());
        this.setIconTextGap(2);
        this.setMargin(new Insets(0, 0, 0, 0));
    }

    public void createArrow(ActionListener actionListener) {
        this.setMargin(new Insets(0, 0, 0, 0));
        BasicArrowButton basicArrowButton = new BasicArrowButton(5, null, null, Color.BLACK, null);
        basicArrowButton.setBorder(BorderFactory.createEmptyBorder());
        this.add((Component)basicArrowButton, "East");
        basicArrowButton.addActionListener(actionListener);
    }

    @Override
    public void destroy() {
        Action action = this.getAction();
        if (action instanceof Destroyable) {
            ((Destroyable)((Object)action)).destroy();
        }
        if (action != null) {
            if (this.propertyChangeListener != null) {
                action.removePropertyChangeListener(this.propertyChangeListener);
            }
            this.setAction(null);
        }
    }
}

