/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Observable;
import java.util.Observer;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AbstractInfoAction;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.data.osm.history.History;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.gui.history.HistoryBrowserModel;
import org.openstreetmap.josm.gui.history.VersionTableColumnModel;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.io.XmlWriter;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.OpenBrowser;

public class VersionTable
extends JTable
implements Observer {
    private VersionTablePopupMenu popupMenu;
    private final transient HistoryBrowserModel model;

    protected void build() {
        this.getTableHeader().setFont(this.getTableHeader().getFont().deriveFont(9.0f));
        this.setRowSelectionAllowed(false);
        this.setShowGrid(false);
        this.setAutoResizeMode(0);
        this.setBackground(UIManager.getColor("Button.background"));
        this.setIntercellSpacing(new Dimension(6, 0));
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.popupMenu = new VersionTablePopupMenu();
        this.addMouseListener(new MouseListener());
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                long l = VersionTable.this.model.getReferencePointInTime().getVersion();
                long l2 = VersionTable.this.model.getCurrentPointInTime().getVersion();
                if (keyEvent.getKeyCode() == 40) {
                    History history = VersionTable.this.model.getHistory().from(l);
                    History history2 = VersionTable.this.model.getHistory().from(l2);
                    if (history.getNumVersions() > 1 && history2.getNumVersions() > 1) {
                        VersionTable.this.model.setReferencePointInTime(history.sortAscending().get(1));
                        VersionTable.this.model.setCurrentPointInTime(history2.sortAscending().get(1));
                    }
                } else if (keyEvent.getKeyCode() == 38) {
                    History history = VersionTable.this.model.getHistory().until(l);
                    History history3 = VersionTable.this.model.getHistory().until(l2);
                    if (history.getNumVersions() > 1 && history3.getNumVersions() > 1) {
                        VersionTable.this.model.setReferencePointInTime(history.sortDescending().get(1));
                        VersionTable.this.model.setCurrentPointInTime(history3.sortDescending().get(1));
                    }
                }
            }
        });
        this.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                VersionTable.adjustColumnWidth(VersionTable.this, 0, 0);
                VersionTable.adjustColumnWidth(VersionTable.this, 1, -8);
                VersionTable.adjustColumnWidth(VersionTable.this, 2, -8);
                VersionTable.adjustColumnWidth(VersionTable.this, 3, 0);
                VersionTable.adjustColumnWidth(VersionTable.this, 4, 0);
            }
        });
    }

    public VersionTable(HistoryBrowserModel historyBrowserModel) {
        super(historyBrowserModel.getVersionTableModel(), new VersionTableColumnModel());
        historyBrowserModel.addObserver(this);
        this.build();
        this.model = historyBrowserModel;
    }

    @Override
    public void scrollRectToVisible(Rectangle rectangle) {
        super.scrollRectToVisible(new Rectangle(0, rectangle.y, rectangle.width, rectangle.height));
    }

    protected HistoryBrowserModel.VersionTableModel getVersionTableModel() {
        return (HistoryBrowserModel.VersionTableModel)this.getModel();
    }

    @Override
    public void update(Observable observable, Object object) {
        this.repaint();
    }

    private static void adjustColumnWidth(JTable jTable, int n, int n2) {
        Object object;
        Object object2;
        int n3 = 0;
        for (int i = 0; i < jTable.getRowCount(); ++i) {
            object2 = jTable.getCellRenderer(i, n);
            object = jTable.getValueAt(i, n);
            Component component = object2.getTableCellRendererComponent(jTable, object, false, false, i, n);
            n3 = Math.max(component.getPreferredSize().width + n2, n3);
        }
        TableCellRenderer tableCellRenderer = jTable.getTableHeader().getDefaultRenderer();
        object2 = jTable.getColumnModel().getColumn(n).getHeaderValue();
        object = tableCellRenderer.getTableCellRendererComponent(jTable, object2, false, false, -1, n);
        n3 = Math.max(((Component)object).getPreferredSize().width + Main.pref.getInteger("table.header-inset", 0), n3);
        int n4 = jTable.getIntercellSpacing().width;
        jTable.getColumnModel().getColumn(n).setPreferredWidth(n3 + n4);
    }

    public static class AlignedRenderer
    extends JLabel
    implements TableCellRenderer {
        public AlignedRenderer(int n) {
            this.setHorizontalAlignment(n);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            String string = "";
            if (object != null) {
                string = object.toString();
            }
            this.setText(string);
            return this;
        }
    }

    public static class RadioButtonEditor
    extends DefaultCellEditor
    implements ItemListener {
        private JRadioButton btn = new JRadioButton();

        public RadioButtonEditor() {
            super(new JCheckBox());
            this.btn.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (object == null) {
                return null;
            }
            boolean bl2 = (Boolean)object;
            this.btn.setSelected(bl2);
            this.btn.addItemListener(this);
            return this.btn;
        }

        @Override
        public Object getCellEditorValue() {
            this.btn.removeItemListener(this);
            return this.btn.isSelected();
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            this.fireEditingStopped();
        }
    }

    public static class RadioButtonRenderer
    extends JRadioButton
    implements TableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setSelected(object != null && (Boolean)object != false);
            this.setHorizontalAlignment(0);
            return this;
        }
    }

    static class VersionTablePopupMenu
    extends JPopupMenu {
        private ChangesetInfoAction changesetInfoAction;
        private UserInfoAction userInfoAction;

        VersionTablePopupMenu() {
            this.build();
        }

        protected void build() {
            this.changesetInfoAction = new ChangesetInfoAction();
            this.add(this.changesetInfoAction);
            this.userInfoAction = new UserInfoAction();
            this.add(this.userInfoAction);
        }

        public void prepare(HistoryOsmPrimitive historyOsmPrimitive) {
            this.changesetInfoAction.prepare(historyOsmPrimitive);
            this.userInfoAction.prepare(historyOsmPrimitive);
            this.invalidate();
        }
    }

    static class UserInfoAction
    extends AbstractInfoAction {
        private transient HistoryOsmPrimitive primitive;

        UserInfoAction() {
            super(true);
            this.putValue("Name", I18n.tr("User info", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Launch browser with information about the user", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("data/user"));
        }

        @Override
        protected String createInfoUrl(Object object) {
            if (object instanceof HistoryOsmPrimitive) {
                HistoryOsmPrimitive historyOsmPrimitive = (HistoryOsmPrimitive)object;
                return historyOsmPrimitive.getUser() == null ? null : Main.getBaseUserUrl() + '/' + historyOsmPrimitive.getUser().getName();
            }
            return null;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.isEnabled()) {
                return;
            }
            String string = this.createInfoUrl(this.primitive);
            OpenBrowser.displayUrl(string);
        }

        public void prepare(HistoryOsmPrimitive historyOsmPrimitive) {
            User user = historyOsmPrimitive.getUser();
            this.putValue("Name", "<html>" + I18n.tr("Show user {0}", user == null ? "?" : XmlWriter.encode(user.getName(), true) + " <font color=gray>(" + user.getId() + ")</font>") + "</html>");
            this.primitive = historyOsmPrimitive;
        }
    }

    static class ChangesetInfoAction
    extends AbstractInfoAction {
        private transient HistoryOsmPrimitive primitive;

        ChangesetInfoAction() {
            super(true);
            this.putValue("Name", I18n.tr("Changeset info", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Launch browser with information about the changeset", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("data/changeset"));
        }

        @Override
        protected String createInfoUrl(Object object) {
            if (object instanceof HistoryOsmPrimitive) {
                HistoryOsmPrimitive historyOsmPrimitive = (HistoryOsmPrimitive)object;
                return Main.getBaseBrowseUrl() + "/changeset/" + historyOsmPrimitive.getChangesetId();
            }
            return null;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.isEnabled()) {
                return;
            }
            String string = this.createInfoUrl(this.primitive);
            OpenBrowser.displayUrl(string);
        }

        public void prepare(HistoryOsmPrimitive historyOsmPrimitive) {
            this.putValue("Name", I18n.tr("Show changeset {0}", historyOsmPrimitive.getChangesetId()));
            this.primitive = historyOsmPrimitive;
        }
    }

    final class MouseListener
    extends PopupMenuLauncher {
        private MouseListener() {
            super(VersionTable.this.popupMenu);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            super.mousePressed(mouseEvent);
            if (!mouseEvent.isPopupTrigger() && mouseEvent.getButton() == 1) {
                int n = VersionTable.this.rowAtPoint(mouseEvent.getPoint());
                int n2 = VersionTable.this.columnAtPoint(mouseEvent.getPoint());
                if (n >= 0 && (n2 == 3 || n2 == 4)) {
                    VersionTable.this.model.getVersionTableModel().setCurrentPointInTime(n);
                    VersionTable.this.model.getVersionTableModel().setReferencePointInTime(Math.max(0, n - 1));
                }
            }
        }

        @Override
        protected int checkTableSelection(JTable jTable, Point point) {
            HistoryBrowserModel.VersionTableModel versionTableModel = VersionTable.this.getVersionTableModel();
            int n = VersionTable.this.rowAtPoint(point);
            if (n > -1 && !versionTableModel.isLatest(n)) {
                VersionTable.this.popupMenu.prepare(versionTableModel.getPrimitive(n));
            }
            return n;
        }
    }
}

