/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.util;

import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.image.FilteredImageSource;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageOverlay;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.LanguageInfo;

public final class GuiHelper {
    private GuiHelper() {
    }

    public static void setEnabledRec(Container container, boolean bl) {
        Component[] componentArray;
        container.setEnabled(bl);
        for (Component component : componentArray = container.getComponents()) {
            if (component instanceof Container) {
                GuiHelper.setEnabledRec((Container)component, bl);
                continue;
            }
            component.setEnabled(bl);
        }
    }

    public static void executeByMainWorkerInEDT(final Runnable runnable) {
        Main.worker.submit(new Runnable(){

            @Override
            public void run() {
                GuiHelper.runInEDTAndWait(runnable);
            }
        });
    }

    public static void runInEDT(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public static void runInEDTAndWait(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InterruptedException | InvocationTargetException exception) {
                Main.error(exception);
            }
        }
    }

    public static <V> V runInEDTAndWaitAndReturn(Callable<V> callable) {
        if (SwingUtilities.isEventDispatchThread()) {
            try {
                return callable.call();
            }
            catch (Exception exception) {
                Main.error(exception);
                return null;
            }
        }
        FutureTask<V> futureTask = new FutureTask<V>(callable);
        SwingUtilities.invokeLater(futureTask);
        try {
            return futureTask.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            Main.error(exception);
            return null;
        }
    }

    public static boolean warnUser(String string, String string2, ImageIcon imageIcon, String string3) {
        ExtendedDialog extendedDialog = new ExtendedDialog(Main.parent, string, new String[]{I18n.tr("Cancel", new Object[0]), I18n.tr("Continue", new Object[0])});
        extendedDialog.setContent(string2);
        extendedDialog.setButtonIcons(new Icon[]{new ImageProvider("cancel").setMaxSize(ImageProvider.ImageSizes.LARGEICON).get(), new ImageProvider("upload").setMaxSize(ImageProvider.ImageSizes.LARGEICON).addOverlay(new ImageOverlay(new ImageProvider("warning-small"), 0.5, 0.5, 1.0, 1.0)).get()});
        extendedDialog.setToolTipTexts(new String[]{I18n.tr("Cancel", new Object[0]), string3});
        extendedDialog.setIcon(2);
        extendedDialog.setCancelButton(1);
        return extendedDialog.showDialog().getValue() != 2;
    }

    public static void notifyUserHtmlError(Component component, String string, String string2, String string3) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)new JLabel(string2), GBC.eol());
        jPanel.add((Component)new JLabel(I18n.tr("Received error page:", new Object[0])), GBC.eol());
        JScrollPane jScrollPane = GuiHelper.embedInVerticalScrollPane(new HtmlPanel(string3));
        jScrollPane.setPreferredSize(new Dimension(640, 240));
        jPanel.add((Component)jScrollPane, GBC.eol().fill(1));
        ExtendedDialog extendedDialog = new ExtendedDialog(component, string, new String[]{I18n.tr("OK", new Object[0])});
        extendedDialog.setButtonIcons(new String[]{"ok.png"});
        extendedDialog.setContent(jPanel);
        extendedDialog.showDialog();
    }

    public static Image getDisabledImage(Image image) {
        return Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(image.getSource(), new GrayFilter(true, 20)));
    }

    public static ImageIcon getDisabledIcon(ImageIcon imageIcon) {
        return new ImageIcon(GuiHelper.getDisabledImage(imageIcon.getImage()));
    }

    public static Component prepareResizeableOptionPane(final Component component, final Dimension dimension) {
        if (component != null) {
            component.addHierarchyListener(new HierarchyListener(){

                @Override
                public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                    Dialog dialog;
                    Window window = SwingUtilities.getWindowAncestor(component);
                    if (window instanceof Dialog && !(dialog = (Dialog)window).isResizable()) {
                        dialog.setResizable(true);
                        if (dimension != null) {
                            dialog.setMinimumSize(dimension);
                        }
                    }
                }
            });
        }
        return component;
    }

    public static Timer scheduleTimer(int n, ActionListener actionListener, boolean bl) {
        Timer timer = new Timer(n, actionListener);
        timer.setRepeats(bl);
        timer.start();
        return timer;
    }

    public static Stroke getCustomizedStroke(String string) {
        float f;
        String[] stringArray = string.trim().split("[^\\.0-9]+");
        if (stringArray.length == 0) {
            return new BasicStroke();
        }
        try {
            f = Float.parseFloat(stringArray[0]);
        }
        catch (NumberFormatException numberFormatException) {
            f = 1.0f;
        }
        if (stringArray.length > 1) {
            float[] fArray = new float[stringArray.length - 1];
            float f2 = 0.0f;
            try {
                for (int i = 0; i < stringArray.length - 1; ++i) {
                    fArray[i] = Float.parseFloat(stringArray[i + 1]);
                    f2 += Math.abs(fArray[i]);
                }
            }
            catch (NumberFormatException numberFormatException) {
                Main.error("Error in stroke preference format: " + string);
                fArray = new float[]{5.0f};
            }
            if ((double)f2 < 0.1) {
                Main.error("Error in stroke dash fomat (all zeros): " + string);
                return new BasicStroke(f);
            }
            return new BasicStroke(f, 0, 0, 10.0f, fArray, 0.0f);
        }
        if (f > 1.0f) {
            return new BasicStroke(f, 1, 1);
        }
        return new BasicStroke(f);
    }

    public static Font getMonospacedFont(JComponent jComponent) {
        if ("km".equals(LanguageInfo.getJOSMLocaleCode())) {
            return jComponent.getFont();
        }
        return new Font("Monospaced", jComponent.getFont().getStyle(), jComponent.getFont().getSize());
    }

    public static Font getTitleFont() {
        return new Font("SansSerif", 1, 23);
    }

    public static JScrollPane embedInVerticalScrollPane(Component component) {
        return new JScrollPane(component, 20, 31);
    }

    public static int getMenuShortcutKeyMaskEx() {
        return Main.isPlatformOsx() ? 256 : 128;
    }

    public static void setUIFont(String string) {
        CheckParameterUtil.ensureParameterNotNull(string, "name");
        Main.info("Setting " + string + " as the default UI font");
        Enumeration enumeration = UIManager.getDefaults().keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Object object = UIManager.get(k);
            if (!(object instanceof FontUIResource)) continue;
            FontUIResource fontUIResource = (FontUIResource)object;
            UIManager.put(k, new FontUIResource(string, fontUIResource.getStyle(), fontUIResource.getSize()));
        }
    }
}

