/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.IOException;
import java.io.StringReader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.SimplePrimitiveId;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.XmlParsingException;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DiffResultProcessor {
    private Map<PrimitiveId, DiffResultEntry> diffResults = new HashMap<PrimitiveId, DiffResultEntry>();
    private Set<OsmPrimitive> processed;
    private Collection<? extends OsmPrimitive> primitives;

    public DiffResultProcessor(Collection<? extends OsmPrimitive> collection) {
        if (collection == null) {
            collection = Collections.emptyList();
        }
        this.primitives = collection;
        this.processed = new HashSet<OsmPrimitive>();
    }

    public void parse(String string, ProgressMonitor progressMonitor) throws XmlParsingException {
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        CheckParameterUtil.ensureParameterNotNull(string, "diffUploadResponse");
        try {
            progressMonitor.beginTask(I18n.tr("Parsing response from server...", new Object[0]));
            InputSource inputSource = new InputSource(new StringReader(string));
            Utils.parseSafeSAX(inputSource, new Parser());
        }
        catch (XmlParsingException xmlParsingException) {
            throw xmlParsingException;
        }
        catch (IOException | ParserConfigurationException | SAXException exception) {
            throw new XmlParsingException(exception);
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<OsmPrimitive> postProcess(Changeset changeset, ProgressMonitor progressMonitor) {
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        DataSet dataSet = null;
        if (!this.primitives.isEmpty()) {
            dataSet = this.primitives.iterator().next().getDataSet();
        }
        if (dataSet != null) {
            dataSet.beginUpdate();
        }
        try {
            progressMonitor.beginTask("Postprocessing uploaded data ...");
            progressMonitor.setTicksCount(this.primitives.size());
            progressMonitor.setTicks(0);
            for (OsmPrimitive osmPrimitive : this.primitives) {
                progressMonitor.worked(1);
                DiffResultEntry diffResultEntry = this.diffResults.get(osmPrimitive.getPrimitiveId());
                if (diffResultEntry == null) continue;
                this.processed.add(osmPrimitive);
                if (!osmPrimitive.isDeleted()) {
                    osmPrimitive.setOsmId(diffResultEntry.newId, diffResultEntry.newVersion);
                    osmPrimitive.setVisible(true);
                } else {
                    osmPrimitive.setVisible(false);
                }
                if (changeset == null || changeset.isNew()) continue;
                osmPrimitive.setChangesetId(changeset.getId());
            }
            Set<OsmPrimitive> set = this.processed;
            return set;
        }
        finally {
            if (dataSet != null) {
                dataSet.endUpdate();
            }
            progressMonitor.finishTask();
        }
    }

    private class Parser
    extends DefaultHandler {
        private Locator locator;

        private Parser() {
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        protected void throwException(String string) throws XmlParsingException {
            throw new XmlParsingException(string).rememberLocation(this.locator);
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            try {
                switch (string3) {
                    case "diffResult": {
                        break;
                    }
                    case "node": 
                    case "way": 
                    case "relation": {
                        SimplePrimitiveId simplePrimitiveId = new SimplePrimitiveId(Long.parseLong(attributes.getValue("old_id")), OsmPrimitiveType.fromApiTypeName(string3));
                        DiffResultEntry diffResultEntry = new DiffResultEntry();
                        if (attributes.getValue("new_id") != null) {
                            diffResultEntry.newId = Long.parseLong(attributes.getValue("new_id"));
                        }
                        if (attributes.getValue("new_version") != null) {
                            diffResultEntry.newVersion = Integer.parseInt(attributes.getValue("new_version"));
                        }
                        DiffResultProcessor.this.diffResults.put(simplePrimitiveId, diffResultEntry);
                        break;
                    }
                    default: {
                        this.throwException(I18n.tr("Unexpected XML element with name ''{0}''", string3));
                        break;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new XmlParsingException(numberFormatException).rememberLocation(this.locator);
            }
        }
    }

    private static class DiffResultEntry {
        private long newId;
        private int newVersion;

        private DiffResultEntry() {
        }
    }
}

