/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.util.HashMap;
import java.util.Map;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Utils;

public final class OsmUrlToBounds {
    private static final String SHORTLINK_PREFIX = "http://osm.org/go/";
    private static final char[] SHORTLINK_CHARS = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '_', '@'};
    public static final double R = 6378137.0;

    private OsmUrlToBounds() {
    }

    public static Bounds parse(String string) {
        try {
            if (string.contains("%")) {
                string = Utils.decodeUrl(string);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Main.error(illegalArgumentException);
        }
        Bounds bounds = OsmUrlToBounds.parseShortLink(string);
        if (bounds != null) {
            return bounds;
        }
        int n = string.indexOf("#map");
        if (n >= 0) {
            return OsmUrlToBounds.parseHashURLs(string);
        }
        n = string.indexOf(63);
        if (n == -1) {
            return null;
        }
        String[] stringArray = string.substring(n + 1).split("&");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string2 : stringArray) {
            int n2 = string2.indexOf(61);
            if (n2 == -1) continue;
            hashMap.put(string2.substring(0, n2), string2.substring(n2 + 1));
        }
        try {
            if (hashMap.containsKey("bbox")) {
                String[] d = ((String)hashMap.get("bbox")).split(",");
                bounds = new Bounds(Double.parseDouble(d[1]), Double.parseDouble(d[0]), Double.parseDouble(d[3]), Double.parseDouble(d[2]));
            } else if (hashMap.containsKey("minlat")) {
                double runtimeException = Double.parseDouble((String)hashMap.get("minlat"));
                double d = Double.parseDouble((String)hashMap.get("minlon"));
                double d2 = Double.parseDouble((String)hashMap.get("maxlat"));
                double d3 = Double.parseDouble((String)hashMap.get("maxlon"));
                bounds = new Bounds(runtimeException, d, d2, d3);
            } else {
                String string3 = (String)hashMap.get("zoom");
                bounds = OsmUrlToBounds.positionToBounds(OsmUrlToBounds.parseDouble(hashMap, "lat"), OsmUrlToBounds.parseDouble(hashMap, "lon"), string3 == null ? 18 : Integer.parseInt(string3));
            }
        }
        catch (ArrayIndexOutOfBoundsException | NullPointerException | NumberFormatException runtimeException) {
            Main.error(runtimeException);
        }
        return bounds;
    }

    private static Bounds parseHashURLs(String string) {
        double d;
        double d2;
        int n;
        String string2;
        String[] stringArray;
        int n2 = string.indexOf("#map=");
        if (n2 == -1) {
            return null;
        }
        int n3 = string.indexOf(38, n2);
        if (n3 == -1) {
            n3 = string.length();
        }
        if ((stringArray = (string2 = string.substring(n2 + 5, n3)).split("/")).length < 3) {
            Main.warn(I18n.tr("URL does not contain {0}/{1}/{2}", I18n.tr("zoom", new Object[0]), I18n.tr("latitude", new Object[0]), I18n.tr("longitude", new Object[0])));
            return null;
        }
        try {
            n = Integer.parseInt(stringArray[0]);
        }
        catch (NumberFormatException numberFormatException) {
            Main.warn(I18n.tr("URL does not contain valid {0}", I18n.tr("zoom", new Object[0])), numberFormatException);
            return null;
        }
        try {
            d2 = Double.parseDouble(stringArray[1]);
        }
        catch (NumberFormatException numberFormatException) {
            Main.warn(I18n.tr("URL does not contain valid {0}", I18n.tr("latitude", new Object[0])), numberFormatException);
            return null;
        }
        try {
            d = Double.parseDouble(stringArray[2]);
        }
        catch (NumberFormatException numberFormatException) {
            Main.warn(I18n.tr("URL does not contain valid {0}", I18n.tr("longitude", new Object[0])), numberFormatException);
            return null;
        }
        return OsmUrlToBounds.positionToBounds(d2, d, n);
    }

    private static double parseDouble(Map<String, String> map, String string) {
        if (map.containsKey(string)) {
            return Double.parseDouble(map.get(string));
        }
        return Double.parseDouble(map.get('m' + string));
    }

    private static Bounds parseShortLink(String string) {
        if (!string.startsWith(SHORTLINK_PREFIX)) {
            return null;
        }
        String string2 = string.substring(SHORTLINK_PREFIX.length());
        HashMap<Character, Integer> hashMap = new HashMap<Character, Integer>();
        for (int i = 0; i < SHORTLINK_CHARS.length; ++i) {
            hashMap.put(Character.valueOf(SHORTLINK_CHARS[i]), i);
        }
        long l = 0L;
        long l2 = 0L;
        int n = 0;
        int n2 = 0;
        for (char c : string2.toCharArray()) {
            if (hashMap.containsKey(Character.valueOf(c))) {
                int n3 = (Integer)hashMap.get(Character.valueOf(c));
                for (int i = 0; i < 3; ++i) {
                    l <<= 1;
                    if ((n3 & 0x20) != 0) {
                        l |= 1L;
                    }
                    l2 <<= 1;
                    if (((n3 <<= 1) & 0x20) != 0) {
                        l2 |= 1L;
                    }
                    n3 <<= 1;
                }
                n += 3;
                continue;
            }
            --n2;
        }
        return OsmUrlToBounds.positionToBounds((double)(l2 <<= 32 - n) * 180.0 / 4.294967296E9 - 90.0, (double)(l <<= 32 - n) * 360.0 / 4.294967296E9 - 180.0, n - 8 - n2 % 3 - 2);
    }

    public static Bounds positionToBounds(double d, double d2, int n) {
        int n2;
        int n3;
        int n4 = 256;
        try {
            n3 = Toolkit.getDefaultToolkit().getScreenSize().height;
            n2 = Toolkit.getDefaultToolkit().getScreenSize().width;
            if (Main.isDisplayingMapView()) {
                n3 = Main.map.mapView.getHeight();
                n2 = Main.map.mapView.getWidth();
            }
        }
        catch (HeadlessException headlessException) {
            n3 = 480;
            n2 = 640;
        }
        double d3 = (double)((1 << n) * n4) / 4.007501668557849E7;
        double d4 = (double)n2 / 2.0 / d3;
        double d5 = (double)n3 / 2.0 / d3;
        double d6 = Math.toRadians(d2) * 6378137.0;
        double d7 = OsmUrlToBounds.mercatorY(d);
        return new Bounds(OsmUrlToBounds.invMercatorY(d7 - d5), Math.toDegrees(d6 - d4) / 6378137.0, OsmUrlToBounds.invMercatorY(d7 + d5), Math.toDegrees(d6 + d4) / 6378137.0);
    }

    public static double mercatorY(double d) {
        return Math.log(Math.tan(0.7853981633974483 + Math.toRadians(d) / 2.0)) * 6378137.0;
    }

    public static double invMercatorY(double d) {
        return Math.toDegrees(Math.atan(Math.sinh(d / 6378137.0)));
    }

    public static Pair<Double, Double> getTileOfLatLon(double d, double d2, double d3) {
        double d4 = Math.floor((d2 + 180.0) / 360.0 * Math.pow(2.0, d3));
        double d5 = Math.floor((1.0 - Math.log(Math.tan(Math.toRadians(d)) + 1.0 / Math.cos(Math.toRadians(d))) / Math.PI) / 2.0 * Math.pow(2.0, d3));
        return new Pair<Double, Double>(d4, d5);
    }

    public static LatLon getLatLonOfTile(double d, double d2, double d3) {
        double d4 = d / Math.pow(2.0, d3) * 360.0 - 180.0;
        double d5 = Math.toDegrees(Math.atan(Math.sinh(Math.PI - Math.PI * 2 * d2 / Math.pow(2.0, d3))));
        return new LatLon(d5, d4);
    }

    public static int getZoom(Bounds bounds) {
        int n;
        double d = Math.log(Math.tan(0.7853981633974483 + bounds.getMinLat() / 180.0 * Math.PI / 2.0)) * 180.0 / Math.PI;
        double d2 = Math.log(Math.tan(0.7853981633974483 + bounds.getMaxLat() / 180.0 * Math.PI / 2.0)) * 180.0 / Math.PI;
        double d3 = Math.max(Math.abs(d2 - d), Math.abs(bounds.getMaxLon() - bounds.getMinLon()));
        for (n = 0; n <= 20 && !(d3 >= 180.0); d3 *= 2.0, ++n) {
        }
        return n;
    }

    public static String getURL(Bounds bounds) {
        return OsmUrlToBounds.getURL(bounds.getCenter(), OsmUrlToBounds.getZoom(bounds));
    }

    public static String getURL(LatLon latLon, int n) {
        return OsmUrlToBounds.getURL(latLon.lat(), latLon.lon(), n);
    }

    public static String getURL(double d, double d2, int n) {
        int n2 = (int)Math.pow(10.0, (double)n / 3.0);
        double d3 = Math.round(d * (double)n2);
        double d4 = Math.round(d2 * (double)n2);
        return Main.getOSMWebsite() + "/#map=" + n + '/' + (d3 /= (double)n2) + '/' + (d4 /= (double)n2);
    }
}

