/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.frame;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.FrameSlotKind;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public final class FrameDescriptor
implements Cloneable {
    private final Object defaultValue;
    private final ArrayList<FrameSlot> slots;
    private final HashMap<Object, FrameSlot> identifierToSlotMap;
    private Assumption version;
    private HashMap<Object, Assumption> identifierToNotInFrameAssumptionMap;

    public FrameDescriptor() {
        this(null);
    }

    public FrameDescriptor(Object defaultValue) {
        this.defaultValue = defaultValue;
        this.slots = new ArrayList();
        this.identifierToSlotMap = new HashMap();
        this.version = FrameDescriptor.createVersion();
    }

    public static FrameDescriptor create() {
        return new FrameDescriptor();
    }

    public static FrameDescriptor create(Object defaultValue) {
        return new FrameDescriptor(defaultValue);
    }

    public FrameSlot addFrameSlot(Object identifier) {
        return this.addFrameSlot(identifier, null, FrameSlotKind.Illegal);
    }

    public FrameSlot addFrameSlot(Object identifier, FrameSlotKind kind) {
        return this.addFrameSlot(identifier, null, kind);
    }

    public FrameSlot addFrameSlot(Object identifier, Object info, FrameSlotKind kind) {
        CompilerAsserts.neverPartOfCompilation("interpreter-only.  includes hashmap operations.");
        assert (!this.identifierToSlotMap.containsKey(identifier));
        FrameSlot slot = new FrameSlot(this, identifier, info, this.slots.size(), kind);
        this.slots.add(slot);
        this.identifierToSlotMap.put(identifier, slot);
        this.updateVersion();
        this.invalidateNotInFrameAssumption(identifier);
        return slot;
    }

    public FrameSlot findFrameSlot(Object identifier) {
        return this.identifierToSlotMap.get(identifier);
    }

    public FrameSlot findOrAddFrameSlot(Object identifier) {
        FrameSlot result = this.findFrameSlot(identifier);
        if (result != null) {
            return result;
        }
        return this.addFrameSlot(identifier);
    }

    public FrameSlot findOrAddFrameSlot(Object identifier, FrameSlotKind kind) {
        FrameSlot result = this.findFrameSlot(identifier);
        if (result != null) {
            return result;
        }
        return this.addFrameSlot(identifier, kind);
    }

    public FrameSlot findOrAddFrameSlot(Object identifier, Object info, FrameSlotKind kind) {
        FrameSlot result = this.findFrameSlot(identifier);
        if (result != null) {
            return result;
        }
        return this.addFrameSlot(identifier, info, kind);
    }

    public void removeFrameSlot(Object identifier) {
        CompilerAsserts.neverPartOfCompilation("interpreter-only.  includes hashmap operations.");
        assert (this.identifierToSlotMap.containsKey(identifier));
        this.slots.remove(this.identifierToSlotMap.get(identifier));
        this.identifierToSlotMap.remove(identifier);
        this.updateVersion();
        this.getNotInFrameAssumption(identifier);
    }

    public int getSize() {
        return this.slots.size();
    }

    public List<? extends FrameSlot> getSlots() {
        return Collections.unmodifiableList(this.slots);
    }

    public Set<Object> getIdentifiers() {
        return Collections.unmodifiableSet(this.identifierToSlotMap.keySet());
    }

    public FrameDescriptor copy() {
        FrameDescriptor clonedFrameDescriptor = new FrameDescriptor(this.defaultValue);
        int i = 0;
        while (i < this.getSlots().size()) {
            Object identifier = this.getSlots().get(i).getIdentifier();
            clonedFrameDescriptor.addFrameSlot(identifier);
            ++i;
        }
        return clonedFrameDescriptor;
    }

    public FrameDescriptor shallowCopy() {
        FrameDescriptor clonedFrameDescriptor = new FrameDescriptor(this.defaultValue);
        clonedFrameDescriptor.slots.addAll(this.slots);
        clonedFrameDescriptor.identifierToSlotMap.putAll(this.identifierToSlotMap);
        return clonedFrameDescriptor;
    }

    void updateVersion() {
        this.version.invalidate();
        this.version = FrameDescriptor.createVersion();
    }

    public Assumption getVersion() {
        return this.version;
    }

    private static Assumption createVersion() {
        return Truffle.getRuntime().createAssumption("frame version");
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public Assumption getNotInFrameAssumption(Object identifier) {
        Assumption assumption;
        if (this.identifierToSlotMap.containsKey(identifier)) {
            throw new IllegalArgumentException("Cannot get not-in-frame assumption for existing frame slot!");
        }
        if (this.identifierToNotInFrameAssumptionMap == null) {
            this.identifierToNotInFrameAssumptionMap = new HashMap();
        } else {
            assumption = this.identifierToNotInFrameAssumptionMap.get(identifier);
            if (assumption != null) {
                return assumption;
            }
        }
        assumption = Truffle.getRuntime().createAssumption("not in frame: " + identifier);
        this.identifierToNotInFrameAssumptionMap.put(identifier, assumption);
        return assumption;
    }

    private void invalidateNotInFrameAssumption(Object identifier) {
        Assumption assumption;
        if (this.identifierToNotInFrameAssumptionMap != null && (assumption = this.identifierToNotInFrameAssumptionMap.get(identifier)) != null) {
            assumption.invalidate();
            this.identifierToNotInFrameAssumptionMap.remove(identifier);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("FrameDescriptor@").append(Integer.toHexString(this.hashCode()));
        sb.append("{");
        boolean comma = false;
        for (FrameSlot slot : this.slots) {
            if (comma) {
                sb.append(", ");
            } else {
                comma = true;
            }
            sb.append(slot.getIndex()).append(":").append(slot.getIdentifier());
        }
        sb.append("}");
        return sb.toString();
    }
}

