/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.subsystems;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import jnr.ffi.Runtime;
import jnr.posix.DefaultNativeTimeval;
import jnr.posix.Timeval;
import org.jruby.RubyThread;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.core.FiberNodes;
import org.jruby.truffle.nodes.core.ThreadNodes;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.backtrace.BacktraceFormatter;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.layouts.Layouts;
import org.jruby.truffle.runtime.subsystems.SafepointAction;

public class ThreadManager {
    private final RubyContext context;
    private final DynamicObject rootThread;
    private final ThreadLocal<DynamicObject> currentThread = new ThreadLocal();
    private final Set<DynamicObject> runningRubyThreads = Collections.newSetFromMap(new ConcurrentHashMap());

    public ThreadManager(RubyContext context) {
        this.context = context;
        this.rootThread = ThreadNodes.createRubyThread(context, context.getCoreLibrary().getThreadClass());
        Layouts.THREAD.setNameUnsafe(this.rootThread, "main");
    }

    public void initialize() {
        ThreadNodes.start(this.context, this.rootThread);
        FiberNodes.start(this.context, Layouts.THREAD.getFiberManager(this.rootThread).getRootFiber());
    }

    public DynamicObject getRootThread() {
        return this.rootThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public <T> T runUntilResult(Node currentNode, BlockingAction<T> action) {
        T result = null;
        do {
            DynamicObject runningThread = this.getCurrentThread();
            Layouts.THREAD.setStatus(runningThread, RubyThread.Status.SLEEP);
            try {
                try {
                    result = action.block();
                }
                finally {
                    Layouts.THREAD.setStatus(runningThread, RubyThread.Status.RUN);
                }
            }
            catch (InterruptedException e) {
                this.context.getSafepointManager().pollFromBlockingCall(currentNode);
            }
        } while (result == null);
        return result;
    }

    @CompilerDirectives.TruffleBoundary
    public <T> T runUntilSuccessKeepRunStatus(Node currentNode, BlockingAction<T> action) {
        T result = null;
        do {
            try {
                result = action.block();
            }
            catch (InterruptedException e) {
                this.context.getSafepointManager().poll(currentNode);
            }
        } while (result == null);
        return result;
    }

    public <T> ResultOrTimeout<T> runUntilTimeout(Node currentNode, int timeoutMicros, final BlockingTimeoutAction<T> action) {
        DefaultNativeTimeval timeoutToUse = new DefaultNativeTimeval(Runtime.getSystemRuntime());
        if (timeoutMicros == 0) {
            timeoutToUse.setTime(new long[]{0L, 0L});
            return new ResultWithinTime<T>(this.runUntilResult(currentNode, new BlockingAction<T>((Timeval)timeoutToUse){
                final /* synthetic */ Timeval val$timeoutToUse;
                {
                    this.val$timeoutToUse = timeval;
                }

                @Override
                public T block() throws InterruptedException {
                    return action.block(this.val$timeoutToUse);
                }
            }));
        }
        int pollTime = 500000000;
        final long requestedTimeoutAt = System.nanoTime() + (long)timeoutMicros * 1000L;
        return (ResultOrTimeout)this.runUntilResult(currentNode, new BlockingAction<ResultOrTimeout<T>>((Timeval)timeoutToUse, action){
            final /* synthetic */ Timeval val$timeoutToUse;
            final /* synthetic */ BlockingTimeoutAction val$action;
            {
                this.val$timeoutToUse = timeval;
                this.val$action = blockingTimeoutAction;
            }

            @Override
            public ResultOrTimeout<T> block() throws InterruptedException {
                long timeUntilRequestedTimeout = requestedTimeoutAt - System.nanoTime();
                if (timeUntilRequestedTimeout <= 0L) {
                    return new TimedOut();
                }
                boolean timeoutForPoll = 500000000L <= timeUntilRequestedTimeout;
                long effectiveTimeout = Math.min(500000000L, timeUntilRequestedTimeout);
                long effectiveTimeoutMicros = effectiveTimeout / 1000L;
                this.val$timeoutToUse.setTime(new long[]{effectiveTimeoutMicros / 1000000L, effectiveTimeoutMicros % 1000000L});
                Object result = this.val$action.block(this.val$timeoutToUse);
                if (result == null) {
                    if (timeoutForPoll && requestedTimeoutAt - System.nanoTime() > 0L) {
                        throw new InterruptedException();
                    }
                    return new TimedOut();
                }
                return new ResultWithinTime(result);
            }
        });
    }

    public void initializeCurrentThread(DynamicObject thread) {
        assert (RubyGuards.isRubyThread(thread));
        this.currentThread.set(thread);
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject getCurrentThread() {
        return this.currentThread.get();
    }

    public synchronized void registerThread(DynamicObject thread) {
        assert (RubyGuards.isRubyThread(thread));
        this.initializeCurrentThread(thread);
        this.runningRubyThreads.add(thread);
    }

    public synchronized void unregisterThread(DynamicObject thread) {
        assert (RubyGuards.isRubyThread(thread));
        this.runningRubyThreads.remove(thread);
        this.currentThread.set(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public void shutdown() {
        try {
            if (this.runningRubyThreads.size() > 1) {
                this.killOtherThreads();
            }
        }
        finally {
            Layouts.THREAD.getFiberManager(this.rootThread).shutdown();
            FiberNodes.cleanup(this.context, Layouts.THREAD.getFiberManager(this.rootThread).getRootFiber());
            ThreadNodes.cleanup(this.context, this.rootThread);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject[] getThreads() {
        return this.runningRubyThreads.toArray(new DynamicObject[this.runningRubyThreads.size()]);
    }

    @CompilerDirectives.TruffleBoundary
    private void killOtherThreads() {
        while (true) {
            try {
                this.context.getSafepointManager().pauseAllThreadsAndExecute(null, false, new SafepointAction(){

                    @Override
                    public synchronized void run(DynamicObject thread, Node currentNode) {
                        if (thread != ThreadManager.this.rootThread && Thread.currentThread() == Layouts.THREAD.getThread(thread)) {
                            ThreadNodes.shutdown(ThreadManager.this.context, thread, currentNode);
                        }
                    }
                });
            }
            catch (RaiseException e) {
                DynamicObject rubyException = e.getRubyException();
                BacktraceFormatter.createDefaultFormatter(this.context).printBacktrace(rubyException, Layouts.EXCEPTION.getBacktrace(rubyException));
                continue;
            }
            break;
        }
    }

    public static class TimedOut<T>
    implements ResultOrTimeout<T> {
    }

    public static class ResultWithinTime<T>
    implements ResultOrTimeout<T> {
        private final T value;

        public ResultWithinTime(T value) {
            this.value = value;
        }

        public T getValue() {
            return this.value;
        }
    }

    public static interface ResultOrTimeout<T> {
    }

    public static interface BlockingTimeoutAction<T> {
        public T block(Timeval var1) throws InterruptedException;
    }

    public static interface BlockingAction<T> {
        public static final boolean SUCCESS = true;

        public T block() throws InterruptedException;
    }
}

