/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.InvalidParameterException;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.httpclient.HttpException;
import org.apache.log4j.Logger;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.core.scanner.Alert;
import org.parosproxy.paros.core.scanner.HostProcess;
import org.parosproxy.paros.core.scanner.Kb;
import org.parosproxy.paros.core.scanner.Plugin;
import org.parosproxy.paros.extension.encoder.Encoder;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.control.AddOn;
import org.zaproxy.zap.extension.anticsrf.AntiCsrfToken;
import org.zaproxy.zap.extension.anticsrf.ExtensionAntiCSRF;
import org.zaproxy.zap.model.Tech;
import org.zaproxy.zap.model.TechSet;

public abstract class AbstractPlugin
implements Plugin,
Comparable<Object> {
    protected static final int PATTERN_PARAM = 10;
    protected static final String CRLF = "\r\n";
    private HostProcess parent = null;
    private HttpMessage msg = null;
    private boolean enabled = true;
    private Logger log = Logger.getLogger(this.getClass());
    private Configuration config = null;
    private int delayInMs;
    private ExtensionAntiCSRF extAntiCSRF = null;
    private Encoder encoder = new Encoder();
    private Plugin.AlertThreshold defaultAttackThreshold = Plugin.AlertThreshold.MEDIUM;
    private static final Plugin.AlertThreshold[] alertThresholdsSupported = new Plugin.AlertThreshold[]{Plugin.AlertThreshold.MEDIUM};
    private Plugin.AttackStrength defaultAttackStrength = Plugin.AttackStrength.MEDIUM;
    private static final Plugin.AttackStrength[] attackStrengthsSupported = new Plugin.AttackStrength[]{Plugin.AttackStrength.MEDIUM};
    private TechSet techSet = null;
    private Date started = null;
    private Date finished = null;
    private AddOn.Status status = AddOn.Status.unknown;

    @Override
    public abstract int getId();

    @Override
    public abstract String getName();

    @Override
    public String getCodeName() {
        String string = this.getClass().getName();
        int n = this.getClass().getName().lastIndexOf(".");
        if (n > -1) {
            string = string.substring(n + 1);
        }
        return string;
    }

    @Override
    public abstract String[] getDependency();

    @Override
    public abstract String getDescription();

    @Override
    public abstract int getCategory();

    @Override
    public abstract String getSolution();

    @Override
    public abstract String getReference();

    @Override
    public void init(HttpMessage httpMessage, HostProcess hostProcess) {
        this.msg = httpMessage.cloneAll();
        this.parent = hostProcess;
        if (this.parent.getScannerParam().isInjectPluginIdInHeader()) {
            this.msg.getRequestHeader().setHeader("X-ZAP-Scan-ID", Integer.toString(this.getId()));
        }
        this.init();
    }

    public abstract void init();

    protected HttpMessage getNewMsg() {
        return this.msg.cloneRequest();
    }

    protected HttpMessage getBaseMsg() {
        return this.msg;
    }

    protected void sendAndReceive(HttpMessage httpMessage) throws HttpException, IOException {
        this.sendAndReceive(httpMessage, true);
    }

    protected void sendAndReceive(HttpMessage httpMessage, boolean bl) throws HttpException, IOException {
        this.sendAndReceive(httpMessage, bl, true);
    }

    protected void sendAndReceive(HttpMessage httpMessage, boolean bl, boolean bl2) throws HttpException, IOException {
        if (this.parent.handleAntiCsrfTokens() && bl2) {
            if (this.extAntiCSRF == null) {
                this.extAntiCSRF = (ExtensionAntiCSRF)Control.getSingleton().getExtensionLoader().getExtension("ExtensionAntiCSRF");
            }
            if (this.extAntiCSRF != null) {
                List<AntiCsrfToken> list = this.extAntiCSRF.getTokens(httpMessage);
                AntiCsrfToken antiCsrfToken = null;
                if (list.size() > 0) {
                    antiCsrfToken = list.get(0);
                }
                if (antiCsrfToken != null) {
                    this.regenerateAntiCsrfToken(httpMessage, antiCsrfToken);
                }
            }
        }
        httpMessage.getRequestHeader().setHeader("If-Modified-Since", null);
        httpMessage.getRequestHeader().setHeader("If-None-Match", null);
        httpMessage.getRequestHeader().setContentLength(httpMessage.getRequestBody().length());
        if (this.getDelayInMs() > 0) {
            try {
                Thread.sleep(this.getDelayInMs());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.parent.performScannerHookBeforeScan(httpMessage, this);
        this.parent.getHttpSender().sendAndReceive(httpMessage, bl);
        this.parent.notifyNewMessage(httpMessage);
        this.parent.performScannerHookAfterScan(httpMessage, this);
    }

    private void regenerateAntiCsrfToken(HttpMessage httpMessage, AntiCsrfToken antiCsrfToken) {
        Object object;
        if (antiCsrfToken == null) {
            return;
        }
        String string = null;
        try {
            object = antiCsrfToken.getMsg().cloneAll();
            this.sendAndReceive((HttpMessage)object, true, false);
            string = this.extAntiCSRF.getTokenValue((HttpMessage)object, antiCsrfToken.getName());
        }
        catch (Exception exception) {
            this.log.error((Object)exception.getMessage(), (Throwable)exception);
        }
        if (string != null) {
            this.log.debug((Object)("regenerateAntiCsrfToken replacing " + antiCsrfToken.getValue() + " with " + this.encoder.getURLEncode(string)));
            object = httpMessage.getRequestBody().toString();
            object = ((String)object).replace(this.encoder.getURLEncode(antiCsrfToken.getValue()), this.encoder.getURLEncode(string));
            httpMessage.setRequestBody((String)object);
            this.extAntiCSRF.registerAntiCsrfToken(new AntiCsrfToken(httpMessage, antiCsrfToken.getName(), string, antiCsrfToken.getFormIndex()));
        }
    }

    @Override
    public void run() {
        try {
            if (!this.isStop()) {
                this.started = new Date();
                this.scan();
            }
        }
        catch (Exception exception) {
            this.getLog().error((Object)exception.getMessage(), (Throwable)exception);
        }
        this.notifyPluginCompleted(this.getParent());
        this.finished = new Date();
    }

    @Override
    public abstract void scan();

    protected void bingo(int n, int n2, String string, String string2, String string3, String string4, HttpMessage httpMessage) {
        this.bingo(n, n2, this.getName(), this.getDescription(), string, string2, string3, string4, this.getSolution(), httpMessage);
    }

    protected void bingo(int n, int n2, String string, String string2, String string3, String string4, String string5, String string6, String string7, HttpMessage httpMessage) {
        this.log.debug((Object)("New alert pluginid=" + this.getId() + " " + string + " uri=" + string3));
        Alert alert = new Alert(this.getId(), n, n2, string);
        if (string3 == null || string3.equals("")) {
            string3 = httpMessage.getRequestHeader().getURI().toString();
        }
        if (string4 == null) {
            string4 = "";
        }
        alert.setDetail(string2, string3, string4, string5, string6, string7, this.getReference(), "", this.getCweId(), this.getWascId(), httpMessage);
        this.parent.alertFound(alert);
    }

    protected void bingo(int n, int n2, String string, String string2, String string3, String string4, String string5, HttpMessage httpMessage) {
        this.bingo(n, n2, this.getName(), this.getDescription(), string, string2, string3, string4, this.getSolution(), string5, httpMessage);
    }

    protected void bingo(int n, int n2, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, HttpMessage httpMessage) {
        this.log.debug((Object)("New alert pluginid=" + this.getId() + " " + string + " uri=" + string3));
        Alert alert = new Alert(this.getId(), n, n2, string);
        if (string3 == null || string3.equals("")) {
            string3 = httpMessage.getRequestHeader().getURI().toString();
        }
        if (string4 == null) {
            string4 = "";
        }
        alert.setDetail(string2, string3, string4, string5, string6, string7, this.getReference(), string8, this.getCweId(), this.getWascId(), httpMessage);
        this.parent.alertFound(alert);
    }

    protected void bingo(int n, int n2, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, int n3, int n4, HttpMessage httpMessage) {
        this.log.debug((Object)("New alert pluginid=" + this.getId() + " " + string + " uri=" + string3));
        Alert alert = new Alert(this.getId(), n, n2, string);
        if (string3 == null || string3.equals("")) {
            string3 = httpMessage.getRequestHeader().getURI().toString();
        }
        if (string4 == null) {
            string4 = "";
        }
        alert.setDetail(string2, string3, string4, string5, string6, string7, this.getReference(), string8, n3, n4, httpMessage);
        this.parent.alertFound(alert);
    }

    protected boolean isFileExist(HttpMessage httpMessage) {
        return this.parent.getAnalyser().isFileExist(httpMessage);
    }

    protected boolean isStop() {
        return this.parent.isStop() || this.parent.isSkipped(this);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    public void setEnabled(boolean bl) {
        if (this.enabled != bl) {
            this.enabled = bl;
            this.setProperty("enabled", Boolean.toString(bl));
            if (bl && this.getAlertThreshold() == Plugin.AlertThreshold.OFF) {
                this.setAlertThreshold(Plugin.AlertThreshold.DEFAULT);
            }
        }
    }

    @Override
    public Plugin.AlertThreshold getAlertThreshold() {
        return this.getAlertThreshold(false);
    }

    @Override
    public Plugin.AlertThreshold getAlertThreshold(boolean bl) {
        Plugin.AlertThreshold alertThreshold = null;
        try {
            alertThreshold = Plugin.AlertThreshold.valueOf(this.getProperty("level"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (alertThreshold == null) {
            alertThreshold = this.isEnabled() ? (bl ? Plugin.AlertThreshold.DEFAULT : this.defaultAttackThreshold) : Plugin.AlertThreshold.OFF;
        } else if (alertThreshold.equals((Object)Plugin.AlertThreshold.DEFAULT)) {
            alertThreshold = bl ? Plugin.AlertThreshold.DEFAULT : this.defaultAttackThreshold;
        }
        return alertThreshold;
    }

    @Override
    public void setAlertThreshold(Plugin.AlertThreshold alertThreshold) {
        this.setProperty("level", alertThreshold.name());
        this.setEnabled(alertThreshold != Plugin.AlertThreshold.OFF);
    }

    @Override
    public void setDefaultAlertThreshold(Plugin.AlertThreshold alertThreshold) {
        this.defaultAttackThreshold = alertThreshold;
    }

    @Override
    public Plugin.AlertThreshold[] getAlertThresholdsSupported() {
        return alertThresholdsSupported;
    }

    @Override
    public Plugin.AttackStrength getAttackStrength(boolean bl) {
        Plugin.AttackStrength attackStrength = null;
        try {
            attackStrength = Plugin.AttackStrength.valueOf(this.getProperty("strength"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (attackStrength == null) {
            attackStrength = bl ? Plugin.AttackStrength.DEFAULT : this.defaultAttackStrength;
        } else if (attackStrength.equals((Object)Plugin.AttackStrength.DEFAULT)) {
            attackStrength = bl ? Plugin.AttackStrength.DEFAULT : this.defaultAttackStrength;
        }
        return attackStrength;
    }

    @Override
    public Plugin.AttackStrength getAttackStrength() {
        return this.getAttackStrength(false);
    }

    @Override
    public void setAttackStrength(Plugin.AttackStrength attackStrength) {
        this.setProperty("strength", attackStrength.name());
    }

    @Override
    public void setDefaultAttackStrength(Plugin.AttackStrength attackStrength) {
        this.defaultAttackStrength = attackStrength;
    }

    @Override
    public Plugin.AttackStrength[] getAttackStrengthsSupported() {
        return attackStrengthsSupported;
    }

    @Override
    public int compareTo(Object object) {
        int n = -1;
        if (object instanceof AbstractPlugin) {
            AbstractPlugin abstractPlugin = (AbstractPlugin)object;
            n = this.getId() < abstractPlugin.getId() ? -1 : (this.getId() > abstractPlugin.getId() ? 1 : 0);
        }
        return n;
    }

    public boolean equals(Object object) {
        return this.compareTo(object) == 0;
    }

    protected boolean matchHeaderPattern(HttpMessage httpMessage, String string, Pattern pattern) {
        if (httpMessage.getResponseHeader().isEmpty()) {
            return false;
        }
        String string2 = httpMessage.getResponseHeader().getHeader(string);
        if (string2 == null) {
            return false;
        }
        Matcher matcher = pattern.matcher(string2);
        return matcher.find();
    }

    protected boolean matchBodyPattern(HttpMessage httpMessage, Pattern pattern, StringBuilder stringBuilder) {
        Matcher matcher = pattern.matcher(httpMessage.getResponseBody().toString());
        boolean bl = matcher.find();
        if (bl && stringBuilder != null) {
            stringBuilder.append(matcher.group());
        }
        return bl;
    }

    protected void writeProgress(String string) {
    }

    public HostProcess getParent() {
        return this.parent;
    }

    @Override
    public abstract void notifyPluginCompleted(HostProcess var1);

    protected String stripOff(String string, String string2) {
        String string3 = AbstractPlugin.getURLEncode(string2);
        String string4 = AbstractPlugin.getURLDecode(string2);
        String string5 = AbstractPlugin.getHTMLEncode(string2);
        String string6 = AbstractPlugin.getHTMLEncode(string3);
        String string7 = AbstractPlugin.getHTMLEncode(string4);
        String string8 = string.replaceAll("\\Q" + string2 + "\\E", "").replaceAll("\\Q" + string3 + "\\E", "").replaceAll("\\Q" + string4 + "\\E", "");
        string8 = string8.replaceAll("\\Q" + string5 + "\\E", "").replaceAll("\\Q" + string6 + "\\E", "").replaceAll("\\Q" + string7 + "\\E", "");
        return string8;
    }

    public static String getURLEncode(String string) {
        String string2 = "";
        try {
            string2 = URLEncoder.encode(string, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        return string2;
    }

    public static String getURLDecode(String string) {
        String string2 = "";
        try {
            string2 = URLDecoder.decode(string, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        return string2;
    }

    public static String getHTMLEncode(String string) {
        String string2 = string.replaceAll("<", "&#60;");
        string2 = string2.replaceAll(">", "&#62;");
        return string2;
    }

    protected Kb getKb() {
        return this.getParent().getKb();
    }

    protected Logger getLog() {
        return this.log;
    }

    public String getProperty(String string) {
        return this.getProperty(this.config, string);
    }

    private String getProperty(Configuration configuration, String string) {
        return configuration.getString("plugins.p" + this.getId() + "." + string);
    }

    public void setProperty(String string, String string2) {
        this.setProperty(this.config, string, string2);
    }

    private void setProperty(Configuration configuration, String string, String string2) {
        configuration.setProperty("plugins.p" + this.getId() + "." + string, (Object)string2);
    }

    @Override
    public void setConfig(Configuration configuration) {
        this.config = configuration;
    }

    @Override
    public Configuration getConfig() {
        return this.config;
    }

    @Override
    public void saveTo(Configuration configuration) {
        this.setProperty(configuration, "enabled", this.getProperty("enabled"));
        this.setProperty(configuration, "level", this.getProperty("level"));
        this.setProperty(configuration, "strength", this.getProperty("strength"));
    }

    @Override
    public void loadFrom(Configuration configuration) {
        this.setProperty("enabled", this.getProperty(configuration, "enabled"));
        this.setProperty("level", this.getProperty(configuration, "level"));
        this.setProperty("strength", this.getProperty(configuration, "strength"));
    }

    @Override
    public void cloneInto(Plugin plugin) {
        if (!(plugin instanceof AbstractPlugin)) {
            throw new InvalidParameterException("Not an AbstractPlugin");
        }
        AbstractPlugin abstractPlugin = (AbstractPlugin)plugin;
        abstractPlugin.setEnabled(this.isEnabled());
        abstractPlugin.setAlertThreshold(this.getAlertThreshold(true));
        abstractPlugin.setAttackStrength(this.getAttackStrength(true));
        abstractPlugin.setDefaultAlertThreshold(this.defaultAttackThreshold);
        abstractPlugin.setDefaultAttackStrength(this.defaultAttackStrength);
        abstractPlugin.setTechSet(this.getTechSet());
        abstractPlugin.setStatus(this.getStatus());
        abstractPlugin.saveTo(plugin.getConfig());
    }

    @Override
    public void createParamIfNotExist() {
        if (this.getProperty("enabled") == null) {
            this.setEnabled(this.getAlertThreshold() != Plugin.AlertThreshold.OFF);
        }
    }

    @Override
    public boolean isDepreciated() {
        return false;
    }

    @Override
    public int getRisk() {
        return 2;
    }

    @Override
    public int getDelayInMs() {
        return this.delayInMs;
    }

    @Override
    public void setDelayInMs(int n) {
        this.delayInMs = n;
    }

    @Override
    public boolean inScope(Tech tech) {
        return this.techSet == null || this.techSet.includes(tech);
    }

    @Override
    public void setTechSet(TechSet techSet) {
        this.techSet = techSet;
    }

    public TechSet getTechSet() {
        return this.techSet;
    }

    @Override
    public boolean targets(TechSet techSet) {
        return true;
    }

    @Override
    public Date getTimeStarted() {
        return this.started;
    }

    @Override
    public Date getTimeFinished() {
        return this.finished;
    }

    @Override
    public void setTimeStarted() {
        this.started = new Date();
        this.finished = null;
    }

    @Override
    public void setTimeFinished() {
        this.finished = new Date();
    }

    @Override
    public int getCweId() {
        return 0;
    }

    @Override
    public int getWascId() {
        return 0;
    }

    @Override
    public AddOn.Status getStatus() {
        return this.status;
    }

    public void setStatus(AddOn.Status status) {
        this.status = status;
    }
}

