/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.db.paros;

import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.db.DbUtils;
import org.parosproxy.paros.db.RecordHistory;
import org.parosproxy.paros.db.TableHistory;
import org.parosproxy.paros.db.paros.ParosAbstractTable;
import org.parosproxy.paros.extension.option.DatabaseParam;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;

public class ParosTableHistory
extends ParosAbstractTable
implements TableHistory {
    private static final String TABLE_NAME = "HISTORY";
    private static final String HISTORYID = "HISTORYID";
    private static final String SESSIONID = "SESSIONID";
    private static final String HISTTYPE = "HISTTYPE";
    private static final String METHOD = "METHOD";
    private static final String URI = "URI";
    private static final String STATUSCODE = "STATUSCODE";
    private static final String TIMESENTMILLIS = "TIMESENTMILLIS";
    private static final String TIMEELAPSEDMILLIS = "TIMEELAPSEDMILLIS";
    private static final String REQHEADER = "REQHEADER";
    private static final String REQBODY = "REQBODY";
    private static final String RESHEADER = "RESHEADER";
    private static final String RESBODY = "RESBODY";
    private static final String TAG = "TAG";
    private static final String NOTE = "NOTE";
    private static final String RESPONSE_FROM_TARGET_HOST = "RESPONSEFROMTARGETHOST";
    private static Set<Integer> temporaryHistoryTypes = Collections.synchronizedSet(new HashSet());
    private PreparedStatement psRead = null;
    private PreparedStatement psInsert = null;
    private CallableStatement psGetIdLastInsert = null;
    private PreparedStatement psDelete = null;
    private PreparedStatement psDeleteTemp = null;
    private PreparedStatement psContainsURI = null;
    private PreparedStatement psUpdateNote = null;
    private int lastInsertedIndex;
    private static boolean isExistStatusCode = false;
    private static final Logger log = Logger.getLogger(ParosTableHistory.class);
    private boolean bodiesAsBytes;
    int configuredrequestbodysize = -1;
    int configuredresponsebodysize = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void reconnect(Connection connection) throws DatabaseException {
        try {
            DatabaseParam databaseParam = new DatabaseParam();
            databaseParam.load(Constant.getInstance().FILE_CONFIG);
            this.configuredrequestbodysize = databaseParam.getRequestBodySize();
            this.configuredresponsebodysize = databaseParam.getResponseBodySize();
            this.bodiesAsBytes = true;
            this.updateTable(connection);
            isExistStatusCode = DbUtils.hasColumn(connection, TABLE_NAME, STATUSCODE);
            this.psRead = connection.prepareStatement("SELECT TOP 1 * FROM HISTORY WHERE HISTORYID = ?");
            this.psDelete = connection.prepareStatement("DELETE FROM HISTORY WHERE HISTORYID = ?");
            this.psDeleteTemp = connection.prepareStatement("DELETE FROM HISTORY WHERE HISTTYPE IN ( UNNEST(?) )");
            this.psContainsURI = connection.prepareStatement("SELECT TOP 1 HISTORYID FROM HISTORY WHERE URI = ? AND  METHOD = ? AND REQBODY = ? AND SESSIONID = ? AND HISTTYPE = ?");
            this.psInsert = isExistStatusCode ? connection.prepareStatement("INSERT INTO HISTORY (SESSIONID,HISTTYPE,TIMESENTMILLIS,TIMEELAPSEDMILLIS,METHOD,URI,REQHEADER,REQBODY,RESHEADER,RESBODY,TAG, STATUSCODE,NOTE, RESPONSEFROMTARGETHOST) VALUES (?, ? ,?, ?, ?, ?, ?, ? ,? , ?, ?, ?, ?, ?)") : connection.prepareStatement("INSERT INTO HISTORY (SESSIONID,HISTTYPE,TIMESENTMILLIS,TIMEELAPSEDMILLIS,METHOD,URI,REQHEADER,REQBODY,RESHEADER,RESBODY,TAG,NOTE, RESPONSEFROMTARGETHOST) VALUES (?, ? ,?, ?, ?, ?, ?, ? ,? , ? , ?, ?, ?)");
            this.psGetIdLastInsert = connection.prepareCall("CALL IDENTITY();");
            this.psUpdateNote = connection.prepareStatement("UPDATE HISTORY SET NOTE = ? WHERE HISTORYID = ?");
            int n = 0;
            PreparedStatement preparedStatement = null;
            try {
                preparedStatement = connection.prepareStatement("SELECT TOP 1 HISTORYID FROM HISTORY ORDER BY HISTORYID DESC");
                try (ResultSet resultSet = preparedStatement.executeQuery();){
                    if (resultSet.next()) {
                        n = resultSet.getInt(1);
                    }
                }
            }
            finally {
                block24: {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (SQLException sQLException) {
                            if (!log.isDebugEnabled()) break block24;
                            log.debug((Object)sQLException.getMessage(), (Throwable)sQLException);
                        }
                    }
                }
            }
            this.lastInsertedIndex = n;
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
    }

    private void updateTable(Connection connection) throws DatabaseException {
        try {
            if (!DbUtils.hasColumn(connection, TABLE_NAME, TAG)) {
                DbUtils.executeAndClose(connection.prepareStatement("ALTER TABLE HISTORY ADD COLUMN TAG VARCHAR(32768) DEFAULT ''"));
            }
            if (!DbUtils.hasColumn(connection, TABLE_NAME, NOTE)) {
                DbUtils.executeAndClose(connection.prepareStatement("ALTER TABLE HISTORY ADD COLUMN NOTE VARCHAR(1048576) DEFAULT ''"));
            }
            if (DbUtils.getColumnType(connection, TABLE_NAME, REQBODY) != 61) {
                this.bodiesAsBytes = false;
            }
            if (!DbUtils.hasColumn(connection, TABLE_NAME, RESPONSE_FROM_TARGET_HOST)) {
                DbUtils.executeAndClose(connection.prepareStatement("ALTER TABLE HISTORY ADD COLUMN RESPONSEFROMTARGETHOST BOOLEAN DEFAULT FALSE"));
                DbUtils.executeUpdateAndClose(connection.prepareStatement("UPDATE HISTORY SET RESPONSEFROMTARGETHOST = TRUE "));
            }
            int n = DbUtils.getColumnSize(connection, TABLE_NAME, REQBODY);
            int n2 = DbUtils.getColumnSize(connection, TABLE_NAME, RESBODY);
            try {
                if (n != this.configuredrequestbodysize && this.configuredrequestbodysize > 0) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Extending table HISTORY request body length from " + n + " to " + this.configuredrequestbodysize));
                    }
                    DbUtils.executeAndClose(connection.prepareStatement("ALTER TABLE HISTORY ALTER COLUMN REQBODY VARBINARY(" + this.configuredrequestbodysize + ")"));
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Completed extending table HISTORY request body length from " + n + " to " + this.configuredrequestbodysize));
                    }
                }
                if (n2 != this.configuredresponsebodysize && this.configuredresponsebodysize > 0) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Extending table HISTORY response body length from " + n2 + " to " + this.configuredresponsebodysize));
                    }
                    DbUtils.executeAndClose(connection.prepareStatement("ALTER TABLE HISTORY ALTER COLUMN RESBODY VARBINARY(" + this.configuredresponsebodysize + ")"));
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Completed extending table HISTORY response body length from " + n2 + " to " + this.configuredresponsebodysize));
                    }
                }
            }
            catch (SQLException sQLException) {
                log.error((Object)"An error occurred while modifying a column length on HISTORY");
                log.error((Object)("The 'Maximum Request Body Size' value in the Database Options needs to be set to at least " + n + " to avoid this error"));
                log.error((Object)("The 'Maximum Response Body Size' value in the Database Options needs to be set to at least " + n2 + " to avoid this error"));
                log.error((Object)"The SQL Exception was:", (Throwable)sQLException);
                throw sQLException;
            }
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
    }

    @Override
    public synchronized RecordHistory read(int n) throws HttpMalformedHeaderException, DatabaseException {
        try {
            this.psRead.setInt(1, n);
            this.psRead.execute();
            RecordHistory recordHistory = null;
            try (ResultSet resultSet = this.psRead.getResultSet();){
                recordHistory = this.build(resultSet);
            }
            return recordHistory;
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
    }

    @Override
    public synchronized RecordHistory write(long l, int n, HttpMessage httpMessage) throws HttpMalformedHeaderException, DatabaseException {
        try {
            String string = "";
            byte[] byArray = new byte[]{};
            String string2 = "";
            byte[] byArray2 = byArray;
            String string3 = "";
            String string4 = "";
            int n2 = 0;
            String string5 = httpMessage.getNote();
            if (!httpMessage.getRequestHeader().isEmpty()) {
                string = httpMessage.getRequestHeader().toString();
                byArray = httpMessage.getRequestBody().getBytes();
                string3 = httpMessage.getRequestHeader().getMethod();
                string4 = httpMessage.getRequestHeader().getURI().toString();
            }
            if (!httpMessage.getResponseHeader().isEmpty()) {
                string2 = httpMessage.getResponseHeader().toString();
                byArray2 = httpMessage.getResponseBody().getBytes();
                n2 = httpMessage.getResponseHeader().getStatusCode();
            }
            return this.write(l, n, httpMessage.getTimeSentMillis(), httpMessage.getTimeElapsedMillis(), string3, string4, n2, string, byArray, string2, byArray2, null, string5, httpMessage.isResponseFromTargetHost());
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
    }

    private synchronized RecordHistory write(long l, int n, long l2, int n2, String string, String string2, int n3, String string3, byte[] byArray, String string4, byte[] byArray2, String string5, String string6, boolean bl) throws HttpMalformedHeaderException, SQLException, DatabaseException {
        if (byArray.length > this.configuredrequestbodysize) {
            throw new SQLException("The actual Request Body length " + byArray.length + " is greater than the configured request body length " + this.configuredrequestbodysize);
        }
        if (byArray2.length > this.configuredresponsebodysize) {
            throw new SQLException("The actual Response Body length " + byArray2.length + " is greater than the configured response body length " + this.configuredresponsebodysize);
        }
        this.psInsert.setLong(1, l);
        this.psInsert.setInt(2, n);
        this.psInsert.setLong(3, l2);
        this.psInsert.setInt(4, n2);
        this.psInsert.setString(5, string);
        this.psInsert.setString(6, string2);
        this.psInsert.setString(7, string3);
        if (this.bodiesAsBytes) {
            this.psInsert.setBytes(8, byArray);
        } else {
            this.psInsert.setString(8, new String(byArray, StandardCharsets.US_ASCII));
        }
        this.psInsert.setString(9, string4);
        if (this.bodiesAsBytes) {
            this.psInsert.setBytes(10, byArray2);
        } else {
            this.psInsert.setString(10, new String(byArray2, StandardCharsets.US_ASCII));
        }
        this.psInsert.setString(11, string5);
        int n4 = 12;
        if (isExistStatusCode) {
            this.psInsert.setInt(n4, n3);
            ++n4;
        }
        this.psInsert.setString(n4, string6);
        this.psInsert.setBoolean(++n4, bl);
        this.psInsert.executeUpdate();
        try (ResultSet resultSet = this.psGetIdLastInsert.executeQuery();){
            int n5;
            resultSet.next();
            this.lastInsertedIndex = n5 = resultSet.getInt(1);
            RecordHistory recordHistory = this.read(n5);
            return recordHistory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RecordHistory build(ResultSet resultSet) throws HttpMalformedHeaderException, SQLException {
        RecordHistory recordHistory = null;
        try {
            if (resultSet.next()) {
                byte[] byArray;
                byte[] byArray2;
                if (this.bodiesAsBytes) {
                    byArray2 = resultSet.getBytes(REQBODY);
                    byArray = resultSet.getBytes(RESBODY);
                } else {
                    byArray2 = resultSet.getString(REQBODY).getBytes();
                    byArray = resultSet.getString(RESBODY).getBytes();
                }
                recordHistory = new RecordHistory(resultSet.getInt(HISTORYID), resultSet.getInt(HISTTYPE), resultSet.getLong(SESSIONID), resultSet.getLong(TIMESENTMILLIS), resultSet.getInt(TIMEELAPSEDMILLIS), resultSet.getString(REQHEADER), byArray2, resultSet.getString(RESHEADER), byArray, resultSet.getString(TAG), resultSet.getString(NOTE), resultSet.getBoolean(RESPONSE_FROM_TARGET_HOST));
            }
        }
        finally {
            resultSet.close();
        }
        return recordHistory;
    }

    @Override
    public List<Integer> getHistoryIds(long l) throws DatabaseException {
        return this.getHistoryIdsOfHistType(l, null);
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<Integer> getHistoryIdsOfHistType(long var1_1, int ... var3_2) throws DatabaseException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<Integer> getHistoryIdsExceptOfHistType(long var1_1, int ... var3_2) throws DatabaseException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Deprecated
    public Vector<Integer> getHistoryList(long l, int n) throws DatabaseException {
        return new Vector<Integer>(this.getHistoryIdsOfHistType(l, n));
    }

    @Deprecated
    public Vector<Integer> getHistoryList(long l) throws DatabaseException {
        return new Vector<Integer>(this.getHistoryIds(l));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Integer> getHistoryList(long l, int n, String string, boolean bl) throws DatabaseException {
        try {
            PreparedStatement preparedStatement = this.getConnection().prepareStatement("SELECT * FROM HISTORY WHERE SESSIONID = ? AND HISTTYPE = ? ORDER BY HISTORYID");
            ResultSet resultSet = null;
            Vector<Integer> vector = new Vector<Integer>();
            try {
                Pattern pattern = Pattern.compile(string, 10);
                Matcher matcher = null;
                preparedStatement.setLong(1, l);
                preparedStatement.setInt(2, n);
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    if (bl) {
                        matcher = pattern.matcher(resultSet.getString(REQHEADER));
                        if (matcher.find()) {
                            vector.add(resultSet.getInt(HISTORYID));
                            continue;
                        }
                        matcher = pattern.matcher(resultSet.getString(REQBODY));
                        if (!matcher.find()) continue;
                        vector.add(resultSet.getInt(HISTORYID));
                        continue;
                    }
                    matcher = pattern.matcher(resultSet.getString(RESHEADER));
                    if (matcher.find()) {
                        vector.add(resultSet.getInt(HISTORYID));
                        continue;
                    }
                    matcher = pattern.matcher(resultSet.getString(RESBODY));
                    if (!matcher.find()) continue;
                    vector.add(resultSet.getInt(HISTORYID));
                }
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {}
                }
                preparedStatement.close();
            }
            return vector;
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
    }

    @Override
    public void deleteHistorySession(long l) throws DatabaseException {
        try (Statement statement = this.getConnection().createStatement();){
            statement.executeUpdate("DELETE FROM HISTORY WHERE SESSIONID = " + l);
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
    }

    @Override
    public void deleteHistoryType(long l, int n) throws DatabaseException {
        try (Statement statement = this.getConnection().createStatement();){
            statement.executeUpdate("DELETE FROM HISTORY WHERE SESSIONID = " + l + " AND " + HISTTYPE + " = " + n);
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
    }

    @Override
    public synchronized void delete(int n) throws DatabaseException {
        try {
            this.psDelete.setInt(1, n);
            this.psDelete.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
    }

    @Override
    public void delete(List<Integer> list) throws DatabaseException {
        this.delete(list, 1000);
    }

    @Override
    public synchronized void delete(List<Integer> list, int n) throws DatabaseException {
        try {
            if (list == null) {
                throw new IllegalArgumentException("Parameter ids must not be null.");
            }
            if (n <= 0) {
                throw new IllegalArgumentException("Parameter batchSize must be greater than zero.");
            }
            int n2 = 0;
            for (Integer n3 : list) {
                this.psDelete.setInt(1, n3);
                this.psDelete.addBatch();
                if (++n2 % n != 0) continue;
                this.psDelete.executeBatch();
                n2 = 0;
            }
            if (n2 % n != 0) {
                this.psDelete.executeBatch();
            }
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
    }

    public static void setHistoryTypeAsTemporary(int n) {
        temporaryHistoryTypes.add(n);
    }

    public static void unsetHistoryTypeAsTemporary(int n) {
        if (0 == n) {
            return;
        }
        temporaryHistoryTypes.remove(n);
    }

    @Override
    public void deleteTemporary() throws DatabaseException {
        try {
            Integer[] integerArray = new Integer[temporaryHistoryTypes.size()];
            integerArray = temporaryHistoryTypes.toArray(integerArray);
            Array array = this.getConnection().createArrayOf("INTEGER", ArrayUtils.toObject((int[])ArrayUtils.toPrimitive((Integer[])integerArray)));
            this.psDeleteTemp.setArray(1, array);
            this.psDeleteTemp.execute();
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized boolean containsURI(long l, int n, String string, String string2, byte[] byArray) throws DatabaseException {
        try {
            this.psContainsURI.setString(1, string2);
            this.psContainsURI.setString(2, string);
            if (this.bodiesAsBytes) {
                this.psContainsURI.setBytes(3, byArray);
            } else {
                this.psContainsURI.setString(3, new String(byArray));
            }
            this.psContainsURI.setLong(4, l);
            this.psContainsURI.setInt(5, n);
            try (ResultSet resultSet = this.psContainsURI.executeQuery();){
                if (!resultSet.next()) return false;
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public RecordHistory getHistoryCache(HistoryReference historyReference, HttpMessage httpMessage) throws DatabaseException, HttpMalformedHeaderException {
        try {
            PreparedStatement preparedStatement = null;
            preparedStatement = isExistStatusCode ? this.getConnection().prepareStatement("SELECT TOP 1 * FROM HISTORY WHERE URI = ? AND METHOD = ? AND REQBODY = ? AND HISTORYID >= ? AND HISTORYID <= ? AND SESSIONID = ? AND STATUSCODE != 304") : this.getConnection().prepareStatement("SELECT * FROM HISTORY WHERE URI = ? AND METHOD = ? AND REQBODY = ? AND HISTORYID >= ? AND HISTORYID <= ? AND SESSIONID = ?)");
            preparedStatement.setString(1, httpMessage.getRequestHeader().getURI().toString());
            preparedStatement.setString(2, httpMessage.getRequestHeader().getMethod());
            if (this.bodiesAsBytes) {
                preparedStatement.setBytes(3, httpMessage.getRequestBody().getBytes());
            } else {
                preparedStatement.setString(3, new String(httpMessage.getRequestBody().getBytes()));
            }
            preparedStatement.setInt(4, historyReference.getHistoryId());
            preparedStatement.setInt(5, historyReference.getHistoryId() + 200);
            preparedStatement.setLong(6, historyReference.getSessionId());
            ResultSet resultSet = preparedStatement.executeQuery();
            RecordHistory recordHistory = null;
            try {
                do {
                    if ((recordHistory = this.build(resultSet)) == null || !recordHistory.getHttpMessage().equals(httpMessage) || recordHistory.getHttpMessage().getResponseHeader().getStatusCode() == 304) continue;
                    RecordHistory recordHistory2 = recordHistory;
                    return recordHistory2;
                } while (recordHistory != null);
            }
            finally {
                try {
                    resultSet.close();
                    preparedStatement.close();
                }
                catch (Exception exception) {
                    log.warn((Object)exception.getMessage(), (Throwable)exception);
                }
            }
            preparedStatement = isExistStatusCode ? this.getConnection().prepareStatement("SELECT TOP 1 * FROM HISTORY WHERE URI = ? AND METHOD = ? AND REQBODY = ? AND SESSIONID = ? AND STATUSCODE != 304") : this.getConnection().prepareStatement("SELECT * FROM HISTORY WHERE URI = ? AND METHOD = ? AND REQBODY = ? AND SESSIONID = ?");
            preparedStatement.setString(1, httpMessage.getRequestHeader().getURI().toString());
            preparedStatement.setString(2, httpMessage.getRequestHeader().getMethod());
            if (this.bodiesAsBytes) {
                preparedStatement.setBytes(3, httpMessage.getRequestBody().getBytes());
            } else {
                preparedStatement.setString(3, new String(httpMessage.getRequestBody().getBytes()));
            }
            preparedStatement.setLong(4, historyReference.getSessionId());
            resultSet = preparedStatement.executeQuery();
            recordHistory = null;
            try {
                do {
                    if ((recordHistory = this.build(resultSet)) == null || !recordHistory.getHttpMessage().equals(httpMessage) || recordHistory.getHttpMessage().getResponseHeader().getStatusCode() == 304) continue;
                    RecordHistory recordHistory3 = recordHistory;
                    return recordHistory3;
                } while (recordHistory != null);
                return null;
            }
            finally {
                try {
                    resultSet.close();
                    preparedStatement.close();
                }
                catch (Exception exception) {
                    log.warn((Object)exception.getMessage(), (Throwable)exception);
                }
            }
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
    }

    @Override
    public synchronized void updateNote(int n, String string) throws DatabaseException {
        try {
            this.psUpdateNote.setString(1, string);
            this.psUpdateNote.setInt(2, n);
            this.psUpdateNote.execute();
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
    }

    @Override
    public int lastIndex() {
        return this.lastInsertedIndex;
    }

    static {
        temporaryHistoryTypes.add(0);
    }
}

