/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.apache.lucene.search.Query;
import org.elasticsearch.Version;
import org.elasticsearch.common.geo.GeoDistance;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.geo.GeoUtils;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.fielddata.IndexGeoPointFieldData;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.geo.GeoPointFieldMapper;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.search.geo.GeoDistanceRangeQuery;

public class GeoDistanceQueryParser
implements QueryParser {
    public static final String NAME = "geo_distance";

    @Inject
    public GeoDistanceQueryParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME, "geoDistance"};
    }

    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        String queryName = null;
        String currentFieldName = null;
        GeoPoint point = new GeoPoint();
        String fieldName = null;
        double distance = 0.0;
        Object vDistance = null;
        DistanceUnit unit = DistanceUnit.DEFAULT;
        GeoDistance geoDistance = GeoDistance.DEFAULT;
        String optimizeBbox = "memory";
        boolean indexCreatedBeforeV2_0 = parseContext.indexVersionCreated().before(Version.V_2_0_0);
        boolean coerce = false;
        boolean ignoreMalformed = false;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (parseContext.isDeprecatedSetting(currentFieldName)) continue;
            if (token == XContentParser.Token.START_ARRAY) {
                fieldName = currentFieldName;
                GeoUtils.parseGeoPoint(parser, point);
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                String currentName = parser.currentName();
                fieldName = currentFieldName;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        currentName = parser.currentName();
                        continue;
                    }
                    if (!token.isValue()) continue;
                    if (currentName.equals("lat")) {
                        point.resetLat(parser.doubleValue());
                        continue;
                    }
                    if (currentName.equals("lon")) {
                        point.resetLon(parser.doubleValue());
                        continue;
                    }
                    if (currentName.equals("geohash")) {
                        point.resetFromGeoHash(parser.text());
                        continue;
                    }
                    throw new QueryParsingException(parseContext, "[geo_distance] query does not support [" + currentFieldName + "]", new Object[0]);
                }
                continue;
            }
            if (!token.isValue()) continue;
            if (currentFieldName.equals("distance")) {
                if (token == XContentParser.Token.VALUE_STRING) {
                    vDistance = parser.text();
                    continue;
                }
                vDistance = parser.numberValue();
                continue;
            }
            if (currentFieldName.equals("unit")) {
                unit = DistanceUnit.fromString(parser.text());
                continue;
            }
            if (currentFieldName.equals("distance_type") || currentFieldName.equals("distanceType")) {
                geoDistance = GeoDistance.fromString(parser.text());
                continue;
            }
            if (currentFieldName.endsWith(".lat")) {
                point.resetLat(parser.doubleValue());
                fieldName = currentFieldName.substring(0, currentFieldName.length() - ".lat".length());
                continue;
            }
            if (currentFieldName.endsWith(".lon")) {
                point.resetLon(parser.doubleValue());
                fieldName = currentFieldName.substring(0, currentFieldName.length() - ".lon".length());
                continue;
            }
            if (currentFieldName.endsWith(".geohash")) {
                point.resetFromGeoHash(parser.text());
                fieldName = currentFieldName.substring(0, currentFieldName.length() - ".geohash".length());
                continue;
            }
            if ("_name".equals(currentFieldName)) {
                queryName = parser.text();
                continue;
            }
            if ("optimize_bbox".equals(currentFieldName) || "optimizeBbox".equals(currentFieldName)) {
                optimizeBbox = parser.textOrNull();
                continue;
            }
            if ("coerce".equals(currentFieldName) || indexCreatedBeforeV2_0 && "normalize".equals(currentFieldName)) {
                coerce = parser.booleanValue();
                if (!coerce) continue;
                ignoreMalformed = true;
                continue;
            }
            if ("ignore_malformed".equals(currentFieldName) && !coerce) {
                ignoreMalformed = parser.booleanValue();
                continue;
            }
            point.resetFromString(parser.text());
            fieldName = currentFieldName;
        }
        if (!indexCreatedBeforeV2_0 && !ignoreMalformed) {
            if (point.lat() > 90.0 || point.lat() < -90.0) {
                throw new QueryParsingException(parseContext, "illegal latitude value [{}] for [{}]", point.lat(), NAME);
            }
            if (point.lon() > 180.0 || point.lon() < -180.0) {
                throw new QueryParsingException(parseContext, "illegal longitude value [{}] for [{}]", point.lon(), NAME);
            }
        }
        if (coerce) {
            GeoUtils.normalizePoint(point, coerce, coerce);
        }
        if (vDistance == null) {
            throw new QueryParsingException(parseContext, "geo_distance requires 'distance' to be specified", new Object[0]);
        }
        distance = vDistance instanceof Number ? DistanceUnit.DEFAULT.convert(((Number)vDistance).doubleValue(), unit) : DistanceUnit.parse((String)vDistance, unit, DistanceUnit.DEFAULT);
        distance = geoDistance.normalize(distance, DistanceUnit.DEFAULT);
        MappedFieldType fieldType = parseContext.fieldMapper(fieldName);
        if (fieldType == null) {
            throw new QueryParsingException(parseContext, "failed to find geo_point field [" + fieldName + "]", new Object[0]);
        }
        if (!(fieldType instanceof GeoPointFieldMapper.GeoPointFieldType)) {
            throw new QueryParsingException(parseContext, "field [" + fieldName + "] is not a geo_point field", new Object[0]);
        }
        GeoPointFieldMapper.GeoPointFieldType geoFieldType = (GeoPointFieldMapper.GeoPointFieldType)fieldType;
        IndexGeoPointFieldData indexFieldData = (IndexGeoPointFieldData)parseContext.getForField(fieldType);
        GeoDistanceRangeQuery query = new GeoDistanceRangeQuery(point, null, distance, true, false, geoDistance, geoFieldType, indexFieldData, optimizeBbox);
        if (queryName != null) {
            parseContext.addNamedQuery(queryName, query);
        }
        return query;
    }
}

