/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl;

import com.jogamp.common.util.IntIntHashMap;
import java.nio.IntBuffer;
import java.util.ArrayList;
import javax.media.opengl.GLException;

public class GLStateTracker {
    public static final int MIN_CLIENT_ATTRIB_STACK_DEPTH = 16;
    static final int PIXEL_STATE_MAP_SIZE = 16;
    static final int PIXEL_STATE_MAP_CAPACITY = 32;
    private volatile boolean enabled = true;
    private IntIntHashMap pixelStateMap = new IntIntHashMap(32, 0.75f);
    private final ArrayList<SavedState> stack;

    public GLStateTracker() {
        this.pixelStateMap.setKeyNotFoundValue(-1);
        this.resetStates();
        this.stack = new ArrayList(16);
    }

    public final void clearStates() {
        this.pixelStateMap.clear();
    }

    public final void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public final boolean isEnabled() {
        return this.enabled;
    }

    public final boolean getInt(int n, int[] nArray, int n2) {
        int n3;
        if (this.enabled && -1 != (n3 = this.pixelStateMap.get(n))) {
            nArray[n2] = n3;
            return true;
        }
        return false;
    }

    public final boolean getInt(int n, IntBuffer intBuffer, int n2) {
        int n3;
        if (this.enabled && -1 != (n3 = this.pixelStateMap.get(n))) {
            intBuffer.put(intBuffer.position(), n3);
            return true;
        }
        return false;
    }

    public final void setInt(int n, int n2) {
        if (this.enabled) {
            this.pixelStateMap.put(n, n2);
        }
    }

    public final void pushAttrib(int n) {
        if (this.enabled) {
            SavedState savedState = new SavedState();
            if (0 != (n & 1)) {
                savedState.setPixelStateMap(this.pixelStateMap);
            }
            this.stack.add(this.stack.size(), savedState);
        }
    }

    public final void popAttrib() {
        if (this.enabled) {
            if (this.stack.isEmpty()) {
                throw new GLException("stack contains no elements");
            }
            SavedState savedState = this.stack.remove(this.stack.size() - 1);
            if (null == savedState) {
                throw new GLException("null stack element (remaining stack size " + this.stack.size() + ")");
            }
            if (null != savedState.getPixelStateMap()) {
                this.pixelStateMap = savedState.getPixelStateMap();
            }
        }
    }

    private final void resetStates() {
        this.pixelStateMap.clear();
        this.pixelStateMap.put(3333, 4);
        this.pixelStateMap.put(3328, 0);
        this.pixelStateMap.put(3329, 0);
        this.pixelStateMap.put(3330, 0);
        this.pixelStateMap.put(3331, 0);
        this.pixelStateMap.put(3332, 0);
        this.pixelStateMap.put(32876, 0);
        this.pixelStateMap.put(32875, 0);
        this.pixelStateMap.put(3317, 4);
        this.pixelStateMap.put(3312, 0);
        this.pixelStateMap.put(3313, 0);
        this.pixelStateMap.put(3314, 0);
        this.pixelStateMap.put(3315, 0);
        this.pixelStateMap.put(3316, 0);
        this.pixelStateMap.put(32878, 0);
        this.pixelStateMap.put(32877, 0);
    }

    private static class SavedState {
        private IntIntHashMap pixelStateMap;

        private SavedState() {
        }

        private final void setPixelStateMap(IntIntHashMap intIntHashMap) {
            this.pixelStateMap = (IntIntHashMap)intIntHashMap.clone();
        }

        private final IntIntHashMap getPixelStateMap() {
            return this.pixelStateMap;
        }
    }
}

