/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.glu.nurbs;

import jogamp.opengl.glu.nurbs.Arc;
import jogamp.opengl.glu.nurbs.ArcSdirSorter;
import jogamp.opengl.glu.nurbs.ArcTdirSorter;
import jogamp.opengl.glu.nurbs.ArcTesselator;
import jogamp.opengl.glu.nurbs.Backend;
import jogamp.opengl.glu.nurbs.Bin;
import jogamp.opengl.glu.nurbs.CArrayOfArcs;
import jogamp.opengl.glu.nurbs.Curvelist;
import jogamp.opengl.glu.nurbs.Flist;
import jogamp.opengl.glu.nurbs.Patchlist;
import jogamp.opengl.glu.nurbs.Quilt;
import jogamp.opengl.glu.nurbs.Renderhints;

public class Subdivider {
    public static final int CULL_TRIVIAL_REJECT = 0;
    public static final int CULL_ACCEPT = 1;
    private static final int MAXARCS = 10;
    Quilt qlist;
    private Renderhints renderhints;
    private Backend backend;
    private int subdivisions;
    private float domain_distance_u_rate;
    private int is_domain_distance_sampling;
    private Bin initialbin;
    private boolean showDegenerate;
    private boolean isArcTypeBezier;
    private Flist tpbrkpts;
    private Flist spbrkpts;
    private int s_index;
    private Arc pjarc;
    private ArcTesselator arctesselator;
    private int t_index;
    private Flist smbrkpts;
    private float[] stepsizes;
    private float domain_distance_v_rate;

    public void beginQuilts(Backend backend) {
        this.qlist = null;
        this.renderhints = new Renderhints();
        this.backend = backend;
        this.initialbin = new Bin();
        this.arctesselator = new ArcTesselator();
    }

    public void addQuilt(Quilt quilt) {
        if (this.qlist == null) {
            this.qlist = quilt;
        } else {
            quilt.next = this.qlist;
            this.qlist = quilt;
        }
    }

    public void endQuilts() {
    }

    public void drawSurfaces() {
        this.renderhints.init();
        if (this.qlist == null) {
            return;
        }
        Object object = this.qlist;
        while (object != null) {
            if (((Quilt)object).isCulled() == 0) {
                this.freejarcs(this.initialbin);
                return;
            }
            object = ((Quilt)object).next;
        }
        object = new float[2];
        float[] fArray = new float[2];
        this.spbrkpts = new Flist();
        this.tpbrkpts = new Flist();
        this.qlist.getRange((float[])object, fArray, this.spbrkpts, this.tpbrkpts);
        boolean bl = this.is_domain_distance_sampling > 0 && this.renderhints.display_method != 5;
        bl = true;
        if (!this.initialbin.isnonempty()) {
            if (!bl) {
                this.makeBorderTrim((float[])object, fArray);
            }
        } else {
            float[] fArray2 = new float[2];
            this.qlist.findRates(this.spbrkpts, this.tpbrkpts, fArray2);
        }
        this.backend.bgnsurf(this.renderhints.wiretris, this.renderhints.wirequads);
        if (!this.initialbin.isnonempty() && bl) {
            for (int i = this.spbrkpts.start; i < this.spbrkpts.end - 1; ++i) {
                for (int j = this.tpbrkpts.start; j < this.tpbrkpts.end - 1; ++j) {
                    float[] fArray3 = new float[2];
                    float[] fArray4 = new float[2];
                    fArray3[0] = this.spbrkpts.pts[i];
                    fArray4[0] = this.spbrkpts.pts[i + 1];
                    fArray3[1] = this.tpbrkpts.pts[j];
                    fArray4[1] = this.tpbrkpts.pts[j + 1];
                    this.qlist.downloadAll(fArray3, fArray4, this.backend);
                    int n = (int)(this.domain_distance_u_rate * (fArray4[0] - fArray3[0]));
                    int n2 = (int)(this.domain_distance_v_rate * (fArray4[1] - fArray3[1]));
                    if (n <= 0) {
                        n = 1;
                    }
                    if (n2 <= 0) {
                        n2 = 1;
                    }
                    this.backend.surfgrid(fArray3[0], fArray4[0], n, fArray4[1], fArray3[1], n2);
                    this.backend.surfmesh(0, 0, n, n2);
                }
            }
        } else {
            this.subdivideInS(this.initialbin);
        }
        this.backend.endsurf();
    }

    private void freejarcs(Bin bin) {
    }

    private void subdivideInS(Bin bin) {
        if (this.renderhints.display_method == 6) {
            this.outline(bin);
            this.freejarcs(bin);
        } else {
            this.setArcTypeBezier();
            this.setNonDegenerate();
            this.splitInS(bin, this.spbrkpts.start, this.spbrkpts.end);
        }
    }

    private void splitInS(Bin bin, int n, int n2) {
        if (bin.isnonempty()) {
            if (n != n2) {
                int n3 = n + (n2 - n) / 2;
                Bin bin2 = new Bin();
                Bin bin3 = new Bin();
                this.split(bin, bin2, bin3, 0, this.spbrkpts.pts[n3]);
                this.splitInS(bin2, n, n3);
                this.splitInS(bin3, n3 + 1, n2);
            } else if (n == this.spbrkpts.start || n == this.spbrkpts.end) {
                this.freejarcs(bin);
            } else if (this.renderhints.display_method == 7) {
                this.outline(bin);
                this.freejarcs(bin);
            } else {
                this.setArcTypeBezier();
                this.setNonDegenerate();
                this.s_index = n;
                this.splitInT(bin, this.tpbrkpts.start, this.tpbrkpts.end);
            }
        }
    }

    private void splitInT(Bin bin, int n, int n2) {
        if (bin.isnonempty()) {
            if (n != n2) {
                int n3 = n + (n2 - n) / 2;
                Bin bin2 = new Bin();
                Bin bin3 = new Bin();
                this.split(bin, bin2, bin3, 1, this.tpbrkpts.pts[n3 + 1]);
                this.splitInT(bin2, n, n3);
                this.splitInT(bin3, n3 + 1, n2);
            } else if (n == this.tpbrkpts.start || n == this.tpbrkpts.end) {
                this.freejarcs(bin);
            } else if (this.renderhints.display_method == 8) {
                this.outline(bin);
                this.freejarcs(bin);
            } else {
                this.t_index = n;
                this.setArcTypeBezier();
                this.setDegenerate();
                float[] fArray = new float[2];
                float[] fArray2 = new float[2];
                fArray[0] = this.spbrkpts.pts[this.s_index - 1];
                fArray[1] = this.tpbrkpts.pts[this.t_index - 1];
                fArray2[0] = this.spbrkpts.pts[this.s_index];
                fArray2[1] = this.tpbrkpts.pts[this.t_index];
                this.qlist.downloadAll(fArray, fArray2, this.backend);
                Patchlist patchlist = new Patchlist(this.qlist, fArray, fArray2);
                this.samplingSplit(bin, patchlist, this.renderhints.maxsubdivisions, 0);
                this.setNonDegenerate();
                this.setArcTypeBezier();
            }
        }
    }

    private void samplingSplit(Bin bin, Patchlist patchlist, int n, int n2) {
        if (!bin.isnonempty()) {
            return;
        }
        if (patchlist.cullCheck() == 0) {
            this.freejarcs(bin);
            return;
        }
        patchlist.getstepsize();
        if (this.renderhints.display_method == 5) {
            this.tesselation(bin, patchlist);
            this.outline(bin);
            this.freejarcs(bin);
            return;
        }
        this.tesselation(bin, patchlist);
        if (patchlist.needsSamplingSubdivision() && n > 0) {
            n2 = !patchlist.needsSubdivision(0) ? 1 : (patchlist.needsSubdivision(1) ? 0 : 1 - n2);
            Bin bin2 = new Bin();
            Bin bin3 = new Bin();
            float f = (float)((double)(patchlist.pspec[n2].range[0] + patchlist.pspec[n2].range[1]) * 0.5);
            this.split(bin, bin2, bin3, n2, f);
            Patchlist patchlist2 = new Patchlist(patchlist, n2, f);
            this.samplingSplit(bin2, patchlist2, n - 1, n2);
            this.samplingSplit(bin3, patchlist2, n - 1, n2);
        } else {
            this.setArcTypePwl();
            this.setDegenerate();
            this.nonSamplingSplit(bin, patchlist, n, n2);
            this.setDegenerate();
            this.setArcTypeBezier();
        }
    }

    private void nonSamplingSplit(Bin bin, Patchlist patchlist, int n, int n2) {
        if (patchlist.needsNonSamplingSubdivision() && n > 0) {
            n2 = 1 - n2;
            Bin bin2 = new Bin();
            Bin bin3 = new Bin();
            float f = (float)((double)(patchlist.pspec[n2].range[0] + patchlist.pspec[n2].range[1]) * 0.5);
            this.split(bin, bin2, bin3, n2, f);
            Patchlist patchlist2 = new Patchlist(patchlist, n2, f);
            if (bin2.isnonempty()) {
                if (patchlist2.cullCheck() == 0) {
                    this.freejarcs(bin2);
                } else {
                    this.nonSamplingSplit(bin2, patchlist2, n - 1, n2);
                }
            }
            if (bin3.isnonempty()) {
                if (patchlist.cullCheck() == 0) {
                    this.freejarcs(bin3);
                } else {
                    this.nonSamplingSplit(bin3, patchlist2, n - 1, n2);
                }
            }
        } else {
            patchlist.bbox();
            this.backend.patch(patchlist.pspec[0].range[0], patchlist.pspec[0].range[1], patchlist.pspec[1].range[0], patchlist.pspec[1].range[1]);
            if (this.renderhints.display_method == 9) {
                this.outline(bin);
                this.freejarcs(bin);
            } else {
                this.setArcTypePwl();
                this.setDegenerate();
                this.findIrregularS(bin);
                this.monosplitInS(bin, this.smbrkpts.start, this.smbrkpts.end);
            }
        }
    }

    private void monosplitInS(Bin bin, int n, int n2) {
    }

    private void findIrregularS(Bin bin) {
    }

    private void setArcTypePwl() {
    }

    private void tesselation(Bin bin, Patchlist patchlist) {
    }

    private void setDegenerate() {
    }

    private void split(Bin bin, Bin bin2, Bin bin3, int n, float f) {
        Bin bin4 = new Bin();
        Bin bin5 = new Bin();
        this.partition(bin, bin2, bin4, bin3, bin5, n, f);
        int n2 = bin4.numarcs();
        if (n2 % 2 == 0) {
            Arc arc;
            Arc[] arcArray = new Arc[10];
            CArrayOfArcs cArrayOfArcs = n2 >= 10 ? new CArrayOfArcs(new Arc[n2]) : new CArrayOfArcs(arcArray);
            CArrayOfArcs cArrayOfArcs2 = new CArrayOfArcs(cArrayOfArcs);
            while ((arc = bin4.removearc()) != null) {
                cArrayOfArcs2.set(arc);
                cArrayOfArcs2.pp();
            }
            if (n == 0) {
                ArcSdirSorter arcSdirSorter = new ArcSdirSorter(this);
                arcSdirSorter.qsort(cArrayOfArcs, n2);
                CArrayOfArcs cArrayOfArcs3 = new CArrayOfArcs(cArrayOfArcs);
                while (cArrayOfArcs3.getPointer() < cArrayOfArcs2.getPointer()) {
                    this.check_s(cArrayOfArcs3.get(), cArrayOfArcs3.getRelative(1));
                    cArrayOfArcs3.raisePointerBy(2);
                }
                cArrayOfArcs3 = new CArrayOfArcs(cArrayOfArcs);
                while (cArrayOfArcs3.getPointer() < cArrayOfArcs2.getPointer()) {
                    this.join_s(bin2, bin3, cArrayOfArcs3.get(), cArrayOfArcs3.getRelative(1));
                    cArrayOfArcs3.raisePointerBy(2);
                }
                cArrayOfArcs3 = new CArrayOfArcs(cArrayOfArcs);
                while (cArrayOfArcs3.getPointer() != cArrayOfArcs2.getPointer()) {
                    if (cArrayOfArcs3.get().head()[0] <= f && cArrayOfArcs3.get().tail()[0] <= f) {
                        bin2.addarc(cArrayOfArcs3.get());
                    } else {
                        bin3.addarc(cArrayOfArcs3.get());
                    }
                    cArrayOfArcs3.pp();
                }
            } else {
                ArcTdirSorter arcTdirSorter = new ArcTdirSorter(this);
                arcTdirSorter.qsort(cArrayOfArcs, n2);
                CArrayOfArcs cArrayOfArcs4 = new CArrayOfArcs(cArrayOfArcs);
                while (cArrayOfArcs4.getPointer() < cArrayOfArcs2.getPointer()) {
                    this.check_t(cArrayOfArcs4.get(), cArrayOfArcs4.getRelative(1));
                    cArrayOfArcs4.raisePointerBy(2);
                }
                cArrayOfArcs4 = new CArrayOfArcs(cArrayOfArcs);
                while (cArrayOfArcs4.getPointer() < cArrayOfArcs2.getPointer()) {
                    this.join_t(bin2, bin3, cArrayOfArcs4.get(), cArrayOfArcs4.getRelative(1));
                    cArrayOfArcs4.raisePointerBy(2);
                }
                cArrayOfArcs4 = new CArrayOfArcs(cArrayOfArcs);
                while (cArrayOfArcs4.getPointer() != cArrayOfArcs2.getPointer()) {
                    if (cArrayOfArcs4.get().head()[0] <= f && cArrayOfArcs4.get().tail()[0] <= f) {
                        bin2.addarc(cArrayOfArcs4.get());
                    } else {
                        bin3.addarc(cArrayOfArcs4.get());
                    }
                    cArrayOfArcs4.raisePointerBy(2);
                }
            }
            bin5.adopt();
        }
    }

    private void join_t(Bin bin, Bin bin2, Arc arc, Arc arc2) {
    }

    private void check_t(Arc arc, Arc arc2) {
    }

    private void join_s(Bin bin, Bin bin2, Arc arc, Arc arc2) {
        float f;
        if (!arc.getitail()) {
            arc = arc.next;
        }
        if (!arc2.getitail()) {
            arc2 = arc2.next;
        }
        float f2 = arc.tail()[0];
        float f3 = arc.tail()[1];
        if (f3 == (f = arc2.tail()[1])) {
            this.simplelink(arc, arc2);
        } else {
            Arc arc3 = new Arc(1);
            Arc arc4 = new Arc(3);
            if (this.isBezierArcType()) {
                this.arctesselator.bezier(arc3, f2, f2, f3, f);
                this.arctesselator.bezier(arc4, f2, f2, f, f3);
            } else {
                this.arctesselator.pwl_right(arc3, f2, f3, f, this.stepsizes[0]);
                this.arctesselator.pwl_left(arc3, f2, f, f3, this.stepsizes[2]);
            }
            this.link(arc, arc2, arc3, arc4);
            bin.addarc(arc3);
            bin2.addarc(arc4);
        }
    }

    private void link(Arc arc, Arc arc2, Arc arc3, Arc arc4) {
    }

    private boolean isBezierArcType() {
        return true;
    }

    private void simplelink(Arc arc, Arc arc2) {
    }

    private void check_s(Arc arc, Arc arc2) {
    }

    private void partition(Bin bin, Bin bin2, Bin bin3, Bin bin4, Bin bin5, int n, float f) {
        Bin bin6 = new Bin();
        Bin bin7 = new Bin();
        Bin bin8 = new Bin();
        Bin bin9 = new Bin();
        Arc arc = bin.removearc();
        while (arc != null) {
            float f2 = arc.tail()[n] - f;
            float f3 = arc.head()[n] - f;
            if (f2 > 0.0f) {
                if (f3 > 0.0f) {
                    bin4.addarc(arc);
                } else if (f3 == 0.0f) {
                    bin9.addarc(arc);
                } else {
                    switch (this.arc_split(arc, n, f, 0)) {
                        case 2: {
                            bin9.addarc(arc);
                            bin6.addarc(arc.next);
                            break;
                        }
                        default: {
                            System.out.println("TODO subdivider.partition rest cases");
                            break;
                        }
                    }
                }
            } else if (f2 == 0.0f) {
                if (f3 > 0.0f) {
                    bin7.addarc(arc);
                } else if (f3 == 0.0f) {
                    bin5.addarc(arc);
                } else {
                    bin7.addarc(arc);
                }
            } else if (!(f3 > 0.0f)) {
                if (f3 == 0.0f) {
                    bin8.addarc(arc);
                } else {
                    bin2.addarc(arc);
                }
            }
            arc = bin.removearc();
        }
        if (n == 0) {
            this.classify_headonleft_s(bin6, bin3, bin2, f);
            this.classify_tailonleft_s(bin8, bin3, bin2, f);
            this.classify_headonright_s(bin7, bin3, bin4, f);
            this.classify_tailonright_s(bin9, bin3, bin4, f);
        } else {
            this.classify_headonleft_t(bin6, bin3, bin2, f);
            this.classify_tailonleft_t(bin8, bin3, bin2, f);
            this.classify_headonright_t(bin7, bin3, bin4, f);
            this.classify_tailonright_t(bin9, bin3, bin4, f);
        }
    }

    private void classify_tailonright_t(Bin bin, Bin bin2, Bin bin3, float f) {
    }

    private void classify_tailonleft_s(Bin bin, Bin bin2, Bin bin3, float f) {
        Arc arc;
        while ((arc = bin.removearc()) != null) {
            arc.clearitail();
            float f2 = arc.next.head()[0] - f;
            if (f2 > 0.0f) {
                bin2.addarc(arc);
                continue;
            }
            if (f2 < 0.0f) {
                if (this.ccwTurn_sl(arc, arc.next)) {
                    bin3.addarc(arc);
                    continue;
                }
                bin2.addarc(arc);
                continue;
            }
            if (arc.next.tail()[1] > arc.next.head()[1]) {
                bin2.addarc(arc);
                continue;
            }
            bin3.addarc(arc);
        }
    }

    private void classify_headonright_s(Bin bin, Bin bin2, Bin bin3, float f) {
        Arc arc;
        while ((arc = bin.removearc()) != null) {
            arc.setitail();
            float f2 = arc.prev.tail()[0] - f;
            if (f2 > 0.0f) {
                if (this.ccwTurn_sr(arc.prev, arc)) {
                    bin3.addarc(arc);
                    continue;
                }
                bin2.addarc(arc);
                continue;
            }
            if (f2 < 0.0f) {
                bin3.addarc(arc);
                continue;
            }
            if (arc.prev.tail()[1] > arc.prev.head()[1]) {
                bin3.addarc(arc);
                continue;
            }
            bin2.addarc(arc);
        }
    }

    private boolean ccwTurn_sr(Arc arc, Arc arc2) {
        return false;
    }

    private void classify_headonright_t(Bin bin, Bin bin2, Bin bin3, float f) {
    }

    private void classify_tailonleft_t(Bin bin, Bin bin2, Bin bin3, float f) {
    }

    private void classify_headonleft_t(Bin bin, Bin bin2, Bin bin3, float f) {
        Arc arc;
        while ((arc = bin.removearc()) != null) {
            arc.setitail();
            float f2 = arc.prev.tail()[1] - f;
            if (f2 > 0.0f) {
                bin3.addarc(arc);
                continue;
            }
            if (f2 < 0.0f) {
                if (this.ccwTurn_tl(arc.prev, arc)) {
                    bin3.addarc(arc);
                    continue;
                }
                bin2.addarc(arc);
                continue;
            }
            if (arc.prev.tail()[0] > arc.prev.head()[0]) {
                bin3.addarc(arc);
                continue;
            }
            bin2.addarc(arc);
        }
    }

    private boolean ccwTurn_tl(Arc arc, Arc arc2) {
        return false;
    }

    private void classify_tailonright_s(Bin bin, Bin bin2, Bin bin3, float f) {
        Arc arc;
        while ((arc = bin.removearc()) != null) {
            arc.clearitail();
            float f2 = arc.next.head()[0] - f;
            if (f2 > 0.0f) {
                if (this.ccwTurn_sr(arc, arc.next)) {
                    bin3.addarc(arc);
                    continue;
                }
                bin2.addarc(arc);
                continue;
            }
            if (f2 < 0.0f) {
                bin2.addarc(arc);
                continue;
            }
            if (arc.next.tail()[1] > arc.next.head()[1]) {
                bin3.addarc(arc);
                continue;
            }
            bin2.addarc(arc);
        }
    }

    private void classify_headonleft_s(Bin bin, Bin bin2, Bin bin3, float f) {
        Arc arc;
        while ((arc = bin.removearc()) != null) {
            arc.setitail();
            float f2 = arc.prev.tail()[0] - f;
            if (f2 > 0.0f) {
                bin3.addarc(arc);
                continue;
            }
            if (f2 < 0.0f) {
                if (this.ccwTurn_sl(arc.prev, arc)) {
                    bin3.addarc(arc);
                    continue;
                }
                bin2.addarc(arc);
                continue;
            }
            if (arc.prev.tail()[1] > arc.prev.head()[1]) {
                bin2.addarc(arc);
                continue;
            }
            bin3.addarc(arc);
        }
    }

    private boolean ccwTurn_sl(Arc arc, Arc arc2) {
        return false;
    }

    private int arc_split(Arc arc, int n, float f, int n2) {
        return 0;
    }

    private void setNonDegenerate() {
        this.showDegenerate = false;
    }

    private void setArcTypeBezier() {
        this.isArcTypeBezier = true;
    }

    private void outline(Bin bin) {
    }

    private void makeBorderTrim(float[] fArray, float[] fArray2) {
        float f = fArray[0];
        float f2 = fArray2[0];
        float f3 = fArray[1];
        float f4 = fArray2[1];
        this.pjarc = null;
        Arc arc = null;
        arc = new Arc(4);
        this.arctesselator.bezier(arc, f, f2, f3, f3);
        this.initialbin.addarc(arc);
        this.pjarc = arc.append(this.pjarc);
        arc = new Arc(1);
        this.arctesselator.bezier(arc, f2, f2, f3, f4);
        this.initialbin.addarc(arc);
        this.pjarc = arc.append(this.pjarc);
        arc = new Arc(2);
        this.arctesselator.bezier(arc, f2, f, f4, f4);
        this.initialbin.addarc(arc);
        this.pjarc = arc.append(this.pjarc);
        arc = new Arc(3);
        this.arctesselator.bezier(arc, f, f, f4, f3);
        this.initialbin.addarc(arc);
        arc = arc.append(this.pjarc);
    }

    public void drawCurves() {
        float[] fArray = new float[1];
        float[] fArray2 = new float[1];
        Flist flist = new Flist();
        this.qlist.getRange(fArray, fArray2, flist);
        this.renderhints.init();
        this.backend.bgncurv();
        for (int i = flist.start; i < flist.end - 1; ++i) {
            float[] fArray3 = new float[1];
            float[] fArray4 = new float[1];
            fArray3[0] = flist.pts[i];
            fArray4[0] = flist.pts[i + 1];
            this.qlist.downloadAll(fArray3, fArray4, this.backend);
            Curvelist curvelist = new Curvelist(this.qlist, fArray3, fArray4);
            this.samplingSplit(curvelist, this.renderhints.maxsubdivisions);
        }
        this.backend.endcurv();
    }

    private void samplingSplit(Curvelist curvelist, int n) {
        if (curvelist.cullCheck() == 0) {
            return;
        }
        curvelist.getstepsize();
        if (!curvelist.needsSamplingSubdivision() || this.subdivisions <= 0) {
            int n2 = (int)(1.0f + curvelist.range[2] / curvelist.stepsize);
            this.backend.curvgrid(curvelist.range[0], curvelist.range[1], n2);
            this.backend.curvmesh(0, n2);
        }
    }

    public void set_domain_distance_u_rate(double d) {
        this.domain_distance_u_rate = (float)d;
    }

    public void set_domain_distance_v_rate(double d) {
        this.domain_distance_v_rate = (float)d;
    }

    public void set_is_domain_distance_sampling(int n) {
        this.is_domain_distance_sampling = n;
    }
}

