/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal.gcc.version;

import com.google.common.base.Joiner;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.UncheckedIOException;
import org.gradle.nativeplatform.platform.internal.ArchitectureInternal;
import org.gradle.nativeplatform.platform.internal.Architectures;
import org.gradle.nativeplatform.platform.internal.DefaultNativePlatform;
import org.gradle.nativeplatform.toolchain.internal.gcc.version.CompilerMetaDataProvider;
import org.gradle.nativeplatform.toolchain.internal.gcc.version.GccVersionResult;
import org.gradle.process.ExecResult;
import org.gradle.process.internal.ExecAction;
import org.gradle.process.internal.ExecActionFactory;
import org.gradle.util.TreeVisitor;
import org.gradle.util.VersionNumber;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GccVersionDeterminer
implements CompilerMetaDataProvider {
    private static final Pattern DEFINE_PATTERN = Pattern.compile("\\s*#define\\s+(\\S+)\\s+(.*)");
    private final ExecActionFactory execActionFactory;
    private final boolean clang;

    public static GccVersionDeterminer forGcc(ExecActionFactory execActionFactory) {
        return new GccVersionDeterminer(execActionFactory, false);
    }

    public static GccVersionDeterminer forClang(ExecActionFactory execActionFactory) {
        return new GccVersionDeterminer(execActionFactory, true);
    }

    GccVersionDeterminer(ExecActionFactory execActionFactory, boolean expectClang) {
        this.execActionFactory = execActionFactory;
        this.clang = expectClang;
    }

    @Override
    public GccVersionResult getGccMetaData(File gccBinary, List<String> args) {
        ArrayList<String> allArgs = new ArrayList<String>(args);
        allArgs.add("-dM");
        allArgs.add("-E");
        allArgs.add("-");
        String output = this.transform(gccBinary, allArgs);
        if (output == null) {
            return new BrokenResult(String.format("Could not determine %s version: failed to execute %s %s.", this.getDescription(), gccBinary.getName(), Joiner.on((char)' ').join(allArgs)));
        }
        return this.transform(output, gccBinary);
    }

    private String getDescription() {
        return this.clang ? "Clang" : "GCC";
    }

    private String transform(File gccBinary, List<String> args) {
        ExecAction exec = this.execActionFactory.newExecAction();
        exec.executable((Object)gccBinary.getAbsolutePath());
        exec.setWorkingDir((Object)gccBinary.getParentFile());
        exec.args(args);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        exec.setStandardOutput((OutputStream)baos);
        exec.setErrorOutput((OutputStream)new ByteArrayOutputStream());
        exec.setIgnoreExitValue(true);
        ExecResult result = exec.execute();
        int exitValue = result.getExitValue();
        if (exitValue == 0) {
            return new String(baos.toByteArray());
        }
        return null;
    }

    private GccVersionResult transform(String output, File gccBinary) {
        int patch;
        int minor;
        int major;
        BufferedReader reader = new BufferedReader(new StringReader(output));
        HashMap<String, String> defines = new HashMap<String, String>();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                Matcher matcher = DEFINE_PATTERN.matcher(line);
                if (!matcher.matches()) {
                    return new BrokenResult(String.format("Could not determine %s version: %s produced unexpected output.", this.getDescription(), gccBinary.getName()));
                }
                defines.put(matcher.group(1), matcher.group(2));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
        if (!defines.containsKey("__GNUC__")) {
            return new BrokenResult(String.format("Could not determine %s version: %s produced unexpected output.", this.getDescription(), gccBinary.getName()));
        }
        if (this.clang) {
            if (!defines.containsKey("__clang__")) {
                return new BrokenResult(String.format("%s appears to be GCC rather than Clang. Treating it as GCC.", gccBinary.getName()));
            }
            major = this.toInt((String)defines.get("__clang_major__"));
            minor = this.toInt((String)defines.get("__clang_minor__"));
            patch = this.toInt((String)defines.get("__clang_patchlevel__"));
        } else {
            if (defines.containsKey("__clang__")) {
                return new BrokenResult(String.format("XCode %s is a wrapper around Clang. Treating it as Clang and not GCC.", gccBinary.getName()));
            }
            major = this.toInt((String)defines.get("__GNUC__"));
            minor = this.toInt((String)defines.get("__GNUC_MINOR__"));
            patch = this.toInt((String)defines.get("__GNUC_PATCHLEVEL__"));
        }
        ArchitectureInternal architecture = this.determineArchitecture(defines);
        return new DefaultGccVersionResult(new VersionNumber(major, minor, patch, null), architecture, this.clang);
    }

    private ArchitectureInternal determineArchitecture(Map<String, String> defines) {
        boolean i386 = defines.containsKey("__i386__");
        boolean amd64 = defines.containsKey("__amd64__");
        ArchitectureInternal architecture = i386 ? Architectures.forInput("i386") : (amd64 ? Architectures.forInput("amd64") : DefaultNativePlatform.getCurrentArchitecture());
        return architecture;
    }

    private int toInt(String value) {
        if (value == null) {
            return 0;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BrokenResult
    implements GccVersionResult {
        private final String message;

        private BrokenResult(String message) {
            this.message = message;
        }

        @Override
        public VersionNumber getVersion() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isClang() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ArchitectureInternal getDefaultArchitecture() {
            throw new UnsupportedOperationException();
        }

        public boolean isAvailable() {
            return false;
        }

        public void explain(TreeVisitor<? super String> visitor) {
            visitor.node((Object)this.message);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultGccVersionResult
    implements GccVersionResult {
        private final VersionNumber scrapedVersion;
        private final ArchitectureInternal architecture;
        private final boolean clang;

        public DefaultGccVersionResult(VersionNumber scrapedVersion, ArchitectureInternal architecture, boolean clang) {
            this.scrapedVersion = scrapedVersion;
            this.architecture = architecture;
            this.clang = clang;
        }

        @Override
        public VersionNumber getVersion() {
            return this.scrapedVersion;
        }

        @Override
        public boolean isClang() {
            return this.clang;
        }

        @Override
        public ArchitectureInternal getDefaultArchitecture() {
            return this.architecture;
        }

        public boolean isAvailable() {
            return true;
        }

        public void explain(TreeVisitor<? super String> visitor) {
        }
    }
}

