/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.internal;

import groovy.lang.Closure;
import java.util.HashSet;
import java.util.Set;
import org.gradle.api.Incubating;
import org.gradle.api.InvalidUserDataException;
import org.gradle.jvm.internal.PackageName;
import org.gradle.platform.base.DependencySpecContainer;
import org.gradle.platform.base.internal.DefaultDependencySpecContainer;
import org.gradle.util.ConfigureUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
class ApiSpec {
    private final Set<PackageName> exports = new HashSet<PackageName>();
    private final DefaultDependencySpecContainer dependencies = new DefaultDependencySpecContainer();

    ApiSpec() {
    }

    public void exports(String value) {
        PackageName packageName;
        try {
            packageName = PackageName.of(value);
        }
        catch (IllegalArgumentException cause) {
            throw new InvalidUserDataException(String.format("Invalid public API specification: %s", cause.getMessage()), (Throwable)cause);
        }
        if (!this.exports.add(packageName)) {
            throw new InvalidUserDataException(String.format("Invalid public API specification: package '%s' has already been exported", packageName));
        }
    }

    public Set<PackageName> getExports() {
        return this.exports;
    }

    public DependencySpecContainer getDependencies() {
        return this.dependencies;
    }

    public void dependencies(Closure<?> configureAction) {
        ConfigureUtil.configure(configureAction, (Object)this.dependencies);
    }
}

