/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.internal;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.jvm.JvmByteCode;
import org.gradle.jvm.JvmResources;
import org.gradle.jvm.internal.ApiSpec;
import org.gradle.jvm.internal.JvmLibrarySpecInternal;
import org.gradle.jvm.internal.PackageName;
import org.gradle.platform.base.DependencySpec;
import org.gradle.platform.base.TransformationFileType;
import org.gradle.platform.base.component.BaseComponentSpec;
import org.gradle.platform.base.internal.DefaultPlatformRequirement;
import org.gradle.platform.base.internal.PlatformRequirement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultJvmLibrarySpec
extends BaseComponentSpec
implements JvmLibrarySpecInternal {
    private final Set<Class<? extends TransformationFileType>> languageOutputs = new HashSet<Class<? extends TransformationFileType>>();
    private final List<PlatformRequirement> targetPlatforms = Lists.newArrayList();
    private final ApiSpec apiSpec = new ApiSpec();

    public DefaultJvmLibrarySpec() {
        this.languageOutputs.add(JvmResources.class);
        this.languageOutputs.add(JvmByteCode.class);
    }

    protected String getTypeName() {
        return "JVM library";
    }

    public Set<Class<? extends TransformationFileType>> getInputTypes() {
        return this.languageOutputs;
    }

    public List<PlatformRequirement> getTargetPlatforms() {
        return Collections.unmodifiableList(this.targetPlatforms);
    }

    public void targetPlatform(String targetPlatform) {
        this.targetPlatforms.add(DefaultPlatformRequirement.create((String)targetPlatform));
    }

    void api(Action<ApiSpec> configureAction) {
        configureAction.execute((Object)this.apiSpec);
    }

    @Override
    public Set<String> getExportedPackages() {
        Iterable transform = Iterables.transform(this.apiSpec.getExports(), (Function)new Function<PackageName, String>(){

            public String apply(PackageName packageName) {
                return packageName.toString();
            }
        });
        return ImmutableSet.copyOf((Iterable)transform);
    }

    @Override
    public Collection<DependencySpec> getApiDependencies() {
        return this.apiSpec.getDependencies().getDependencies();
    }
}

