/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.foundation.ipc.gradle;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.commons.io.IOUtils;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.file.TemporaryFileProvider;
import org.gradle.api.internal.file.TmpDirTemporaryFileProvider;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.foundation.CommandLineAssistant;
import org.gradle.foundation.ipc.basic.ClientProcess;
import org.gradle.foundation.ipc.basic.ExecutionInfo;
import org.gradle.foundation.ipc.basic.MessageObject;
import org.gradle.foundation.ipc.basic.ProcessLauncherServer;
import org.gradle.foundation.ipc.gradle.KillGradleClientProtocol;
import org.gradle.internal.jvm.Jvm;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.logging.ShowStacktrace;

public abstract class AbstractGradleServerProtocol
implements ProcessLauncherServer.Protocol {
    private static final String INIT_SCRIPT_EXTENSION = ".gradle";
    private final Logger logger = Logging.getLogger(AbstractGradleServerProtocol.class);
    private final TemporaryFileProvider temporaryFileProvider = new TmpDirTemporaryFileProvider();
    protected ProcessLauncherServer server;
    private boolean continueConnection;
    private boolean waitingOnHandshakeCompletion;
    private boolean hasCompletedConnection;
    private boolean hasReceivedBuildCompleteNotification;
    private File currentDirectory;
    private File gradleHomeDirectory;
    private File customGradleExecutor;
    private String commandLine;
    private LogLevel logLevel;
    private int killGradleServerPort;
    private KillGradleClientProtocol killGradleClientProcotol;
    private ClientProcess killGradleClient;
    protected MessageObject lastMessageReceived;
    private ShowStacktrace stackTraceLevel;

    public boolean continueConnection() {
        return this.continueConnection;
    }

    public AbstractGradleServerProtocol(File currentDirectory, File gradleHomeDirectory, File customGradleExecutor, String fullCommandLine, LogLevel logLevel, ShowStacktrace stackTraceLevel) {
        this.currentDirectory = currentDirectory;
        this.gradleHomeDirectory = gradleHomeDirectory;
        this.customGradleExecutor = customGradleExecutor;
        this.commandLine = fullCommandLine;
        this.logLevel = logLevel;
        this.stackTraceLevel = stackTraceLevel;
    }

    public void connectionAccepted() {
        this.server.sendMessage("connected", "server-reply");
        this.continueConnection = true;
        this.waitingOnHandshakeCompletion = true;
    }

    public void initialize(ProcessLauncherServer server) {
        this.server = server;
    }

    protected void closeConnection() {
        this.continueConnection = false;
    }

    public void messageReceived(MessageObject message) {
        this.lastMessageReceived = message;
        if (this.waitingOnHandshakeCompletion) {
            if ("client-reply".equalsIgnoreCase(message.getMessage())) {
                this.waitingOnHandshakeCompletion = false;
                this.hasCompletedConnection = true;
                if (message.getData() != null) {
                    this.killGradleServerPort = (Integer)message.getData();
                    this.killGradleClientProcotol = new KillGradleClientProtocol();
                    this.killGradleClient = new ClientProcess(this.killGradleClientProcotol);
                    this.killGradleClient.start(this.killGradleServerPort);
                    this.handShakeCompleted();
                } else {
                    this.addStatus("Invalid handshaking. Missing port number. Stopping connection");
                    this.server.sendMessage("?", "Invalid client handshake protocol!");
                    this.closeConnection();
                }
            } else {
                this.addStatus("Invalid handshaking. Stopping connection");
                this.server.sendMessage("?", "Invalid client handshake protocol!");
                this.closeConnection();
            }
        } else {
            try {
                this.handleMessageReceived(message);
            }
            catch (Throwable e) {
                this.logger.error("Problem while handing message :\n" + message, e);
            }
        }
    }

    protected void handShakeCompleted() {
    }

    protected abstract boolean handleMessageReceived(MessageObject var1);

    public void setHasReceivedBuildCompleteNotification() {
        this.hasReceivedBuildCompleteNotification = true;
    }

    protected abstract void addStatus(String var1);

    public ExecutionInfo getExecutionInfo(int serverPort) {
        String stackTraceLevelText;
        String logLevelText;
        MyExecutionInfo executionInfo = new MyExecutionInfo();
        executionInfo.addEnvironmentVariable("JAVA_HOME", Jvm.current().getJavaHome().getAbsolutePath());
        executionInfo.setWorkingDirectory(this.currentDirectory);
        ArrayList<String> executionCommandLine = new ArrayList<String>();
        File gradleExecutableFile = this.getGradleExecutableFile();
        if (gradleExecutableFile == null) {
            throw new RuntimeException("Gradle executable not specified");
        }
        if (!gradleExecutableFile.exists()) {
            throw new RuntimeException("Missing gradle executable. Expected it at: " + gradleExecutableFile);
        }
        executionCommandLine.add(gradleExecutableFile.getAbsolutePath());
        executionCommandLine.add("-DPortNumber=" + Integer.toString(serverPort));
        CommandLineAssistant commandLineAssistant = new CommandLineAssistant();
        String[] individualCommandLineArguments = CommandLineAssistant.breakUpCommandLine(this.commandLine);
        executionCommandLine.addAll(Arrays.asList(individualCommandLineArguments));
        File initStriptPath = this.getInitScriptFile();
        if (initStriptPath != null) {
            executionCommandLine.add("-I");
            executionCommandLine.add(initStriptPath.getAbsolutePath());
            executionInfo.initStriptPath = initStriptPath;
        }
        if (!commandLineAssistant.hasLogLevelDefined(individualCommandLineArguments) && (logLevelText = commandLineAssistant.getLoggingCommandLineConverter().getLogLevelCommandLine(this.logLevel)) != null && !"".equals(logLevelText)) {
            executionCommandLine.add('-' + logLevelText);
        }
        if (!commandLineAssistant.hasShowStacktraceDefined(individualCommandLineArguments) && (stackTraceLevelText = commandLineAssistant.getLoggingCommandLineConverter().getShowStacktraceCommandLine(this.stackTraceLevel)) != null) {
            executionCommandLine.add('-' + stackTraceLevelText);
        }
        executionInfo.setCommandLineArguments(executionCommandLine.toArray(new String[executionCommandLine.size()]));
        return executionInfo;
    }

    protected File getGradleExecutableFile() {
        if (this.customGradleExecutor != null) {
            return this.customGradleExecutor;
        }
        return new File(this.gradleHomeDirectory, "bin" + File.separator + this.getDefaultGradleExecutableName());
    }

    private String getDefaultGradleExecutableName() {
        return OperatingSystem.current().getScriptName("gradle");
    }

    public void clientCommunicationStopped() {
    }

    public void clientExited(int returnCode, String output) {
        String message;
        this.server.requestShutdown();
        boolean wasPremature = false;
        if (!this.hasCompletedConnection) {
            message = "Failed to connect to gradle process for command '" + this.commandLine + "'\n" + output;
            wasPremature = true;
        } else if (!this.hasReceivedBuildCompleteNotification) {
            message = output;
            wasPremature = true;
        } else {
            message = output;
        }
        this.reportClientExit(wasPremature, returnCode, message);
    }

    protected abstract void reportClientExit(boolean var1, int var2, String var3);

    public abstract File getInitScriptFile();

    protected File extractInitScriptFile(Class resourceClass, String resourceName) {
        File file = null;
        try {
            file = this.temporaryFileProvider.createTemporaryFile(resourceName, INIT_SCRIPT_EXTENSION, new String[0]);
        }
        catch (UncheckedIOException e) {
            this.logger.error("Creating init script file temp file", (Throwable)e);
            return null;
        }
        file.deleteOnExit();
        if (this.extractResourceAsFile(resourceClass, resourceName + INIT_SCRIPT_EXTENSION, file)) {
            return file;
        }
        this.logger.error("Internal error! Failed to extract init script for executing commands!");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean extractResourceAsFile(Class resourceClass, String name, File file) {
        boolean bl;
        InputStream stream = resourceClass.getResourceAsStream(name);
        if (stream == null) {
            return false;
        }
        byte[] bytes = new byte[]{};
        try {
            bytes = IOUtils.toByteArray((InputStream)stream);
        }
        catch (IOException e) {
            this.logger.error("Extracting resource as file", (Throwable)e);
            return false;
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            try {
                IOUtils.write((byte[])bytes, (OutputStream)fileOutputStream);
            }
            finally {
                fileOutputStream.close();
            }
            bl = true;
        }
        catch (IOException e) {
            boolean bl2;
            try {
                this.logger.error("Extracting resource as file (writing bytes)", (Throwable)e);
                bl2 = false;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileOutputStream);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)fileOutputStream);
            return bl2;
        }
        IOUtils.closeQuietly((OutputStream)fileOutputStream);
        return bl;
    }

    protected File getGradleHomeDirectory() {
        return this.gradleHomeDirectory;
    }

    public void readFailureOccurred() {
        this.logger.debug("Last message received: " + this.lastMessageReceived);
    }

    public void aboutToKillProcess() {
        this.killGradle();
    }

    public void killGradle() {
        if (this.killGradleClientProcotol != null) {
            this.killGradleClientProcotol.sendKillMessage();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class MyExecutionInfo
    implements ExecutionInfo {
        public String[] commandLineArguments;
        public File workingDirectory;
        public HashMap<String, String> environmentVariables = new HashMap();
        public File initStriptPath;

        @Override
        public String[] getCommandLineArguments() {
            return this.commandLineArguments;
        }

        @Override
        public File getWorkingDirectory() {
            return this.workingDirectory;
        }

        @Override
        public HashMap<String, String> getEnvironmentVariables() {
            return this.environmentVariables;
        }

        public void setCommandLineArguments(String[] commandLineArguments) {
            this.commandLineArguments = commandLineArguments;
        }

        public void setWorkingDirectory(File workingDirectory) {
            this.workingDirectory = workingDirectory;
        }

        public void addEnvironmentVariable(String name, String value) {
            this.environmentVariables.put(name, value);
        }

        @Override
        public void processExecutionComplete() {
            if (this.initStriptPath != null) {
                this.initStriptPath.delete();
            }
        }
    }
}

