/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.resolve;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.collect.TreeMultimap;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import org.gradle.internal.Cast;
import org.gradle.language.base.internal.model.DefaultVariantAxisCompatibility;
import org.gradle.language.base.internal.model.DefaultVariantsMetaData;
import org.gradle.language.base.internal.model.VariantAxisCompatibility;
import org.gradle.language.base.internal.model.VariantAxisCompatibilityFactory;
import org.gradle.language.base.internal.model.VariantsMetaData;
import org.gradle.language.base.internal.model.VariantsMetaDataHelper;
import org.gradle.model.internal.manage.schema.ModelSchemaStore;
import org.gradle.platform.base.BinarySpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariantsMatcher {
    private static final Comparator<VariantValue> SPEC_COMPARATOR = new Comparator<VariantValue>(){

        @Override
        public int compare(VariantValue o1, VariantValue o2) {
            return o1.spec.getDisplayName().compareTo(o2.spec.getDisplayName());
        }
    };
    private final List<VariantAxisCompatibilityFactory> factories;
    private final Class<? extends BinarySpec> binarySpecType;
    private final ModelSchemaStore schemaStore;

    public VariantsMatcher(List<VariantAxisCompatibilityFactory> factories, Class<? extends BinarySpec> binarySpecType, ModelSchemaStore schemaStore) {
        this.factories = factories;
        this.binarySpecType = binarySpecType;
        this.schemaStore = schemaStore;
    }

    private VariantAxisCompatibility<Object> createSelector(Object o) {
        for (VariantAxisCompatibilityFactory factory : this.factories) {
            VariantAxisCompatibility<Object> selector = factory.getVariantAxisCompatibility(o);
            if (selector == null) continue;
            return selector;
        }
        return new DefaultVariantAxisCompatibility();
    }

    public Collection<? extends BinarySpec> filterBinaries(VariantsMetaData variantsMetaData, Collection<BinarySpec> binaries) {
        if (binaries.isEmpty()) {
            return binaries;
        }
        Set<String> resolveDimensions = variantsMetaData.getNonNullVariantAxes();
        TreeMultimap selectedVariants = TreeMultimap.create((Comparator)String.CASE_INSENSITIVE_ORDER, SPEC_COMPARATOR);
        HashSet removedSpecs = Sets.newHashSet();
        for (BinarySpec binarySpec : binaries) {
            Sets.SetView commonsDimensions;
            VariantsMetaData binaryVariants;
            Set<String> incompatibleDimensionTypes;
            if (!this.binarySpecType.isAssignableFrom(binarySpec.getClass()) || !(incompatibleDimensionTypes = VariantsMetaDataHelper.determineAxesWithIncompatibleTypes(variantsMetaData, binaryVariants = DefaultVariantsMetaData.extractFrom(binarySpec, this.schemaStore), (Set<String>)(commonsDimensions = Sets.intersection(resolveDimensions, binaryVariants.getNonNullVariantAxes())))).isEmpty()) continue;
            for (String dimension : commonsDimensions) {
                Class dimensionType = variantsMetaData.getVariantAxisType(dimension).getConcreteClass();
                boolean isStringType = String.class == dimensionType;
                String requestedValue = isStringType ? variantsMetaData.getValueAsString(dimension) : variantsMetaData.getValueAsType((Class)Cast.uncheckedCast((Object)dimensionType), dimension);
                String binaryValue = isStringType ? binaryVariants.getValueAsString(dimension) : binaryVariants.getValueAsType((Class)Cast.uncheckedCast((Object)dimensionType), dimension);
                VariantAxisCompatibility<Object> selector = this.createSelector(requestedValue);
                if (selector.isCompatibleWithRequirement(requestedValue, binaryValue)) {
                    VariantValue value = new VariantValue(binaryValue, binarySpec);
                    SortedSet variantValues = selectedVariants.get((Object)dimension);
                    for (VariantValue variantValue : variantValues) {
                        if (selector.betterFit(requestedValue, variantValue.value, binaryValue)) {
                            removedSpecs.add(variantValue.spec);
                            continue;
                        }
                        if (!selector.betterFit(requestedValue, binaryValue, variantValue.value)) continue;
                        removedSpecs.add(value.spec);
                    }
                    selectedVariants.put((Object)dimension, (Object)value);
                    continue;
                }
                removedSpecs.add(binarySpec);
            }
        }
        ImmutableSet union = null;
        for (String dimension : selectedVariants.keySet()) {
            ImmutableSet variantValues = ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)selectedVariants.get((Object)dimension), VariantValue.SPEC_FUNCTION));
            union = union == null ? variantValues : Sets.union((Set)union, (Set)variantValues);
        }
        return union == null ? Collections.emptySet() : Sets.difference(union, (Set)removedSpecs);
    }

    private static class VariantValue {
        public static final Function<VariantValue, BinarySpec> SPEC_FUNCTION = new Function<VariantValue, BinarySpec>(){

            public BinarySpec apply(VariantValue input) {
                return input.spec;
            }
        };
        final Object value;
        final BinarySpec spec;

        private VariantValue(Object value, BinarySpec spec) {
            this.value = value;
            this.spec = spec;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("VariantValue{");
            sb.append("spec=").append(this.spec);
            sb.append(", value=").append(this.value);
            sb.append('}');
            return sb.toString();
        }
    }
}

