/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.base.internal.tasks.apigen.abi;

import com.google.common.collect.Lists;
import java.util.List;
import org.gradle.language.base.internal.tasks.apigen.abi.AnnotationAnnotationValue;
import org.gradle.language.base.internal.tasks.apigen.abi.AnnotationSig;
import org.gradle.language.base.internal.tasks.apigen.abi.AnnotationValue;
import org.gradle.language.base.internal.tasks.apigen.abi.ArrayAnnotationValue;
import org.gradle.language.base.internal.tasks.apigen.abi.EnumAnnotationValue;
import org.gradle.language.base.internal.tasks.apigen.abi.SimpleAnnotationValue;
import org.objectweb.asm.AnnotationVisitor;

public class SortingAnnotationVisitor
extends AnnotationVisitor {
    private final AnnotationSig sig;
    SortingAnnotationVisitor parent;
    String array;
    String subAnnName;
    final List<AnnotationValue> values = Lists.newLinkedList();

    public SortingAnnotationVisitor(AnnotationSig parent, AnnotationVisitor av) {
        super(327680, av);
        this.sig = parent;
    }

    public AnnotationVisitor visitAnnotation(String name, String desc) {
        AnnotationSig subAnn = new AnnotationSig(desc, true);
        SortingAnnotationVisitor sortingAnnotationVisitor = new SortingAnnotationVisitor(subAnn, super.visitAnnotation(name, desc));
        sortingAnnotationVisitor.subAnnName = name == null ? "value" : name;
        sortingAnnotationVisitor.parent = this;
        return sortingAnnotationVisitor;
    }

    public void visit(String name, Object value) {
        this.values.add(new SimpleAnnotationValue(name, value));
        super.visit(name, value);
    }

    public AnnotationVisitor visitArray(String name) {
        SortingAnnotationVisitor sortingAnnotationVisitor = new SortingAnnotationVisitor(this.sig, super.visitArray(name));
        sortingAnnotationVisitor.array = name;
        return sortingAnnotationVisitor;
    }

    public void visitEnum(String name, String desc, String value) {
        this.values.add(new EnumAnnotationValue(name == null ? "value" : name, desc, value));
        super.visitEnum(name, desc, value);
    }

    public void visitEnd() {
        if (this.subAnnName != null) {
            AnnotationAnnotationValue ann = new AnnotationAnnotationValue(this.subAnnName, this.sig);
            this.parent.values.add(ann);
            this.subAnnName = null;
        } else if (this.array != null) {
            ArrayAnnotationValue arr = new ArrayAnnotationValue(this.array, this.values.toArray(new AnnotationValue[this.values.size()]));
            this.sig.getValues().add(arr);
            this.array = null;
        }
        this.sig.getValues().addAll(this.values);
        this.values.clear();
        super.visitEnd();
    }
}

