/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.platform.base.internal;

import java.util.List;
import org.gradle.api.Nullable;
import org.gradle.platform.base.internal.BinaryNamingScheme;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultBinaryNamingScheme
implements BinaryNamingScheme {
    final String parentName;
    final String typeString;
    final String dimensionPrefix;
    final List<String> dimensions;

    public DefaultBinaryNamingScheme(String parentName, String typeString, List<String> dimensions) {
        this.parentName = parentName;
        this.typeString = typeString;
        this.dimensions = dimensions;
        this.dimensionPrefix = this.createPrefix(dimensions);
    }

    private String createPrefix(List<String> dimensions) {
        if (dimensions.isEmpty()) {
            return "";
        }
        return this.makeName(dimensions.toArray(new String[dimensions.size()]));
    }

    @Override
    public String getBaseName() {
        return this.parentName;
    }

    @Override
    public String getLifecycleTaskName() {
        return this.getTaskName(null, null);
    }

    @Override
    public String getOutputDirectoryBase() {
        StringBuilder builder = new StringBuilder(this.makeName(this.parentName, this.typeString));
        if (this.dimensionPrefix.length() > 0) {
            builder.append('/');
            builder.append(this.dimensionPrefix);
        }
        return builder.toString();
    }

    @Override
    public String getDescription() {
        StringBuilder builder = new StringBuilder();
        builder.append(GUtil.toWords((CharSequence)this.typeString));
        builder.append(" '");
        builder.append(this.parentName);
        for (String dimension : this.dimensions) {
            builder.append(':');
            builder.append(dimension);
        }
        builder.append(':');
        this.appendUncapitalized(builder, this.typeString);
        builder.append("'");
        return builder.toString();
    }

    @Override
    public List<String> getVariantDimensions() {
        return this.dimensions;
    }

    @Override
    public String getTaskName(@Nullable String verb) {
        return this.getTaskName(verb, null);
    }

    @Override
    public String getTaskName(@Nullable String verb, @Nullable String target) {
        return this.makeName(verb, this.dimensionPrefix, this.parentName, this.typeString, target);
    }

    public String makeName(String ... words) {
        int expectedLength = 0;
        for (String word : words) {
            if (word == null) continue;
            expectedLength += word.length();
        }
        StringBuilder builder = new StringBuilder(expectedLength);
        for (String word : words) {
            if (word == null || word.length() == 0) continue;
            if (builder.length() == 0) {
                this.appendUncapitalized(builder, word);
                continue;
            }
            this.appendCapitalized(builder, word);
        }
        return builder.toString();
    }

    private void appendCapitalized(StringBuilder builder, String word) {
        if (word.length() == 0) {
            return;
        }
        builder.append(Character.toTitleCase(word.charAt(0))).append(word.substring(1));
    }

    private void appendUncapitalized(StringBuilder builder, String word) {
        if (word.length() == 0) {
            return;
        }
        builder.append(Character.toLowerCase(word.charAt(0))).append(word.substring(1));
    }
}

