/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.remote.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.concurrent.AsyncStoppable;
import org.gradle.internal.concurrent.StoppableExecutor;
import org.gradle.messaging.dispatch.AsyncReceive;
import org.gradle.messaging.dispatch.Dispatch;
import org.gradle.messaging.dispatch.Receive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EagerReceiveBuffer<T>
implements Receive<T>,
AsyncStoppable {
    private static final int DEFAULT_BUFFER_SIZE = 200;
    private final Lock lock = new ReentrantLock();
    private final Condition notFullOrStop = this.lock.newCondition();
    private final Condition notEmptyOrNoReceivers = this.lock.newCondition();
    private final Collection<Receive<T>> receivers;
    private final CountDownLatch onReceiversExhaustedFinishedLatch = new CountDownLatch(1);
    private final AsyncReceive<T> asyncReceive;
    private final LinkedList<T> queue = new LinkedList();
    private boolean hasActiveReceivers = true;
    private State state = State.Init;

    private static <T> Collection<Receive<T>> toReceiveCollection(Receive<T> receiver) {
        ArrayList<Receive<T>> list = new ArrayList<Receive<T>>(1);
        list.add(receiver);
        return list;
    }

    public EagerReceiveBuffer(StoppableExecutor executor, Collection<Receive<T>> receivers) {
        this(executor, 200, receivers, null);
    }

    public EagerReceiveBuffer(StoppableExecutor executor, int bufferSize, Receive<T> receiver, Runnable onReceiversExhausted) {
        this(executor, bufferSize, EagerReceiveBuffer.toReceiveCollection(receiver), onReceiversExhausted);
    }

    public EagerReceiveBuffer(StoppableExecutor executor, int bufferSize, Collection<Receive<T>> receivers) {
        this(executor, bufferSize, receivers, null);
    }

    public EagerReceiveBuffer(StoppableExecutor executor, final int bufferSize, Collection<Receive<T>> receivers, final Runnable onReceiversExhausted) {
        if (receivers.size() == 0) {
            throw new IllegalArgumentException("eager receive buffer created with no receivers");
        }
        if (bufferSize < 1) {
            throw new IllegalArgumentException("eager receive buffer size must be positive (value given: " + bufferSize + ")");
        }
        this.receivers = receivers;
        Dispatch dispatch = new Dispatch<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dispatch(T message) {
                EagerReceiveBuffer.this.lock.lock();
                try {
                    while (EagerReceiveBuffer.this.queue.size() == bufferSize && EagerReceiveBuffer.this.state == State.Started) {
                        try {
                            EagerReceiveBuffer.this.notFullOrStop.await();
                        }
                        catch (InterruptedException e) {
                            throw UncheckedException.throwAsUncheckedException((Throwable)e);
                        }
                    }
                    EagerReceiveBuffer.this.queue.add(message);
                    EagerReceiveBuffer.this.notEmptyOrNoReceivers.signalAll();
                }
                finally {
                    EagerReceiveBuffer.this.lock.unlock();
                }
            }
        };
        this.asyncReceive = new AsyncReceive((Executor)executor, dispatch, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                EagerReceiveBuffer.this.lock.lock();
                try {
                    EagerReceiveBuffer.this.hasActiveReceivers = false;
                    if (onReceiversExhausted != null) {
                        onReceiversExhausted.run();
                    }
                    EagerReceiveBuffer.this.notEmptyOrNoReceivers.signalAll();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                finally {
                    EagerReceiveBuffer.this.lock.unlock();
                    EagerReceiveBuffer.this.onReceiversExhaustedFinishedLatch.countDown();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        this.lock.lock();
        try {
            if (this.state != State.Init) {
                throw new IllegalStateException("this eager receive buffer has already been started");
            }
            this.state = State.Started;
            for (Receive<T> receiver : this.receivers) {
                this.asyncReceive.receiveFrom(receiver);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T receive() {
        this.lock.lock();
        try {
            while (this.queue.isEmpty() && this.hasActiveReceivers) {
                try {
                    this.notEmptyOrNoReceivers.await();
                }
                catch (InterruptedException e) {
                    throw UncheckedException.throwAsUncheckedException((Throwable)e);
                }
            }
            if (this.queue.isEmpty()) {
                assert (!this.hasActiveReceivers);
                T e = null;
                return e;
            }
            T message = this.queue.poll();
            assert (message != null);
            this.notFullOrStop.signalAll();
            T t = message;
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestStop() {
        this.lock.lock();
        try {
            this.doRequestStop();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void doRequestStop() {
        this.asyncReceive.requestStop();
        if (this.hasActiveReceivers) {
            this.setState(State.Stopping);
        } else {
            this.setState(State.Stopped);
        }
    }

    private void setState(State state) {
        this.state = state;
        this.notFullOrStop.signalAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.lock.lock();
        try {
            this.doRequestStop();
        }
        finally {
            this.lock.unlock();
        }
        try {
            this.onReceiversExhaustedFinishedLatch.await();
        }
        catch (InterruptedException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
        this.lock.lock();
        try {
            this.asyncReceive.stop();
            this.setState(State.Stopped);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        Init,
        Started,
        Stopping,
        Stopped;

    }
}

