/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.remote.internal.protocol;

import java.util.UUID;
import org.gradle.messaging.remote.internal.Message;
import org.gradle.messaging.remote.internal.protocol.RoutableMessage;

public abstract class ProducerMessage
extends Message
implements RoutableMessage {
    protected final UUID producerId;
    protected final Object consumerId;

    public ProducerMessage(UUID producerId, Object consumerId) {
        this.consumerId = consumerId;
        this.producerId = producerId;
    }

    public Object getConsumerId() {
        return this.consumerId;
    }

    public UUID getProducerId() {
        return this.producerId;
    }

    public Object getDestination() {
        return this.consumerId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        ProducerMessage other = (ProducerMessage)o;
        return this.consumerId.equals(other.consumerId) && this.producerId.equals(other.producerId);
    }

    public int hashCode() {
        return this.consumerId.hashCode() ^ this.producerId.hashCode();
    }

    public String toString() {
        return String.format("[%s producerId: %s, consumerId: %s", this.getClass().getSimpleName(), this.producerId, this.consumerId);
    }
}

