/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.nativeplatform.internal;

import java.io.File;
import java.util.Set;
import java.util.concurrent.Callable;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.language.base.internal.LanguageSourceSetInternal;
import org.gradle.language.base.internal.registry.LanguageTransform;
import org.gradle.language.nativeplatform.internal.CompileTaskConfig;
import org.gradle.language.nativeplatform.internal.DependentSourceSetInternal;
import org.gradle.language.nativeplatform.tasks.AbstractNativeCompileTask;
import org.gradle.nativeplatform.ObjectFile;
import org.gradle.nativeplatform.internal.NativeBinarySpecInternal;
import org.gradle.nativeplatform.tasks.PrefixHeaderFileGenerateTask;
import org.gradle.nativeplatform.toolchain.internal.PreCompiledHeader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PCHCompileTaskConfig
extends CompileTaskConfig {
    public PCHCompileTaskConfig(LanguageTransform<? extends LanguageSourceSet, ObjectFile> languageTransform, Class<? extends DefaultTask> taskType) {
        super(languageTransform, taskType);
    }

    @Override
    protected void configureCompileTask(AbstractNativeCompileTask task, NativeBinarySpecInternal binary, LanguageSourceSetInternal languageSourceSet) {
        final DependentSourceSetInternal sourceSet = (DependentSourceSetInternal)languageSourceSet;
        task.setDescription(String.format("Compiles a pre-compiled header for the %s of %s", sourceSet, binary));
        task.includes(new Callable<Set<File>>(){

            @Override
            public Set<File> call() throws Exception {
                return sourceSet.getSource().getSrcDirs();
            }
        });
        Project project = task.getProject();
        task.source(sourceSet.getPrefixHeaderFile());
        task.setObjectFileDir(project.file((Object)(String.valueOf(project.getBuildDir()) + "/objs/" + binary.getNamingScheme().getOutputDirectoryBase() + "/" + languageSourceSet.getFullName() + "PCH")));
        task.dependsOn(new Object[]{project.getTasks().withType(PrefixHeaderFileGenerateTask.class).matching((Spec)new Spec<PrefixHeaderFileGenerateTask>(){

            public boolean isSatisfiedBy(PrefixHeaderFileGenerateTask prefixHeaderFileGenerateTask) {
                return prefixHeaderFileGenerateTask.getPrefixHeaderFile().equals(sourceSet.getPrefixHeaderFile());
            }
        })});
        binary.binaryInputs((FileCollection)task.getOutputs().getFiles().getAsFileTree().matching((PatternFilterable)new PatternSet().include(new String[]{"**/*.obj", "**/*.o"})));
        PreCompiledHeader pch = (PreCompiledHeader)binary.getPrefixFileToPCH().get(sourceSet.getPrefixHeaderFile());
        pch.setPchObjects((FileCollection)task.getOutputs().getFiles().getAsFileTree().matching((PatternFilterable)new PatternSet().include(new String[]{"**/*.pch", "**/*.gch"})));
        pch.builtBy(new Object[]{task});
    }
}

