/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies;

import java.util.List;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies.DependencyDescriptorFactory;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies.IvyDependencyDescriptorFactory;
import org.gradle.internal.component.model.DependencyMetaData;
import org.gradle.util.WrapUtil;

public class DefaultDependencyDescriptorFactory
implements DependencyDescriptorFactory {
    private List<IvyDependencyDescriptorFactory> dependencyDescriptorFactories;

    public DefaultDependencyDescriptorFactory(IvyDependencyDescriptorFactory ... dependencyDescriptorFactories) {
        this.dependencyDescriptorFactories = WrapUtil.toList((Object[])dependencyDescriptorFactories);
    }

    public DependencyMetaData createDependencyDescriptor(String configuration, ModuleDependency dependency) {
        IvyDependencyDescriptorFactory factoryInternal = this.findFactoryForDependency(dependency);
        return factoryInternal.createDependencyDescriptor(configuration, dependency);
    }

    private IvyDependencyDescriptorFactory findFactoryForDependency(ModuleDependency dependency) {
        for (IvyDependencyDescriptorFactory ivyDependencyDescriptorFactory : this.dependencyDescriptorFactories) {
            if (!ivyDependencyDescriptorFactory.canConvert(dependency)) continue;
            return ivyDependencyDescriptorFactory;
        }
        throw new InvalidUserDataException("Can't map dependency of type: " + dependency.getClass());
    }
}

