/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.store;

import java.io.Closeable;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.oldresult.TransientConfigurationResults;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.store.CachedStoreFactory;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.store.DefaultBinaryStore;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.store.StoreSet;
import org.gradle.api.internal.cache.Store;
import org.gradle.api.internal.file.TemporaryFileProvider;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.util.Clock;

public class ResolutionResultsStoreFactory
implements Closeable {
    private static final Logger LOG = Logging.getLogger(ResolutionResultsStoreFactory.class);
    private static final int DEFAULT_MAX_SIZE = 2000000000;
    private final TemporaryFileProvider temp;
    private int maxSize;
    private CachedStoreFactory oldModelCache;
    private CachedStoreFactory newModelCache;
    private int storeSetBaseId;
    private final Map<String, DefaultBinaryStore> stores = new HashMap<String, DefaultBinaryStore>();
    private final CompositeStoppable cleanUpLater = new CompositeStoppable();

    public ResolutionResultsStoreFactory(TemporaryFileProvider temp) {
        this(temp, 2000000000);
    }

    ResolutionResultsStoreFactory(TemporaryFileProvider temp, int maxSize) {
        this.temp = temp;
        this.maxSize = maxSize;
    }

    private DefaultBinaryStore createBinaryStore(String storeKey) {
        DefaultBinaryStore store = this.stores.get(storeKey);
        if (store == null || this.isFull(store)) {
            File storeFile = this.temp.createTemporaryFile("gradle", ".bin", new String[0]);
            storeFile.deleteOnExit();
            store = new DefaultBinaryStore(storeFile);
            this.stores.put(storeKey, store);
            this.cleanUpLater.add(new Object[]{store});
        }
        return store;
    }

    public StoreSet createStoreSet() {
        return new StoreSet(){
            int storeSetId;
            int binaryStoreId;
            {
                this.storeSetId = ResolutionResultsStoreFactory.this.storeSetBaseId++;
            }

            @Override
            public DefaultBinaryStore nextBinaryStore() {
                String storeKey = Thread.currentThread().getId() + "-" + this.binaryStoreId++;
                return ResolutionResultsStoreFactory.this.createBinaryStore(storeKey);
            }

            @Override
            public Store<ResolvedComponentResult> newModelCache() {
                if (ResolutionResultsStoreFactory.this.oldModelCache == null) {
                    ResolutionResultsStoreFactory.this.oldModelCache = new CachedStoreFactory("Resolution result");
                    ResolutionResultsStoreFactory.this.cleanUpLater.add(new Object[]{ResolutionResultsStoreFactory.this.oldModelCache});
                }
                return ResolutionResultsStoreFactory.this.oldModelCache.createCachedStore(this.storeSetId);
            }

            @Override
            public Store<TransientConfigurationResults> oldModelCache() {
                if (ResolutionResultsStoreFactory.this.newModelCache == null) {
                    ResolutionResultsStoreFactory.this.newModelCache = new CachedStoreFactory("Resolved configuration");
                    ResolutionResultsStoreFactory.this.cleanUpLater.add(new Object[]{ResolutionResultsStoreFactory.this.newModelCache});
                }
                return ResolutionResultsStoreFactory.this.newModelCache.createCachedStore(this.storeSetId);
            }
        };
    }

    private boolean isFull(DefaultBinaryStore store) {
        return store.getSize() > (long)this.maxSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            Clock clock = new Clock();
            this.cleanUpLater.stop();
            LOG.debug("Deleted {} resolution results binary files in {}", (Object)this.stores.size(), (Object)clock.getTime());
        }
        finally {
            this.oldModelCache = null;
            this.newModelCache = null;
            this.stores.clear();
        }
    }
}

